/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.Util;
import com.google.common.collect.Multimap;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.api.teleport.IItemOfTravel;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.PowerBarOverlayRenderHelper;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.item.darksteel.upgrade.TravelUpgrade;
import crazypants.enderio.teleport.TravelController;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDarkSteelSword
extends ItemSword
implements IAdvancedTooltipProvider,
IDarkSteelItem,
IItemOfTravel,
EnderCoreMethods.IOverlayRenderAware {
    @Nonnull
    public static final String NAME = "darkSteel_sword";
    @Nonnull
    private static final String ENDERZOO_ENDERMINY = "enderzoo.Enderminy";
    static final Item.ToolMaterial MATERIAL = EnumHelper.addToolMaterial((String)"darkSteel", (int)(Config.darkSteelPickMinesTiCArdite ? 5 : 3), (int)2000, (float)8.0f, (float)3.0f, (int)25);
    @Nonnull
    private final AttributeModifier swordDamageModifierPowered = new AttributeModifier(new UUID(63242325L, 320981923L), "Empowered", (double)Config.darkSteelSwordPoweredDamageBonus, 0);
    @Nonnull
    private final AttributeModifier swordAttackSpeedPowered = new AttributeModifier(new UUID(63242325L, 320981923L), "Empowered", (double)Config.darkSteelSwordPoweredSpeedBonus, 0);
    private final int powerPerDamagePoint = Config.darkSteelPowerStorageBase / MATERIAL.func_77997_a();
    private long lastBlickTick = -1L;

    public static boolean isEquipped(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack equipped = player.func_184586_b(hand);
        if (equipped == null) {
            return false;
        }
        return equipped.func_77973_b() == DarkSteelItems.itemDarkSteelSword;
    }

    public static boolean isEquippedAndPowered(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, int requiredPower) {
        if (!ItemDarkSteelSword.isEquipped(player, hand)) {
            return false;
        }
        return EnergyUpgrade.getEnergyStored(player.func_184586_b(hand)) >= requiredPower;
    }

    public static ItemDarkSteelSword create() {
        ItemDarkSteelSword res = new ItemDarkSteelSword();
        res.init();
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    public ItemDarkSteelSword() {
        super(MATERIAL);
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(NAME);
        this.setRegistryName(NAME);
    }

    @Override
    public String getItemName() {
        return NAME;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FOUR.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        TravelUpgrade.INSTANCE.writeToItem(is);
        par3List.add(is);
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 3;
    }

    @SubscribeEvent
    public void onEnderTeleport(EnderTeleportEvent evt) {
        if (evt.getEntityLiving().getEntityData().func_74767_n("hitByDarkSteelSword")) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityDrop(LivingDropsEvent evt) {
        Entity entity = evt.getSource().func_76346_g();
        EntityLivingBase entityLiving = evt.getEntityLiving();
        if (!(entity instanceof EntityPlayer) || entityLiving == null) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (this.handleBeheadingWeapons(player, evt)) {
            return;
        }
        double skullDropChance = this.getSkullDropChance(player, evt);
        if (player instanceof FakePlayer) {
            skullDropChance *= (double)Config.fakePlayerSkullChance;
        }
        if (Math.random() <= skullDropChance) {
            this.dropSkull(evt, player);
        }
        if (ItemDarkSteelSword.isEquipped(player, EnumHand.MAIN_HAND)) {
            String name = EntityList.func_75621_b((Entity)entityLiving);
            if (entityLiving instanceof EntityEnderman || ENDERZOO_ENDERMINY.equals(name)) {
                int numPearls = 0;
                if (Math.random() <= Config.darkSteelSwordEnderPearlDropChance) {
                    ++numPearls;
                }
                for (int i = 0; i < evt.getLootingLevel(); ++i) {
                    if (!(Math.random() <= Config.darkSteelSwordEnderPearlDropChancePerLooting)) continue;
                    ++numPearls;
                }
                int existing = 0;
                for (EntityItem stack : evt.getDrops()) {
                    if (stack.func_92059_d().func_77973_b() != Items.field_151079_bi) continue;
                    existing += stack.func_92059_d().field_77994_a;
                }
                int toDrop = numPearls - existing;
                if (toDrop > 0) {
                    evt.getDrops().add(Util.createDrop((World)player.field_70170_p, (ItemStack)new ItemStack(Items.field_151079_bi, toDrop, 0), (double)entityLiving.field_70165_t, (double)entityLiving.field_70163_u, (double)entityLiving.field_70161_v, (boolean)false));
                }
            }
        }
    }

    protected void dropSkull(LivingDropsEvent evt, EntityPlayer player) {
        ItemStack skull = this.getSkullForEntity(evt.getEntityLiving());
        if (skull != null && !this.containsDrop(evt, skull)) {
            evt.getDrops().add(Util.createEntityItem((World)player.field_70170_p, (ItemStack)skull, (double)evt.getEntityLiving().field_70165_t, (double)evt.getEntityLiving().field_70163_u, (double)evt.getEntityLiving().field_70161_v));
        }
    }

    private boolean handleBeheadingWeapons(EntityPlayer player, LivingDropsEvent evt) {
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.func_184614_ca();
        if (equipped == null) {
            return false;
        }
        NBTTagCompound tagCompound = equipped.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        NBTTagCompound infiToolRoot = tagCompound.func_74775_l("InfiTool");
        boolean isCleaver = "tconstruct.items.tools.Cleaver".equals(equipped.func_77973_b().getClass().getName());
        boolean hasBeheading = infiToolRoot.func_74764_b("Beheading");
        if (!isCleaver && !hasBeheading) {
            return false;
        }
        if (!(evt.getEntityLiving() instanceof EntityEnderman)) {
            return true;
        }
        float fromWeapon = isCleaver ? Config.ticCleaverSkullDropChance : Config.vanillaSwordSkullChance;
        float fromLooting = 0.0f;
        if (hasBeheading) {
            fromLooting = Config.ticBeheadingSkullModifier * (float)infiToolRoot.func_74762_e("Beheading");
        }
        float skullDropChance = fromWeapon + fromLooting;
        if (Math.random() <= (double)skullDropChance) {
            this.dropSkull(evt, player);
        }
        return true;
    }

    private double getSkullDropChance(@Nonnull EntityPlayer player, LivingDropsEvent evt) {
        float fromLooting;
        float fromWeapon;
        if (this.isWitherSkeleton(evt)) {
            if (ItemDarkSteelSword.isEquippedAndPowered(player, EnumHand.MAIN_HAND, Config.darkSteelSwordPowerUsePerHit)) {
                return Config.darkSteelSwordWitherSkullChance + Config.darkSteelSwordWitherSkullLootingModifier * (float)evt.getLootingLevel();
            }
            return 0.01;
        }
        if (ItemDarkSteelSword.isEquippedAndPowered(player, EnumHand.MAIN_HAND, Config.darkSteelSwordPowerUsePerHit)) {
            fromWeapon = Config.darkSteelSwordSkullChance;
            fromLooting = Config.darkSteelSwordSkullLootingModifier * (float)evt.getLootingLevel();
        } else {
            fromWeapon = Config.vanillaSwordSkullChance;
            fromLooting = Config.vanillaSwordSkullLootingModifier * (float)evt.getLootingLevel();
        }
        return fromWeapon + fromLooting;
    }

    protected boolean isWitherSkeleton(LivingDropsEvent evt) {
        return evt.getEntityLiving() instanceof EntitySkeleton && ((EntitySkeleton)evt.getEntityLiving()).func_189771_df() == SkeletonType.WITHER;
    }

    private boolean containsDrop(LivingDropsEvent evt, ItemStack skull) {
        for (EntityItem ei : evt.getDrops()) {
            if (ei == null || ei.func_92059_d().func_77973_b() != skull.func_77973_b() || ei.func_92059_d().func_77952_i() != skull.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    private ItemStack getSkullForEntity(EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntitySkeleton) {
            if (((EntitySkeleton)entityLiving).func_189771_df() == SkeletonType.WITHER) {
                return new ItemStack(Items.field_151144_bL, 1, 1);
            }
            return new ItemStack(Items.field_151144_bL, 1, 0);
        }
        if (entityLiving instanceof EntityZombie) {
            return new ItemStack(Items.field_151144_bL, 1, 2);
        }
        if (entityLiving instanceof EntityCreeper) {
            return new ItemStack(Items.field_151144_bL, 1, 4);
        }
        if (entityLiving instanceof EntityEnderman) {
            return new ItemStack((Block)EnderIO.blockEndermanSkull);
        }
        return null;
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap res = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND && (Config.darkSteelSwordPowerUsePerHit <= 0 || EnergyUpgrade.getEnergyStored(stack) >= Config.darkSteelSwordPowerUsePerHit)) {
            res.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)this.swordDamageModifierPowered);
            res.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)this.swordAttackSpeedPowered);
        }
        return res;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity, EntityLivingBase playerEntity) {
        if (playerEntity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)playerEntity;
            ItemStack sword = player.func_184614_ca();
            EnergyUpgrade eu = EnergyUpgrade.loadFromItem(stack);
            if (eu != null && eu.isAbsorbDamageWithPower(stack) && eu.getEnergy() > 0) {
                eu.extractEnergy(this.powerPerDamagePoint, false);
            } else {
                super.func_77644_a(stack, entity, playerEntity);
            }
            if (eu != null) {
                eu.writeToItem(sword);
                if (eu.getEnergy() > Config.darkSteelSwordPowerUsePerHit) {
                    this.extractEnergy(player.func_184614_ca(), Config.darkSteelSwordPowerUsePerHit, false);
                    String name = EntityList.func_75621_b((Entity)entity);
                    if (entity instanceof EntityEnderman || ENDERZOO_ENDERMINY.equals(name)) {
                        entity.getEntityData().func_74757_a("hitByDarkSteelSword", true);
                    }
                }
            }
        }
        return true;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return EnergyUpgrade.receiveEnergy(container, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return EnergyUpgrade.getEnergyStored(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return EnergyUpgrade.getMaxEnergyStored(container);
    }

    public boolean func_82789_a(ItemStack i1, ItemStack i2) {
        return false;
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        String str;
        if (!Config.addDurabilityTootip) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgrade.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        list.add(TextFormatting.WHITE + EnderIO.lang.localize("item.darkSteel_sword.tooltip.line1"));
        if (EnergyUpgrade.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(TextFormatting.WHITE + EnderIO.lang.localize("item.darkSteel_sword.tooltip.line2"));
            list.add(TextFormatting.WHITE + EnderIO.lang.localize("item.darkSteel_sword.tooltip.line3"));
        }
        DarkSteelRecipeManager.instance.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    @Override
    public boolean isActive(EntityPlayer ep, ItemStack equipped) {
        return ep != null && equipped != null ? this.isTravelUpgradeActive(ep, equipped) : false;
    }

    @Override
    public void extractInternal(ItemStack equipped, int power) {
        this.extractEnergy(equipped, power, false);
    }

    private boolean isTravelUpgradeActive(@Nonnull EntityPlayer ep, @Nonnull ItemStack equipped) {
        return (ItemDarkSteelSword.isEquipped(ep, EnumHand.MAIN_HAND) || ItemDarkSteelSword.isEquipped(ep, EnumHand.OFF_HAND)) && ep.func_70093_af() && TravelUpgrade.loadFromItem(equipped) != null;
    }

    private boolean isTravelUpgradeActive(EntityPlayer ep, ItemStack equipped, EnumHand hand) {
        return ep != null && equipped != null && hand != null && ItemDarkSteelSword.isEquipped(ep, hand) && ep.func_70093_af() && TravelUpgrade.loadFromItem(equipped) != null;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (this.isTravelUpgradeActive(player, stack, hand)) {
            if (world.field_72995_K && TravelController.instance.activateTravelAccessable(stack, hand, world, player, TravelSource.STAFF)) {
                player.func_184609_a(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            long ticksSinceBlink = EnderIO.proxy.getTickCount() - this.lastBlickTick;
            if (ticksSinceBlink < 0L) {
                this.lastBlickTick = -1L;
            }
            if (Config.travelStaffBlinkEnabled && world.field_72995_K && ticksSinceBlink >= (long)Config.travelStaffBlinkPauseTicks && TravelController.instance.doBlink(stack, hand, player)) {
                player.func_184609_a(hand);
                this.lastBlickTick = EnderIO.proxy.getTickCount();
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    public void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack == null || newStack == null || oldStack.func_77973_b() != newStack.func_77973_b();
    }
}

