/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.ItemUtil;
import com.google.common.base.Predicate;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.PowerBarOverlayRenderHelper;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.DarkSteelRecipeManager;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import crazypants.enderio.item.darksteel.ItemDarkSteelSword;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDarkSteelShears
extends ItemShears
implements IEnergyContainerItem,
IAdvancedTooltipProvider,
IDarkSteelItem,
EnderCoreMethods.IOverlayRenderAware {
    public static final String NAME = "darkSteel_shears";
    private final MultiHarvestComparator harvestComparator = new MultiHarvestComparator();
    private final EntityComparator entityComparator = new EntityComparator();
    Predicate<Entity> selectShearable = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity instanceof IShearable && !entity.field_70128_L && ((IShearable)entity).isShearable(null, (IBlockAccess)entity.field_70170_p, entity.func_180425_c());
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj);
        }
    };

    public static boolean isEquipped(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack equipped = player.func_184614_ca();
        if (equipped == null) {
            return false;
        }
        return equipped.func_77973_b() == DarkSteelItems.itemDarkSteelShears;
    }

    public static boolean isEquippedAndPowered(EntityPlayer player, int requiredPower) {
        return ItemDarkSteelShears.getStoredPower(player) > requiredPower;
    }

    public static int getStoredPower(EntityPlayer player) {
        if (!ItemDarkSteelShears.isEquipped(player)) {
            return 0;
        }
        return EnergyUpgrade.getEnergyStored(player.func_184614_ca());
    }

    public static ItemDarkSteelShears create() {
        ItemDarkSteelShears res = new ItemDarkSteelShears();
        MinecraftForge.EVENT_BUS.register((Object)res);
        res.init();
        return res;
    }

    protected ItemDarkSteelShears() {
        this.func_77656_e(this.func_77612_l() * Config.darkSteelShearsDurabilityFactor);
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(NAME);
        this.setRegistryName(NAME);
    }

    @Override
    public String getItemName() {
        return NAME;
    }

    @Override
    public int getIngotsRequiredForFullRepair() {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        ItemStack is = new ItemStack((Item)this);
        par3List.add(is);
        is = new ItemStack((Item)this);
        EnergyUpgrade.EMPOWERED_FOUR.writeToItem(is);
        EnergyUpgrade.setPowerFull(is);
        par3List.add(is);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        int powerStored = ItemDarkSteelShears.getStoredPower(player);
        if (powerStored < Config.darkSteelShearsPowerUsePerDamagePoint) {
            return super.onBlockStartBreak(itemstack, pos, player);
        }
        HarvestResult res = new HarvestResult(null, pos);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int dx = -Config.darkSteelShearsBlockAreaBoostWhenPowered; dx <= Config.darkSteelShearsBlockAreaBoostWhenPowered; ++dx) {
            for (int dy = -Config.darkSteelShearsBlockAreaBoostWhenPowered; dy <= Config.darkSteelShearsBlockAreaBoostWhenPowered; ++dy) {
                for (int dz = -Config.darkSteelShearsBlockAreaBoostWhenPowered; dz <= Config.darkSteelShearsBlockAreaBoostWhenPowered; ++dz) {
                    Block block2 = player.field_70170_p.func_180495_p(new BlockPos(x + dx, y + dy, z + dz)).func_177230_c();
                    if (!(block2 instanceof IShearable) || !((IShearable)block2).isShearable(itemstack, (IBlockAccess)player.field_70170_p, new BlockPos(x + dx, y + dy, z + dz))) continue;
                    res.getHarvestedBlocks().add(new BlockPos(x + dx, y + dy, z + dz));
                }
            }
        }
        ArrayList<BlockPos> sortedTargets = new ArrayList<BlockPos>(res.getHarvestedBlocks());
        this.harvestComparator.refPoint = pos;
        Collections.sort(sortedTargets, this.harvestComparator);
        int maxBlocks = Math.min(sortedTargets.size(), powerStored / Config.darkSteelShearsPowerUsePerDamagePoint);
        for (int i = 0; i < maxBlocks; ++i) {
            BlockPos bc2 = (BlockPos)sortedTargets.get(i);
            super.onBlockStartBreak(itemstack, bc2, player);
            if (bc2 == pos) continue;
            player.field_70170_p.func_175698_g(bc2);
        }
        return false;
    }

    public boolean func_111207_a(ItemStack itemstack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        int powerStored = ItemDarkSteelShears.getStoredPower(player);
        if (powerStored < Config.darkSteelShearsPowerUsePerDamagePoint) {
            return super.func_111207_a(itemstack, player, entity, hand);
        }
        if (entity instanceof IShearable) {
            AxisAlignedBB bb = new AxisAlignedBB(entity.field_70165_t - (double)Config.darkSteelShearsEntityAreaBoostWhenPowered, entity.field_70163_u - (double)Config.darkSteelShearsEntityAreaBoostWhenPowered, entity.field_70161_v - (double)Config.darkSteelShearsEntityAreaBoostWhenPowered, entity.field_70165_t + (double)Config.darkSteelShearsEntityAreaBoostWhenPowered, entity.field_70163_u + (double)Config.darkSteelShearsEntityAreaBoostWhenPowered, entity.field_70161_v + (double)Config.darkSteelShearsEntityAreaBoostWhenPowered);
            ArrayList sortedTargets = new ArrayList(entity.field_70170_p.func_175647_a(Entity.class, bb, this.selectShearable));
            this.entityComparator.refPoint = entity;
            Collections.sort(sortedTargets, this.entityComparator);
            boolean result = false;
            int maxSheep = Math.min(sortedTargets.size(), powerStored / Config.darkSteelShearsPowerUsePerDamagePoint);
            for (int i = 0; i < maxSheep; ++i) {
                Entity entity2 = (Entity)sortedTargets.get(i);
                if (!(entity2 instanceof EntityLivingBase) || !super.func_111207_a(itemstack, player, (EntityLivingBase)entity2, hand)) continue;
                result = true;
            }
            return result;
        }
        return false;
    }

    @SubscribeEvent
    public void onBreakSpeedEvent(PlayerEvent.BreakSpeed evt) {
        if ((double)evt.getOriginalSpeed() > 2.0 && ItemDarkSteelShears.isEquippedAndPowered(evt.getEntityPlayer(), Config.darkSteelShearsPowerUsePerDamagePoint)) {
            evt.setNewSpeed(evt.getOriginalSpeed() * Config.darkSteelShearsEffeciencyBoostWhenPowered);
        }
    }

    public void setDamage(ItemStack stack, int newDamage) {
        int oldDamage = this.getDamage(stack);
        if (newDamage <= oldDamage) {
            super.setDamage(stack, newDamage);
        }
        int damage = newDamage - oldDamage;
        EnergyUpgrade eu = EnergyUpgrade.loadFromItem(stack);
        if (eu != null && eu.isAbsorbDamageWithPower(stack) && eu.getEnergy() > 0) {
            eu.extractEnergy(damage * Config.darkSteelShearsPowerUsePerDamagePoint, false);
        } else {
            super.setDamage(stack, newDamage);
        }
        if (eu != null) {
            eu.writeToItem(stack);
        }
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return EnergyUpgrade.receiveEnergy(container, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return EnergyUpgrade.getEnergyStored(container);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return EnergyUpgrade.getMaxEnergyStored(container);
    }

    public boolean func_82789_a(ItemStack i1, ItemStack i2) {
        return false;
    }

    public int func_77619_b() {
        return ItemDarkSteelSword.MATERIAL.func_77995_e();
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addCommonTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        DarkSteelRecipeManager.instance.addBasicTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        String str;
        if (!Config.addDurabilityTootip) {
            list.add(ItemUtil.getDurabilityString((ItemStack)itemstack));
        }
        if ((str = EnergyUpgrade.getStoredEnergyString(itemstack)) != null) {
            list.add(str);
        }
        if (EnergyUpgrade.itemHasAnyPowerUpgrade(itemstack)) {
            list.add(EnderIO.lang.localize("item.darkSteel_shears.tooltip.multiHarvest"));
            list.add(TextFormatting.WHITE + "+" + Config.darkSteelShearsEffeciencyBoostWhenPowered + " " + EnderIO.lang.localize("item.darkSteel_pickaxe.tooltip.effPowered"));
        }
        DarkSteelRecipeManager.instance.addAdvancedTooltipEntries(itemstack, entityplayer, list, flag);
    }

    public ItemStack createItemStack() {
        return new ItemStack((Item)this);
    }

    public void renderItemOverlayIntoGUI(ItemStack stack, int xPosition, int yPosition) {
        PowerBarOverlayRenderHelper.instance_upgradeable.render(stack, xPosition, yPosition);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack == null || newStack == null || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    private static class EntityComparator
    implements Comparator<Entity> {
        Entity refPoint;

        private EntityComparator() {
        }

        @Override
        public int compare(Entity paramT1, Entity paramT2) {
            double distanceSqToEntity2;
            double distanceSqToEntity1 = this.refPoint.func_70068_e(paramT1);
            if (distanceSqToEntity1 < (distanceSqToEntity2 = this.refPoint.func_70068_e(paramT2))) {
                return -1;
            }
            if (distanceSqToEntity1 > distanceSqToEntity2) {
                return 1;
            }
            return 0;
        }
    }

    private static class MultiHarvestComparator
    implements Comparator<BlockPos> {
        BlockPos refPoint;

        private MultiHarvestComparator() {
        }

        @Override
        public int compare(BlockPos arg0, BlockPos arg1) {
            double d1 = this.refPoint.func_177954_c((double)arg0.func_177958_n(), (double)arg0.func_177956_o(), (double)arg0.func_177952_p());
            double d2 = this.refPoint.func_177954_c((double)arg1.func_177958_n(), (double)arg1.func_177956_o(), (double)arg1.func_177952_p());
            return MultiHarvestComparator.compare(d1, d2);
        }

        public static int compare(double x, double y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

