/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cofh.api.energy.IEnergyContainerItem;
import com.enderio.core.client.ClientUtil;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4d;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.item.darksteel.ItemDarkSteelArmor;
import crazypants.enderio.item.darksteel.PacketDarkSteelPowerPacket;
import crazypants.enderio.item.darksteel.PacketUpgradeState;
import crazypants.enderio.item.darksteel.upgrade.ElytraUpgrade;
import crazypants.enderio.item.darksteel.upgrade.EnergyUpgrade;
import crazypants.enderio.item.darksteel.upgrade.GliderUpgrade;
import crazypants.enderio.item.darksteel.upgrade.JumpUpgrade;
import crazypants.enderio.item.darksteel.upgrade.NightVisionUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SolarUpgrade;
import crazypants.enderio.item.darksteel.upgrade.SpeedController;
import crazypants.enderio.item.darksteel.upgrade.SwimUpgrade;
import crazypants.enderio.item.darksteel.upgrade.TheOneProbeUpgrade;
import crazypants.enderio.machine.solar.TileEntitySolarPanel;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.sound.IModSound;
import crazypants.enderio.sound.SoundHelper;
import crazypants.enderio.sound.SoundRegistry;
import crazypants.util.NullHelper;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DarkSteelController {
    private static final EnumSet<PacketUpgradeState.Type> DEFAULT_ACTIVE = EnumSet.of(PacketUpgradeState.Type.SPEED, PacketUpgradeState.Type.STEP_ASSIST, PacketUpgradeState.Type.JUMP);
    public static final DarkSteelController instance = new DarkSteelController();
    private boolean wasJumping;
    private int jumpCount;
    private int ticksSinceLastJump;
    private final SpeedController speedController;
    private final Map<UUID, EnumSet<PacketUpgradeState.Type>> allActive = new HashMap<UUID, EnumSet<PacketUpgradeState.Type>>();
    private boolean nightVisionActive = false;
    private boolean removeNightvision = false;
    private boolean jumpPre;

    private DarkSteelController() {
        PacketHandler.INSTANCE.registerMessage(PacketDarkSteelPowerPacket.class, PacketDarkSteelPowerPacket.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketUpgradeState.class, PacketUpgradeState.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketUpgradeState.class, PacketUpgradeState.class, PacketHandler.nextID(), Side.CLIENT);
        this.speedController = new SpeedController();
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this.speedController);
    }

    private EnumSet<PacketUpgradeState.Type> getActiveSet(EntityPlayer player) {
        Object active;
        GameProfile gameProfile = player.func_146103_bH();
        UUID id = gameProfile == null ? null : gameProfile.getId();
        Object object = active = id == null ? null : this.allActive.get(id);
        if (active == null) {
            active = DEFAULT_ACTIVE.clone();
            if (id != null) {
                this.allActive.put(id, (EnumSet<PacketUpgradeState.Type>)active);
            }
        }
        return active;
    }

    public boolean isActive(EntityPlayer player, PacketUpgradeState.Type type) {
        return this.getActiveSet(player).contains((Object)type);
    }

    public void setActive(EntityPlayer player, PacketUpgradeState.Type type, boolean isActive) {
        EnumSet<PacketUpgradeState.Type> set = this.getActiveSet(player);
        if (isActive) {
            set.add(type);
        } else {
            set.remove((Object)type);
        }
    }

    public boolean isGlideActive(EntityPlayer player) {
        return this.isActive(player, PacketUpgradeState.Type.GLIDE);
    }

    public boolean isSpeedActive(EntityPlayer player) {
        return this.isActive(player, PacketUpgradeState.Type.SPEED);
    }

    public boolean isStepAssistActive(EntityPlayer player) {
        return this.isActive(player, PacketUpgradeState.Type.STEP_ASSIST);
    }

    public boolean isJumpActive(EntityPlayer player) {
        return this.isActive(player, PacketUpgradeState.Type.JUMP);
    }

    public boolean isElytraActive(EntityPlayer player) {
        return this.isActive(player, PacketUpgradeState.Type.ELYTRA);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (event.phase == TickEvent.Phase.START) {
            this.updateStepHeightAndFallDistance(player);
            this.speedController.updateSpeed(player);
            this.updateGlide(player);
            this.updateSwim(player);
            this.updateSolar(player);
        }
    }

    private void updateSolar(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack helm = player.func_184582_a(EntityEquipmentSlot.HEAD);
        SolarUpgrade upgrade = SolarUpgrade.loadFromItem(helm);
        if (upgrade == null || !player.field_70170_p.func_175710_j(new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)(player.field_70163_u + (double)player.eyeHeight + 0.25)), MathHelper.func_76128_c((double)player.field_70161_v)))) {
            return;
        }
        int RFperSecond = Math.round((float)upgrade.getRFPerSec() * TileEntitySolarPanel.calculateLightRatio(player.field_70170_p));
        int leftover = RFperSecond % 20;
        boolean addExtraRF = player.field_70170_p.func_82737_E() % 20L < (long)leftover;
        int toAdd = RFperSecond / 20 + (addExtraRF ? 1 : 0);
        if (toAdd != 0) {
            int nextIndex = player.getEntityData().func_74762_e("dsarmor:solar") % 4;
            for (int i = 0; i < 4 && toAdd > 0; ++i) {
                ItemStack stack = player.field_71071_by.field_70460_b[nextIndex];
                if (stack != null && (EnergyUpgrade.loadFromItem(stack) != null || Config.darkSteelSolarChargeOthers && stack.func_77973_b() instanceof IEnergyContainerItem)) {
                    toAdd -= ((IEnergyContainerItem)stack.func_77973_b()).receiveEnergy(stack, toAdd, false);
                }
                nextIndex = (nextIndex + 1) % 4;
            }
            player.getEntityData().func_74768_a("dsarmor:solar", nextIndex);
        }
    }

    private void updateSwim(EntityPlayer player) {
        ItemStack boots = player.func_184582_a(EntityEquipmentSlot.FEET);
        SwimUpgrade upgrade = SwimUpgrade.loadFromItem(boots);
        if (upgrade == null) {
            return;
        }
        if (player.func_70090_H() && !player.field_71075_bZ.field_75100_b) {
            player.field_70159_w *= 1.1;
            player.field_70179_y *= 1.1;
        }
    }

    private void updateGlide(EntityPlayer player) {
        if (!this.isGlideActive(player) || !this.isGliderUpgradeEquipped(player)) {
            return;
        }
        if (!player.field_70122_E && player.field_70181_x < 0.0 && !player.func_70093_af() && !player.func_70090_H()) {
            double horizontalSpeed = Config.darkSteelGliderHorizontalSpeed;
            double verticalSpeed = Config.darkSteelGliderVerticalSpeed;
            if (player.func_70051_ag()) {
                verticalSpeed = Config.darkSteelGliderVerticalSpeedSprinting;
            }
            Vector3d look = Util.getLookVecEio((EntityPlayer)player);
            Vector3d side = new Vector3d();
            side.cross(new Vector3d(0.0, 1.0, 0.0), look);
            Vector3d playerPos = new Vector3d(player.field_70169_q, player.field_70167_r, player.field_70166_s);
            Vector3d b = new Vector3d(playerPos);
            b.y += 1.0;
            Vector3d c = new Vector3d(playerPos);
            c.add(side);
            Vector4d plane = new Vector4d();
            VecmathUtil.computePlaneEquation((Vector3d)playerPos, (Vector3d)b, (Vector3d)c, (Vector4d)plane);
            double dist = Math.abs(VecmathUtil.distanceFromPointToPlane((Vector4d)plane, (Vector3d)new Vector3d(player.field_70165_t, player.field_70163_u, player.field_70161_v)));
            double minDist = 0.15;
            if (dist < minDist) {
                double dropRate = minDist * 10.0 - dist * 10.0;
                verticalSpeed += verticalSpeed * dropRate * 8.0;
                horizontalSpeed -= 0.02 * dropRate;
            }
            double x = Math.cos(Math.toRadians(player.field_70759_as + 90.0f)) * horizontalSpeed;
            double z = Math.sin(Math.toRadians(player.field_70759_as + 90.0f)) * horizontalSpeed;
            player.field_70159_w += x;
            player.field_70179_y += z;
            player.field_70181_x = verticalSpeed;
            player.field_70143_R = 0.0f;
        }
    }

    public boolean isGliderUpgradeEquipped(EntityPlayer player) {
        ItemStack chestPlate = player.func_184582_a(EntityEquipmentSlot.CHEST);
        GliderUpgrade glideUpgrade = GliderUpgrade.loadFromItem(chestPlate);
        return glideUpgrade != null;
    }

    public boolean isElytraUpgradeEquipped(EntityPlayer player) {
        ItemStack chestPlate = player.func_184582_a(EntityEquipmentSlot.CHEST);
        return this.isElytraUpgradeEquipped(chestPlate);
    }

    public boolean isElytraUpgradeEquipped(ItemStack chestPlate) {
        ElytraUpgrade glideUpgrade = ElytraUpgrade.loadFromItem(chestPlate);
        return glideUpgrade != null;
    }

    private void updateStepHeightAndFallDistance(EntityPlayer player) {
        JumpUpgrade jumpUpgrade;
        int costedDistance;
        ItemStack boots = player.func_184582_a(EntityEquipmentSlot.FEET);
        if (boots != null && boots.func_77973_b() == DarkSteelItems.itemDarkSteelBoots && !player.field_71075_bZ.field_75101_c && (costedDistance = (int)player.field_70143_R) > 1) {
            int energyCost = costedDistance * Config.darkSteelFallDistanceCost;
            int totalEnergy = this.getPlayerEnergy(player, DarkSteelItems.itemDarkSteelBoots);
            if (totalEnergy > 0 && totalEnergy >= energyCost) {
                this.usePlayerEnergy(player, DarkSteelItems.itemDarkSteelBoots, energyCost);
                player.field_70143_R -= (float)costedDistance;
            }
        }
        if ((jumpUpgrade = JumpUpgrade.loadFromItem(boots)) != null && boots != null && boots.func_77973_b() == DarkSteelItems.itemDarkSteelBoots && this.isStepAssistActive(player)) {
            player.field_70138_W = 1.0023f;
        } else if (player.field_70138_W == 1.0023f) {
            player.field_70138_W = 0.6f;
        }
    }

    public void usePlayerEnergy(EntityPlayer player, ItemDarkSteelArmor armor, int cost) {
        ItemStack stack;
        if (cost == 0) {
            return;
        }
        int remaining = cost;
        if (Config.darkSteelDrainPowerFromInventory) {
            for (ItemStack stack2 : player.field_71071_by.field_70462_a) {
                IEnergyContainerItem cont;
                int used;
                if (stack2 == null || !(stack2.func_77973_b() instanceof IEnergyContainerItem) || (remaining -= (used = (cont = (IEnergyContainerItem)stack2.func_77973_b()).extractEnergy(stack2, remaining, false))) > 0) continue;
                return;
            }
        }
        if (armor != null && remaining > 0 && (stack = player.func_184582_a(armor.field_77881_a)) != null) {
            EnergyUpgrade.extractEnergy(stack, remaining, false);
        }
    }

    public int getPlayerEnergy(EntityPlayer player, ItemDarkSteelArmor armor) {
        int res = 0;
        if (Config.darkSteelDrainPowerFromInventory) {
            for (ItemStack stack : player.field_71071_by.field_70462_a) {
                if (stack == null || !(stack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                IEnergyContainerItem cont = (IEnergyContainerItem)stack.func_77973_b();
                res += cont.extractEnergy(stack, Integer.MAX_VALUE, true);
            }
        }
        if (armor != null) {
            ItemStack stack = player.func_184582_a(armor.field_77881_a);
            res = armor.getEnergyStored(stack);
        }
        return res;
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityPlayerMP) {
            for (PacketUpgradeState.Type type : PacketUpgradeState.Type.values()) {
                PacketHandler.sendTo(new PacketUpgradeState(type, this.isActive((EntityPlayer)event.getTarget(), type), event.getTarget().func_145782_y()), (EntityPlayerMP)event.getEntityPlayer());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            this.jumpPre = player.field_71158_b == null ? false : player.field_71158_b.field_78901_c;
            return;
        }
        this.updateNightvision((EntityPlayer)player);
        if (player.field_71075_bZ.field_75100_b) {
            return;
        }
        MovementInput input = player.field_71158_b;
        boolean jumpHandled = false;
        if (input != null && input.field_78901_c && (!this.wasJumping || this.ticksSinceLastJump > 5)) {
            jumpHandled = this.doJump(player);
        }
        if (!jumpHandled && input != null && input.field_78901_c && !this.jumpPre && !player.field_70122_E && player.field_70181_x < 0.0 && !player.field_71075_bZ.field_75100_b && this.isElytraUpgradeEquipped((EntityPlayer)player) && !this.isElytraActive((EntityPlayer)player)) {
            instance.setActive((EntityPlayer)player, PacketUpgradeState.Type.ELYTRA, true);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketUpgradeState(PacketUpgradeState.Type.ELYTRA, true));
        }
        boolean bl = this.wasJumping = !player.field_70122_E;
        if (!this.wasJumping) {
            this.jumpCount = 0;
        }
        ++this.ticksSinceLastJump;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean doJump(EntityPlayerSP player) {
        if (!this.isJumpActive((EntityPlayer)player)) {
            return false;
        }
        ItemStack boots = player.func_184582_a(EntityEquipmentSlot.FEET);
        JumpUpgrade jumpUpgrade = JumpUpgrade.loadFromItem(boots);
        if (jumpUpgrade == null || boots == null || boots.func_77973_b() != DarkSteelItems.itemDarkSteelBoots) {
            return false;
        }
        boolean autoJump = Minecraft.func_71410_x().field_71474_y.func_74308_b(GameSettings.Options.AUTO_JUMP);
        if (autoJump && this.jumpCount <= 0) {
            ++this.jumpCount;
            return false;
        }
        int autoJumpOffset = autoJump ? 1 : 0;
        int requiredPower = Config.darkSteelBootsJumpPowerCost * (int)Math.pow(this.jumpCount + 1 - autoJumpOffset, 2.5);
        int availablePower = this.getPlayerEnergy((EntityPlayer)player, DarkSteelItems.itemDarkSteelBoots);
        int maxJumps = jumpUpgrade.getLevel() + autoJumpOffset;
        if (availablePower > 0 && requiredPower <= availablePower && this.jumpCount < maxJumps) {
            ++this.jumpCount;
            player.field_70181_x += 0.15 * Config.darkSteelBootsJumpModifier * (double)(this.jumpCount - autoJumpOffset);
            this.ticksSinceLastJump = 0;
            this.usePlayerEnergy((EntityPlayer)player, DarkSteelItems.itemDarkSteelBoots, requiredPower);
            SoundHelper.playSound(player.field_70170_p, (Entity)player, (IModSound)SoundRegistry.JUMP, 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.5f + 0.75f);
            Random rand = player.field_70170_p.field_73012_v;
            for (int i = rand.nextInt(10) + 5; i >= 0; --i) {
                Particle fx = Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.REDSTONE.func_179348_c(), player.field_70165_t + (rand.nextDouble() * 0.5 - 0.25), player.field_70163_u - player.func_70033_W(), player.field_70161_v + (rand.nextDouble() * 0.5 - 0.25), 1.0, 1.0, 1.0, new int[0]);
                ClientUtil.setParticleVelocity((Particle)fx, (double)(player.field_70159_w + (rand.nextDouble() * 0.5 - 0.25)), (double)(player.field_70181_x / 2.0 + rand.nextDouble() * -0.05), (double)(player.field_70179_y + (rand.nextDouble() * 0.5 - 0.25)));
                Minecraft.func_71410_x().field_71452_i.func_78873_a(NullHelper.notnullM(fx, "spawnEffectParticle() failed unexptedly"));
            }
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketDarkSteelPowerPacket(requiredPower, DarkSteelItems.itemDarkSteelBoots.field_77881_a));
            return true;
        }
        return false;
    }

    private void updateNightvision(EntityPlayer player) {
        if (this.isNightVisionUpgradeEquipped(player) && this.nightVisionActive) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 210, 0, true, true));
        }
        if (!this.isNightVisionUpgradeEquipped(player) && this.nightVisionActive) {
            this.nightVisionActive = false;
            this.removeNightvision = true;
        }
        if (this.removeNightvision) {
            player.func_184589_d(MobEffects.field_76439_r);
            this.removeNightvision = false;
        }
    }

    public boolean isNightVisionUpgradeEquipped(EntityPlayer player) {
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        return NightVisionUpgrade.loadFromItem(helmet) != null;
    }

    public void setNightVisionActive(boolean isNightVisionActive) {
        if (this.nightVisionActive && !isNightVisionActive) {
            this.removeNightvision = true;
        }
        this.nightVisionActive = isNightVisionActive;
    }

    public boolean isNightVisionActive() {
        return this.nightVisionActive;
    }

    public boolean isTopUpgradeEquipped(EntityPlayer player) {
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        return TheOneProbeUpgrade.loadFromItem(helmet) != null;
    }

    public void setTopActive(EntityPlayer player, boolean active) {
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        if (active) {
            ItemUtil.getOrCreateNBT((ItemStack)helmet).func_74768_a(TheOneProbeUpgrade.PROBETAG, 1);
        } else {
            ItemUtil.getOrCreateNBT((ItemStack)helmet).func_82580_o(TheOneProbeUpgrade.PROBETAG);
        }
    }

    public boolean isTopActive(EntityPlayer player) {
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        return ItemUtil.getOrCreateNBT((ItemStack)helmet).func_74764_b(TheOneProbeUpgrade.PROBETAG);
    }
}

