/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import crazypants.enderio.config.Config;
import crazypants.enderio.item.ItemMagnet;
import crazypants.enderio.item.PacketMagnetState;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.network.PacketHandler;
import crazypants.util.BaublesUtil;
import crazypants.util.BotaniaUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class MagnetController {
    private static final double collisionDistanceSq = 1.5625;
    private static final double speed = 0.035;
    private static final double speed4 = 0.14;
    private static List<Item> blacklist = null;

    public MagnetController() {
        PacketHandler.INSTANCE.registerMessage(PacketMagnetState.class, PacketMagnetState.class, PacketHandler.nextID(), Side.SERVER);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ActiveMagnet mag = MagnetController.getMagnet(event.player, true);
        if (mag != null && event.player.func_110143_aJ() > 0.0f) {
            this.doHoover(event.player);
            if (event.side == Side.SERVER && event.player.field_70170_p.func_82737_E() % 20L == 0L) {
                ItemMagnet.drainPerSecondPower(mag.item);
                event.player.field_71071_by.func_70299_a(mag.slot, mag.item);
                event.player.field_71071_by.func_70296_d();
            }
        }
    }

    static ActiveMagnet getMagnet(EntityPlayer player, boolean activeOnly) {
        ItemStack[] inv = player.field_71071_by.field_70462_a;
        int maxSlot = Config.magnetAllowInMainInventory ? 36 : 9;
        for (int i = 0; i < maxSlot; ++i) {
            if (!ItemMagnet.isMagnet(inv[i]) || activeOnly && (!ItemMagnet.isActive(inv[i]) || !ItemMagnet.hasPower(inv[i]))) continue;
            return new ActiveMagnet(inv[i], i);
        }
        if (ItemMagnet.isMagnet(player.field_71071_by.field_184439_c[0]) && (!activeOnly || ItemMagnet.isActive(player.field_71071_by.field_184439_c[0]) && ItemMagnet.hasPower(player.field_71071_by.field_184439_c[0]))) {
            return new ActiveMagnet(player.field_71071_by.field_184439_c[0], player.field_71071_by.field_70462_a.length + player.field_71071_by.field_70460_b.length);
        }
        return null;
    }

    public void doHoover(EntityPlayer player) {
        AxisAlignedBB aabb;
        List<Entity> interestingItems;
        if (blacklist == null) {
            MagnetController.initBlacklist();
        }
        if ((interestingItems = this.selectEntitiesWithinAABB(player.field_70170_p, aabb = new AxisAlignedBB(player.field_70165_t - (double)Config.magnetRange, player.field_70163_u - (double)Config.magnetRange, player.field_70161_v - (double)Config.magnetRange, player.field_70165_t + (double)Config.magnetRange, player.field_70163_u + (double)Config.magnetRange, player.field_70161_v + (double)Config.magnetRange))) != null) {
            for (Entity entity : interestingItems) {
                double x = player.field_70165_t + 0.5 - entity.field_70165_t;
                double y = player.field_70163_u + 1.0 - entity.field_70163_u;
                double z = player.field_70161_v + 0.5 - entity.field_70161_v;
                double distance = x * x + y * y + z * z;
                if (distance < 1.5625) {
                    entity.func_70100_b_(player);
                    continue;
                }
                double distancespeed = 0.14 / distance;
                entity.field_70159_w += x * distancespeed;
                entity.field_70181_x = y > 0.0 ? 0.12 : (entity.field_70181_x += y * 0.035);
                entity.field_70179_y += z * distancespeed;
            }
        }
    }

    private static void initBlacklist() {
        blacklist = new ArrayList<Item>();
        for (String name : Config.magnetBlacklist) {
            Item item;
            String[] parts = name.split(":");
            if (parts.length != 2 || (item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(parts[0], parts[1]))) == null) continue;
            blacklist.add(item);
        }
    }

    private static boolean isBlackListed(EntityItem entity) {
        for (Item blacklisted : blacklist) {
            if (blacklisted != entity.func_92059_d().func_77973_b()) continue;
            return true;
        }
        return false;
    }

    private List<Entity> selectEntitiesWithinAABB(World world, AxisAlignedBB bb) {
        ArrayList<Entity> arraylist = null;
        int itemsRemaining = Config.magnetMaxItems;
        if (itemsRemaining <= 0) {
            itemsRemaining = Integer.MAX_VALUE;
        }
        int minChunkX = MathHelper.func_76128_c((double)(bb.field_72340_a / 16.0));
        int maxChunkX = MathHelper.func_76128_c((double)(bb.field_72336_d / 16.0));
        int minChunkZ = MathHelper.func_76128_c((double)(bb.field_72339_c / 16.0));
        int maxChunkZ = MathHelper.func_76128_c((double)(bb.field_72334_f / 16.0));
        int minChunkY = MathHelper.func_76128_c((double)(bb.field_72338_b / 16.0));
        int maxChunkY = MathHelper.func_76128_c((double)(bb.field_72337_e / 16.0));
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                Chunk chunk = world.func_72964_e(chunkX, chunkZ);
                int minChunkYClamped = MathHelper.func_76125_a((int)minChunkY, (int)0, (int)(chunk.func_177429_s().length - 1));
                int maxChunkYClamped = MathHelper.func_76125_a((int)maxChunkY, (int)0, (int)(chunk.func_177429_s().length - 1));
                for (int chunkY = minChunkYClamped; chunkY <= maxChunkYClamped; ++chunkY) {
                    for (Entity entity : chunk.func_177429_s()[chunkY]) {
                        if (entity.field_70128_L) continue;
                        boolean isValidTarget = false;
                        if (entity.func_174813_aQ().func_72326_a(bb)) {
                            if (entity instanceof EntityItem) {
                                isValidTarget = !BotaniaUtil.hasSolegnoliaAround(entity) && !MagnetController.isBlackListed((EntityItem)entity);
                            } else if (entity instanceof EntityXPOrb) {
                                isValidTarget = true;
                            }
                        }
                        if (!(isValidTarget = isValidTarget && !entity.getEntityData().func_74764_b("EIOpuller"))) continue;
                        if (arraylist == null) {
                            arraylist = new ArrayList<Entity>(Config.magnetMaxItems > 0 ? Config.magnetMaxItems : 20);
                        }
                        arraylist.add(entity);
                        if (itemsRemaining-- > 0) continue;
                        return arraylist;
                    }
                }
            }
        }
        return arraylist;
    }

    public static void setMagnetActive(EntityPlayerMP player, PacketMagnetState.SlotType type, int slot, boolean isActive) {
        ItemStack stack = null;
        IInventory baubles = null;
        int dropOff = -1;
        switch (type) {
            case INVENTORY: {
                stack = player.field_71071_by.func_70301_a(slot);
                break;
            }
            case ARMOR: {
                return;
            }
            case BAUBLES: {
                baubles = BaublesUtil.instance().getBaubles((EntityPlayer)player);
                if (baubles == null) break;
                stack = baubles.func_70301_a(slot);
            }
        }
        if (stack == null || stack.func_77973_b() == null || stack.func_77973_b() != DarkSteelItems.itemMagnet || ItemMagnet.isActive(stack) == isActive) {
            return;
        }
        if (!Config.magnetAllowDeactivatedInBaublesSlot && type == PacketMagnetState.SlotType.BAUBLES && !isActive) {
            ItemStack[] inv = player.field_71071_by.field_70462_a;
            for (int i = 0; i < inv.length && dropOff < 0; ++i) {
                if (inv[i] != null) continue;
                dropOff = i;
            }
            if (dropOff < 0) {
                return;
            }
        }
        ItemMagnet.setActive(stack, isActive);
        switch (type) {
            case INVENTORY: {
                player.field_71071_by.func_70299_a(slot, stack);
                player.field_71071_by.func_70296_d();
                break;
            }
            case ARMOR: {
                return;
            }
            case BAUBLES: {
                if (baubles == null) break;
                if (dropOff < 0) {
                    baubles.func_70299_a(slot, stack);
                } else {
                    baubles.func_70299_a(slot, null);
                    player.field_71071_by.func_70299_a(dropOff, stack);
                }
                player.field_71071_by.func_70296_d();
            }
        }
    }

    static class ActiveMagnet {
        ItemStack item;
        int slot;

        ActiveMagnet(ItemStack item, int slot) {
            this.item = item;
            this.slot = slot;
        }
    }
}

