/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item;

import buildcraft.api.tools.IToolWrench;
import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.tool.IConduitControl;
import crazypants.enderio.api.tool.ITool;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.KeyTracker;
import crazypants.enderio.item.YetaWrenchPacketProcessor;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.paint.YetaUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="buildcraft.api.tools.IToolWrench", modid="BuildCraftAPI|core")})
public class ItemYetaWrench
extends Item
implements ITool,
IConduitControl,
IAdvancedTooltipProvider,
IToolWrench {
    public static ItemYetaWrench create() {
        if (Config.useSneakMouseWheelYetaWrench) {
            PacketHandler.INSTANCE.registerMessage(YetaWrenchPacketProcessor.class, YetaWrenchPacketProcessor.class, PacketHandler.nextID(), Side.SERVER);
        }
        ItemYetaWrench result = new ItemYetaWrench();
        GameRegistry.register((IForgeRegistryEntry)result);
        return result;
    }

    protected ItemYetaWrench() {
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(ModObject.itemYetaWrench.getUnlocalisedName());
        this.setRegistryName(ModObject.itemYetaWrench.getUnlocalisedName());
        this.func_77625_d(1);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        BlockEio beio;
        IBlockState blockState;
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        IBlockState bs = blockState = world.func_180495_p(pos);
        Block block = bs.func_177230_c();
        boolean ret = false;
        if (block != null) {
            IBlockState paintSource;
            PlayerInteractEvent.RightClickBlock e = new PlayerInteractEvent.RightClickBlock(player, hand, player.func_184586_b(hand), pos, side, new Vec3d((double)hitX, (double)hitY, (double)hitZ));
            if (MinecraftForge.EVENT_BUS.post((Event)e) || e.getResult() == Event.Result.DENY || e.getUseBlock() == Event.Result.DENY || e.getUseItem() == Event.Result.DENY) {
                return EnumActionResult.PASS;
            }
            if (!player.func_70093_af() && block.rotateBlock(world, pos, side)) {
                ret = true;
            } else if (block instanceof IPaintable.IBlockPaintableBlock && !player.func_70093_af() && !YetaUtil.shouldHeldItemHideFacades(player) && (paintSource = ((IPaintable.IBlockPaintableBlock)block).getPaintSource(blockState, (IBlockAccess)world, pos)) != null) {
                IBlockState rotatedPaintSource = PainterUtil2.rotate(paintSource);
                if (rotatedPaintSource != paintSource) {
                    ((IPaintable.IBlockPaintableBlock)block).setPaintSource(blockState, (IBlockAccess)world, pos, rotatedPaintSource);
                }
                ret = true;
            }
        }
        if (!ret && player.func_70093_af() && block instanceof BlockEio && (beio = (BlockEio)block).shouldWrench(world, pos, player, side)) {
            beio.func_180639_a(world, pos, bs, player, hand, player.func_184586_b(hand), side, hitX, hitY, hitZ);
            ret = true;
        }
        if (ret) {
            player.func_184609_a(hand);
        }
        return ret ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack equipped, World world, EntityPlayer player, EnumHand hand) {
        if (!Config.useSneakRightClickYetaWrench) {
            return new ActionResult(EnumActionResult.PASS, (Object)equipped);
        }
        if (!player.func_70093_af()) {
            return new ActionResult(EnumActionResult.PASS, (Object)equipped);
        }
        ConduitDisplayMode curMode = ConduitDisplayMode.getDisplayMode(equipped);
        if (curMode == null) {
            curMode = ConduitDisplayMode.ALL;
        }
        ConduitDisplayMode newMode = curMode.next();
        ConduitDisplayMode.setDisplayMode(equipped, newMode);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)equipped);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        IBlockState bs = player.field_70170_p.func_180495_p(pos);
        Block block = bs.func_177230_c();
        if (player.func_70093_af() && block == EnderIO.blockConduitBundle && player.field_71075_bZ.field_75098_d) {
            block.func_180649_a(player.field_70170_p, pos, player);
            return true;
        }
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean canUse(ItemStack stack, EntityPlayer player, BlockPos pos) {
        return true;
    }

    @Override
    public void used(ItemStack stack, EntityPlayer player, BlockPos pos) {
    }

    @Override
    public boolean shouldHideFacades(ItemStack stack, EntityPlayer player) {
        ConduitDisplayMode curMode = ConduitDisplayMode.getDisplayMode(stack);
        return curMode != ConduitDisplayMode.NONE;
    }

    @Override
    public boolean showOverlay(ItemStack stack, EntityPlayer player) {
        return true;
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        ArrayList tmp = new ArrayList();
        SpecialTooltipHandler.addDetailedTooltipFromResources(tmp, (String)this.func_77658_a());
        String keyName = KeyTracker.instance.getYetaWrenchMode().getDisplayName();
        for (String line : tmp) {
            list.add(String.format(line, keyName));
        }
    }

    @Optional.Method(modid="BuildCraftAPI|core")
    public boolean canWrench(EntityPlayer arg0, BlockPos arg1) {
        return true;
    }

    @Optional.Method(modid="BuildCraftAPI|core")
    public boolean canWrench(EntityPlayer arg0, Entity arg1) {
        return false;
    }

    @Optional.Method(modid="BuildCraftAPI|core")
    public void wrenchUsed(EntityPlayer player, BlockPos pos) {
        this.used(player.func_184614_ca(), player, pos);
    }

    @Optional.Method(modid="BuildCraftAPI|core")
    public void wrenchUsed(EntityPlayer player, Entity arg1) {
    }
}

