/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.fluid;

import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.BlockFluidEio;
import crazypants.enderio.fluid.Buckets;
import crazypants.enderio.fluid.FluidFuelRegister;
import crazypants.enderio.machine.generator.zombie.PacketNutrientTank;
import crazypants.enderio.network.PacketHandler;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Fluids {
    public static final String NUTRIENT_DISTILLATION_NAME = "nutrient_distillation";
    public static final String ENDER_DISTILLATION_NAME = "ender_distillation";
    public static final String HOOTCH_NAME = "hootch";
    public static final String ROCKET_FUEL_NAME = "rocket_fuel";
    public static final String FIRE_WATER_NAME = "fire_water";
    public static final String XP_JUICE_NAME = "xpjuice";
    public static final String LIQUID_SUNSHINE_NAME = "liquid_sunshine";
    public static final String CLOUD_SEED_NAME = "cloud_seed";
    public static final String CLOUD_SEED_CONCENTRATED_NAME = "cloud_seed_concentrated";
    public static Fluid fluidNutrientDistillation;
    public static BlockFluidEio blockNutrientDistillation;
    public static Fluid fluidHootch;
    public static BlockFluidEio blockHootch;
    public static Fluid fluidRocketFuel;
    public static BlockFluidEio blockRocketFuel;
    public static Fluid fluidFireWater;
    public static BlockFluidEio blockFireWater;
    public static Fluid fluidLiquidSunshine;
    public static Fluid fluidCloudSeed;
    public static Fluid fluidCloudSeedConcentrated;
    public static BlockFluidEio blockLiquidSunshine;
    public static BlockFluidEio blockCloudSeed;
    public static BlockFluidEio blockCloudSeedConcentrated;
    public static Fluid fluidEnderDistillation;
    public static BlockFluidEio blockEnderDistillation;
    public static Fluid fluidXpJuice;

    public static ResourceLocation getStill(String fluidName) {
        return new ResourceLocation(EnderIO.DOMAIN, "blocks/" + fluidName + "_still");
    }

    public static ResourceLocation getFlowing(String fluidName) {
        return new ResourceLocation(EnderIO.DOMAIN, "blocks/" + fluidName + "_flow");
    }

    public static ResourceLocation getRaw(String fluidName) {
        return new ResourceLocation(EnderIO.DOMAIN, "blocks/" + fluidName);
    }

    public static String toCapactityString(IFluidTank tank) {
        if (tank == null) {
            return "0/0 " + Fluids.MB();
        }
        return tank.getFluidAmount() + "/" + tank.getCapacity() + " " + Fluids.MB();
    }

    public static String MB() {
        return EnderIO.lang.localize("fluid.millibucket.abr");
    }

    public void registerFluids() {
        Fluid f = new Fluid(NUTRIENT_DISTILLATION_NAME, Fluids.getStill(NUTRIENT_DISTILLATION_NAME), Fluids.getFlowing(NUTRIENT_DISTILLATION_NAME)).setDensity(1500).setViscosity(3000);
        FluidRegistry.registerFluid((Fluid)f);
        fluidNutrientDistillation = FluidRegistry.getFluid((String)f.getName());
        blockNutrientDistillation = BlockFluidEio.create(fluidNutrientDistillation, Material.field_151586_h);
        PacketHandler.INSTANCE.registerMessage(PacketNutrientTank.class, PacketNutrientTank.class, PacketHandler.nextID(), Side.CLIENT);
        f = new Fluid(ENDER_DISTILLATION_NAME, Fluids.getStill(ENDER_DISTILLATION_NAME), Fluids.getFlowing(ENDER_DISTILLATION_NAME)).setDensity(200).setViscosity(1000).setTemperature(175);
        FluidRegistry.registerFluid((Fluid)f);
        fluidEnderDistillation = FluidRegistry.getFluid((String)f.getName());
        blockEnderDistillation = BlockFluidEio.create(fluidEnderDistillation, Material.field_151586_h);
        f = new Fluid(HOOTCH_NAME, Fluids.getStill(HOOTCH_NAME), Fluids.getFlowing(HOOTCH_NAME)).setDensity(900).setViscosity(1000);
        FluidRegistry.registerFluid((Fluid)f);
        fluidHootch = FluidRegistry.getFluid((String)f.getName());
        blockHootch = BlockFluidEio.create(fluidHootch, Material.field_151586_h);
        FluidFuelRegister.instance.addFuel(f, Config.hootchPowerPerCycleRF, Config.hootchPowerTotalBurnTime);
        FMLInterModComms.sendMessage((String)"Railcraft", (String)"boiler-fuel-liquid", (String)("hootch@" + Config.hootchPowerPerCycleRF / 10 * Config.hootchPowerTotalBurnTime));
        f = new Fluid(ROCKET_FUEL_NAME, Fluids.getStill(ROCKET_FUEL_NAME), Fluids.getFlowing(ROCKET_FUEL_NAME)).setDensity(900).setViscosity(1000);
        FluidRegistry.registerFluid((Fluid)f);
        fluidRocketFuel = FluidRegistry.getFluid((String)f.getName());
        blockRocketFuel = BlockFluidEio.create(fluidRocketFuel, Material.field_151586_h);
        FluidFuelRegister.instance.addFuel(f, Config.rocketFuelPowerPerCycleRF, Config.rocketFuelPowerTotalBurnTime);
        FMLInterModComms.sendMessage((String)"Railcraft", (String)"boiler-fuel-liquid", (String)("rocket_fuel@" + Config.rocketFuelPowerPerCycleRF / 10 * Config.rocketFuelPowerTotalBurnTime));
        f = new Fluid(FIRE_WATER_NAME, Fluids.getStill(FIRE_WATER_NAME), Fluids.getFlowing(FIRE_WATER_NAME)).setDensity(900).setViscosity(1000);
        FluidRegistry.registerFluid((Fluid)f);
        fluidFireWater = FluidRegistry.getFluid((String)f.getName());
        blockFireWater = BlockFluidEio.create(fluidFireWater, Material.field_151587_i);
        FluidFuelRegister.instance.addFuel(f, Config.fireWaterPowerPerCycleRF, Config.fireWaterPowerTotalBurnTime);
        FMLInterModComms.sendMessage((String)"Railcraft", (String)"boiler-fuel-liquid", (String)("fire_water@" + Config.fireWaterPowerPerCycleRF / 10 * Config.fireWaterPowerTotalBurnTime));
        f = new Fluid(LIQUID_SUNSHINE_NAME, Fluids.getStill(LIQUID_SUNSHINE_NAME), Fluids.getFlowing(LIQUID_SUNSHINE_NAME)).setDensity(200).setViscosity(400);
        FluidRegistry.registerFluid((Fluid)f);
        fluidLiquidSunshine = FluidRegistry.getFluid((String)f.getName());
        blockLiquidSunshine = BlockFluidEio.create(fluidLiquidSunshine, Material.field_151586_h);
        blockLiquidSunshine.func_149715_a(1.0f);
        f = new Fluid(CLOUD_SEED_NAME, Fluids.getStill(CLOUD_SEED_NAME), Fluids.getFlowing(CLOUD_SEED_NAME)).setDensity(500).setViscosity(800);
        FluidRegistry.registerFluid((Fluid)f);
        fluidCloudSeed = FluidRegistry.getFluid((String)f.getName());
        blockCloudSeed = BlockFluidEio.create(fluidCloudSeed, Material.field_151586_h);
        f = new Fluid(CLOUD_SEED_CONCENTRATED_NAME, Fluids.getStill(CLOUD_SEED_CONCENTRATED_NAME), Fluids.getFlowing(CLOUD_SEED_CONCENTRATED_NAME)).setDensity(1000).setViscosity(1200);
        FluidRegistry.registerFluid((Fluid)f);
        fluidCloudSeedConcentrated = FluidRegistry.getFluid((String)f.getName());
        blockCloudSeedConcentrated = BlockFluidEio.create(fluidCloudSeedConcentrated, Material.field_151586_h);
        if (!Loader.isModLoaded((String)"OpenBlocks")) {
            Log.info("XP Juice registered by Ender IO.");
            fluidXpJuice = new Fluid(Config.xpJuiceName, Fluids.getRaw("xpjuicestill"), Fluids.getRaw("xpjuiceflowing")).setLuminosity(10).setDensity(800).setViscosity(1500).setUnlocalizedName("eio.xpjuice");
            FluidRegistry.registerFluid((Fluid)fluidXpJuice);
        } else {
            Log.info("XP Juice regististration left to Open Blocks.");
        }
        Buckets.createBuckets();
    }

    public void forgeRegisterXPJuice() {
        fluidXpJuice = FluidRegistry.getFluid((String)Fluids.getXPJuiceName());
        if (fluidXpJuice == null) {
            Log.error("Liquid XP Juice registration left to open blocks but could not be found.");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.registerFluidBlockRendering(fluidNutrientDistillation, NUTRIENT_DISTILLATION_NAME);
        this.registerFluidBlockRendering(fluidEnderDistillation, ENDER_DISTILLATION_NAME);
        this.registerFluidBlockRendering(fluidHootch, HOOTCH_NAME);
        this.registerFluidBlockRendering(fluidFireWater, FIRE_WATER_NAME);
        this.registerFluidBlockRendering(fluidRocketFuel, ROCKET_FUEL_NAME);
        this.registerFluidBlockRendering(fluidLiquidSunshine, LIQUID_SUNSHINE_NAME);
        this.registerFluidBlockRendering(fluidCloudSeed, CLOUD_SEED_NAME);
        this.registerFluidBlockRendering(fluidCloudSeedConcentrated, CLOUD_SEED_CONCENTRATED_NAME);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerFluidBlockRendering(Fluid fluid, String name) {
        FluidStateMapper mapper = new FluidStateMapper(fluid);
        Block block = fluid.getBlock();
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        }
        if (block != null) {
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onIconLoad(TextureStitchEvent.Pre event) {
        if (fluidXpJuice != null) {
            event.getMap().func_174942_a(fluidXpJuice.getStill());
            event.getMap().func_174942_a(fluidXpJuice.getFlowing());
        }
    }

    private static String getXPJuiceName() {
        String openBlocksXPJuiceName = null;
        try {
            Field getField = Class.forName("openblocks.Config").getField("xpFluidId");
            openBlocksXPJuiceName = (String)getField.get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (openBlocksXPJuiceName != null && !Config.xpJuiceName.equals(openBlocksXPJuiceName)) {
            Log.info("Overwriting XP Juice name with '" + openBlocksXPJuiceName + "' taken from OpenBlocks' config");
            return openBlocksXPJuiceName;
        }
        return Config.xpJuiceName;
    }

    public static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final Fluid fluid;
        public final ModelResourceLocation location;

        public FluidStateMapper(Fluid fluid) {
            this.fluid = fluid;
            this.location = new ModelResourceLocation("EnderIO".toLowerCase() + ":fluids", fluid.getName());
        }

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return this.location;
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.location;
        }
    }
}

