/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.fluid;

import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.Fluids;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class BlockFluidEio
extends BlockFluidClassic {
    protected Fluid fluid;

    public static BlockFluidEio create(Fluid fluid, Material material) {
        BlockFluidEio res = new BlockFluidEio(fluid, material);
        res.init();
        fluid.setBlock((Block)res);
        return res;
    }

    protected BlockFluidEio(Fluid fluid, Material material) {
        super(fluid, material);
        this.fluid = fluid;
        this.func_149663_c(fluid.getUnlocalizedName());
        this.setRegistryName("block" + StringUtils.capitalize((String)this.fluidName));
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        IBlockState bs = world.func_180495_p(pos);
        if (bs.func_185904_a().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        IBlockState bs = world.func_180495_p(pos);
        if (bs.func_185904_a().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, pos);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity.field_70170_p.field_72995_K) {
            super.func_180634_a(world, pos, state, entity);
            return;
        }
        if (this == Fluids.blockFireWater) {
            entity.func_70015_d(50);
        } else if (this == Fluids.blockRocketFuel && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76430_j, 150, 3, true, true));
        } else if (this == Fluids.blockNutrientDistillation && entity instanceof EntityPlayerMP) {
            long time = entity.field_70170_p.func_82737_E();
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (time % Config.nutrientFoodBoostDelay == 0L && player.getEntityData().func_74763_f("eioLastFoodBoost") != time) {
                player.func_71024_bL().func_75122_a(1, 0.1f);
                player.getEntityData().func_74772_a("eioLastFoodBoost", time);
            }
        } else if (this == Fluids.blockHootch && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 150, 0, true, true));
        } else if (this == Fluids.blockLiquidSunshine && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_188424_y, 50, 0, true, true));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_188423_x, 1200, 0, true, true));
        } else if (this == Fluids.blockCloudSeedConcentrated && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 40, 0, true, true));
        }
        super.func_180634_a(world, pos, state, entity);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (tab != null) {
            super.func_149666_a(itemIn, tab, list);
        }
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this == Fluids.blockRocketFuel || this == Fluids.blockHootch || this == Fluids.blockFireWater;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return this == Fluids.blockRocketFuel || this == Fluids.blockHootch || this == Fluids.blockFireWater;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this == Fluids.blockHootch ? 1 : super.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this == Fluids.blockRocketFuel || this == Fluids.blockHootch || this == Fluids.blockFireWater ? 60 : super.getFireSpreadSpeed(world, pos, face);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        this.checkForFire(worldIn, pos);
        super.func_189540_a(state, worldIn, pos, blockIn);
    }

    protected void checkForFire(World worldIn, BlockPos pos) {
        if (Config.rocketFuelIsExplosive && this == Fluids.blockRocketFuel) {
            for (EnumFacing side : EnumFacing.values()) {
                IBlockState neighbor = worldIn.func_180495_p(pos.func_177972_a(side));
                if (!(neighbor.func_177230_c() instanceof BlockFire) || !(worldIn.field_73012_v.nextFloat() < 0.5f)) continue;
                ArrayList<BlockPos> explosions = new ArrayList<BlockPos>();
                explosions.add(pos);
                BlockPos up = pos.func_177984_a();
                while (worldIn.func_180495_p(up).func_177230_c() == this) {
                    explosions.add(up);
                    up = up.func_177984_a();
                }
                if (this.isSourceBlock((IBlockAccess)worldIn, pos)) {
                    worldIn.func_72885_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 2.0f, true, true);
                }
                float strength = 0.5f;
                for (BlockPos explosion : explosions) {
                    worldIn.func_72885_a(null, (double)((float)explosion.func_177958_n() + 0.5f), (double)((float)explosion.func_177956_o() + 0.5f), (double)((float)explosion.func_177952_p() + 0.5f), strength, true, true);
                    strength = Math.min(strength * 1.05f, 7.0f);
                }
                return;
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.checkForFire(world, pos);
        super.func_180650_b(world, pos, state, rand);
    }
}

