/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.enderface;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.enderface.PacketLockClientContainer;
import crazypants.enderio.enderface.PacketOpenServerGUI;
import crazypants.enderio.enderface.TileEnderIO;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.render.TextureRegistry;
import crazypants.enderio.teleport.anchor.BlockTravelAnchor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnderIO
extends BlockEio<TileEnderIO>
implements IResourceTooltipProvider {
    public static final TextureRegistry.TextureSupplier selectedOverlayIcon = TextureRegistry.registerTexture("blocks/enderIOSelected");
    public static final TextureRegistry.TextureSupplier highlightOverlayIcon = TextureRegistry.registerTexture("blocks/enderIOHighlight");
    public static final TextureRegistry.TextureSupplier enderEyeTex = TextureRegistry.registerTexture("items/ender_eye", false);
    public static final TextureRegistry.TextureSupplier frameIcon = TextureRegistry.registerTexture("blocks/enderIOFrame");

    public static BlockEnderIO create() {
        PacketHandler.INSTANCE.registerMessage(PacketOpenServerGUI.class, PacketOpenServerGUI.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketLockClientContainer.Handler.class, PacketLockClientContainer.class, PacketHandler.nextID(), Side.CLIENT);
        BlockEnderIO result = new BlockEnderIO();
        result.init();
        return result;
    }

    private BlockEnderIO() {
        super(ModObject.blockEnderIo.getUnlocalisedName(), TileEnderIO.class);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack item) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEnderIO) {
            TileEnderIO eio = (TileEnderIO)te;
            eio.initUiPitch = -player.field_70125_A;
            eio.initUiYaw = -player.field_70177_z + 180.0f;
            eio.lastUiPitch = eio.initUiPitch;
            eio.lastUiYaw = eio.initUiYaw;
            if (player instanceof EntityPlayer) {
                eio.setPlacedBy((EntityPlayer)player);
            }
            world.func_184138_a(pos, state, state, 3);
        }
    }

    protected boolean openGui(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ITravelAccessable) {
            ITravelAccessable ta = (ITravelAccessable)te;
            if (ta.canUiBeAccessed(entityPlayer)) {
                entityPlayer.openGui((Object)EnderIO.instance, 18, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                BlockTravelAnchor.sendPrivateChatMessage(entityPlayer, ta.getOwner());
            }
            return true;
        }
        return false;
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    public int getLightValue(IBlockState bs, IBlockAccess world, BlockPos pos) {
        return 13;
    }

    public int func_149717_k(IBlockState bs) {
        return 100;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSelectedOverlayIcon() {
        return selectedOverlayIcon.get(TextureAtlasSprite.class);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getHighlightOverlayIcon() {
        return highlightOverlayIcon.get(TextureAtlasSprite.class);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getFrameIcon() {
        return frameIcon.get(TextureAtlasSprite.class);
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.func_149739_a();
    }
}

