/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.packet;

import crazypants.enderio.conduit.packet.AbstractConduitPacket;
import crazypants.enderio.conduit.packet.ConTypeEnum;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRedstoneConduitOutputStrength
extends AbstractConduitPacket<IRedstoneConduit>
implements IMessageHandler<PacketRedstoneConduitOutputStrength, IMessage> {
    private EnumFacing dir;
    private boolean isStrong;

    public PacketRedstoneConduitOutputStrength() {
    }

    public PacketRedstoneConduitOutputStrength(IRedstoneConduit con, EnumFacing dir) {
        super(con.getBundle().getEntity(), ConTypeEnum.REDSTONE);
        this.dir = dir;
        this.isStrong = con.isOutputStrong(dir);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.dir == null) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(this.dir.ordinal());
        }
        buf.writeBoolean(this.isStrong);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        short ord = buf.readShort();
        this.dir = ord < 0 ? null : EnumFacing.values()[ord];
        this.isStrong = buf.readBoolean();
    }

    public IMessage onMessage(PacketRedstoneConduitOutputStrength message, MessageContext ctx) {
        IRedstoneConduit tile = (IRedstoneConduit)message.getTileCasted(ctx);
        if (tile != null) {
            tile.setOutputStrength(message.dir, message.isStrong);
        }
        return null;
    }
}

