/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import com.enderio.core.common.fluid.IFluidWrapper;
import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.Log;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.liquid.AbstractTankConduit;
import crazypants.enderio.conduit.liquid.AbstractTankConduitNetwork;
import crazypants.enderio.conduit.liquid.ConduitTank;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.liquid.LiquidConduit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;

public class LiquidConduitNetwork
extends AbstractTankConduitNetwork<LiquidConduit> {
    private int ticksEmpty = 0;
    private int maxFlowsPerTick = 10;
    private int lastFlowIndex = 0;
    private boolean printFlowTiming = false;
    private int lastPushToken = 0;
    private boolean inputLocked = false;

    public LiquidConduitNetwork() {
        super(LiquidConduit.class);
    }

    public boolean lockNetworkForFill() {
        if (this.inputLocked) {
            return false;
        }
        this.inputLocked = true;
        return true;
    }

    public void unlockNetworkFromFill() {
        this.inputLocked = false;
    }

    @Override
    public void doNetworkTick() {
        int visc;
        List cons = this.getConduits();
        if (cons == null || cons.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            if (!this.fluidTypeLocked && this.liquidType != null) {
                ++this.ticksEmpty;
                if (this.ticksEmpty > 40) {
                    this.setFluidType(null);
                    this.ticksEmpty = 0;
                }
            }
            return;
        }
        this.ticksEmpty = 0;
        long curTime = ((LiquidConduit)cons.get(0)).getBundle().getEntity().func_145831_w().func_82737_E();
        if (this.liquidType != null && this.liquidType.getFluid() != null && !this.isEmpty() && curTime % (long)((visc = Math.max(1000, this.liquidType.getFluid().getViscosity())) / 500) == 0L) {
            long start = System.nanoTime();
            if (this.doFlow() && this.printFlowTiming) {
                long took = System.nanoTime() - start;
                double secs = (double)took / 1.0E9;
                Log.info("LiquidConduitNetwork.onUpdateEntity: took " + secs + " secs, " + secs * 1000.0 + " millis");
            }
        }
    }

    void addedFromExternal(int res) {
    }

    void outputedToExternal(int filled) {
    }

    int getNextPushToken() {
        return ++this.lastPushToken;
    }

    private boolean doFlow() {
        int pushToken = this.getNextPushToken();
        ArrayList<FlowAction> actions = new ArrayList<FlowAction>();
        for (int i = 0; i < Math.min(this.maxFlowsPerTick, this.conduits.size()); ++i) {
            if (this.lastFlowIndex >= this.conduits.size()) {
                this.lastFlowIndex = 0;
            }
            this.flowFrom((LiquidConduit)this.conduits.get(this.lastFlowIndex), actions, pushToken);
            ++this.lastFlowIndex;
        }
        for (FlowAction action : actions) {
            action.apply();
        }
        boolean result = !actions.isEmpty();
        ArrayList<LiquidConduit> toEmpty = new ArrayList<LiquidConduit>();
        for (LiquidConduit con : this.conduits) {
            if (con != null && con.getTank().getFluidAmount() < 10) {
                toEmpty.add(con);
                continue;
            }
            return result;
        }
        if (toEmpty.isEmpty()) {
            return result;
        }
        ArrayList<LocatedFluidHandler> externals = new ArrayList<LocatedFluidHandler>();
        for (AbstractTankConduit abstractTankConduit : this.conduits) {
            Set<EnumFacing> extCons = abstractTankConduit.getExternalConnections();
            for (EnumFacing dir : extCons) {
                IFluidWrapper externalTank;
                if (!abstractTankConduit.canOutputToDir(dir) || (externalTank = abstractTankConduit.getExternalHandler(dir)) == null) continue;
                externals.add(new LocatedFluidHandler(externalTank, abstractTankConduit.getLocation().getLocation(dir), dir.func_176734_d()));
            }
        }
        if (externals.isEmpty()) {
            return result;
        }
        for (LiquidConduit liquidConduit : toEmpty) {
            this.drainConduitToNearestExternal(liquidConduit, externals);
        }
        return result;
    }

    @Override
    public void setFluidTypeLocked(boolean fluidTypeLocked) {
        super.setFluidTypeLocked(fluidTypeLocked);
        if (!fluidTypeLocked && this.isEmpty()) {
            this.setFluidType(null);
        }
    }

    private boolean isEmpty() {
        for (LiquidConduit con : this.conduits) {
            if (con.tank.getFluidAmount() <= 0) continue;
            return false;
        }
        return true;
    }

    private void drainConduitToNearestExternal(LiquidConduit con, List<LocatedFluidHandler> externals) {
        BlockCoord conLoc = con.getLocation();
        FluidStack toDrain = con.getTank().getFluid();
        if (toDrain == null) {
            return;
        }
        int closestDistance = Integer.MAX_VALUE;
        LocatedFluidHandler closestTank = null;
        for (LocatedFluidHandler lh : externals) {
            int couldFill;
            int distance = lh.bc.getDistSq(conLoc);
            if (distance >= closestDistance || !con.canOutputToDir(lh.dir.func_176734_d()) || (couldFill = lh.tank.offer(toDrain.copy())) <= 0) continue;
            closestTank = lh;
            closestDistance = distance;
        }
        if (closestTank != null) {
            int filled = closestTank.tank.fill(toDrain.copy());
            con.getTank().addAmount(-filled);
        }
    }

    private void flowFrom(LiquidConduit con, List<FlowAction> actions, int pushPoken) {
        ConduitTank tank = con.getTank();
        int totalAmount = tank.getFluidAmount();
        if (totalAmount <= 0) {
            return;
        }
        int maxFlowVolume = 20;
        if (con.getConduitConnections().contains(EnumFacing.DOWN)) {
            BlockCoord loc = con.getLocation().getLocation(EnumFacing.DOWN);
            ILiquidConduit dc = ConduitUtil.getConduit(con.getBundle().getEntity().func_145831_w(), loc.x, loc.y, loc.z, ILiquidConduit.class);
            if (dc instanceof LiquidConduit) {
                int filled;
                LiquidConduit downCon = (LiquidConduit)dc;
                int actual = filled = downCon.fill(EnumFacing.UP, tank.getFluid().copy(), false, false, pushPoken);
                actual = Math.min(actual, tank.getFluidAmount());
                actual = Math.min(actual, downCon.getTank().getAvailableSpace());
                tank.addAmount(-actual);
                downCon.getTank().addAmount(actual);
            }
        }
        if ((totalAmount = tank.getFluidAmount()) <= 0) {
            return;
        }
        FluidStack available = tank.getFluid();
        int totalRequested = 0;
        int numRequests = 0;
        for (EnumFacing dir : con.getExternalConnections()) {
            int amount;
            Object extCon;
            if (!con.canOutputToDir(dir) || (extCon = con.getExternalHandler(dir)) == null || (amount = extCon.offer(available.copy())) <= 0) continue;
            totalRequested += amount;
            ++numRequests;
        }
        if (numRequests > 0) {
            int amountPerRequest = Math.min(totalAmount, totalRequested) / numRequests;
            amountPerRequest = Math.min(maxFlowVolume, amountPerRequest);
            FluidStack requestSource = available.copy();
            requestSource.amount = amountPerRequest;
            for (EnumFacing dir : con.getExternalConnections()) {
                int amount;
                IFluidWrapper extCon;
                if (!con.canOutputToDir(dir) || (extCon = con.getExternalHandler(dir)) == null || (amount = extCon.fill(requestSource.copy())) <= 0) continue;
                this.outputedToExternal(amount);
                tank.addAmount(-amount);
            }
        }
        if ((totalAmount = tank.getFluidAmount()) <= 0) {
            return;
        }
        int totalCapacity = tank.getCapacity();
        BlockCoord loc = con.getLocation();
        Collection<ILiquidConduit> connections = ConduitUtil.getConnectedConduits(con.getBundle().getEntity().func_145831_w(), loc.x, loc.y, loc.z, ILiquidConduit.class);
        for (ILiquidConduit n : connections) {
            LiquidConduit neighbour = (LiquidConduit)n;
            if (!this.canFlowTo(con, neighbour)) continue;
            totalAmount += neighbour.getTank().getFluidAmount();
            totalCapacity += neighbour.getTank().getCapacity();
        }
        float targetRatio = (float)totalAmount / (float)totalCapacity;
        int flowVolume = (int)Math.floor((targetRatio - tank.getFilledRatio()) * (float)tank.getCapacity());
        if (Math.abs(flowVolume = Math.min(maxFlowVolume, flowVolume)) < 2) {
            return;
        }
        for (ILiquidConduit n : connections) {
            LiquidConduit neigbour = (LiquidConduit)n;
            if (!this.canFlowTo(con, neigbour) || (flowVolume = (int)Math.floor((targetRatio - neigbour.getTank().getFilledRatio()) * (float)neigbour.getTank().getCapacity())) == 0) continue;
            actions.add(new FlowAction(con, neigbour, flowVolume));
        }
    }

    private boolean canFlowTo(LiquidConduit con, LiquidConduit neighbour) {
        if (con == null || neighbour == null) {
            return false;
        }
        if (neighbour.getNetwork() != this) {
            return false;
        }
        if (neighbour.getLocation().y > con.getLocation().y) {
            return false;
        }
        float nr = neighbour.getTank().getFilledRatio();
        return !(nr >= con.getTank().getFilledRatio());
    }

    static class LocatedFluidHandler {
        final IFluidWrapper tank;
        final BlockCoord bc;
        final EnumFacing dir;

        LocatedFluidHandler(IFluidWrapper tank, BlockCoord bc, EnumFacing dir) {
            this.tank = tank;
            this.bc = bc;
            this.dir = dir;
        }
    }

    static class FlowAction {
        final LiquidConduit from;
        final LiquidConduit to;
        final int amount;

        FlowAction(LiquidConduit fromIn, LiquidConduit toIn, int amountIn) {
            if (amountIn < 0) {
                this.to = fromIn;
                this.from = toIn;
                this.amount = -amountIn;
            } else {
                this.to = toIn;
                this.from = fromIn;
                this.amount = amountIn;
            }
        }

        void apply() {
            if (this.amount != 0) {
                int actual = Math.min(this.amount, this.from.getTank().getFluidAmount());
                actual = Math.min(actual, this.to.getTank().getAvailableSpace());
                if (this.from != null && this.to != null) {
                    this.from.getTank().addAmount(-actual);
                    this.to.getTank().addAmount(actual);
                }
            }
        }
    }
}

