/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.TileEntityBase;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.Util;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.tool.ITool;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.conduit.ConduitNetworkTickHandler;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.IConduitItem;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.enderio.conduit.facade.EnumFacadeType;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitConnectorType;
import crazypants.enderio.conduit.gui.ExternalConnectionContainer;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.GuiExternalConnectionSelector;
import crazypants.enderio.conduit.gui.PacketFluidFilter;
import crazypants.enderio.conduit.gui.PacketOpenConduitUI;
import crazypants.enderio.conduit.gui.PacketSlotVisibility;
import crazypants.enderio.conduit.gui.item.PacketExistingItemFilterSnapshot;
import crazypants.enderio.conduit.gui.item.PacketModItemFilter;
import crazypants.enderio.conduit.liquid.PacketFluidLevel;
import crazypants.enderio.conduit.packet.PacketConnectionMode;
import crazypants.enderio.conduit.packet.PacketExtractMode;
import crazypants.enderio.conduit.packet.PacketItemConduitFilter;
import crazypants.enderio.conduit.packet.PacketOCConduitSignalColor;
import crazypants.enderio.conduit.packet.PacketRedstoneConduitOutputStrength;
import crazypants.enderio.conduit.packet.PacketRedstoneConduitSignalColor;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.conduit.render.ConduitRenderMapper;
import crazypants.enderio.item.ItemConduitProbe;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.PainterUtil2;
import crazypants.enderio.render.SmartModelAttacher;
import crazypants.enderio.tool.ToolUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockConduitBundle
extends BlockEio<TileConduitBundle>
implements IGuiHandler,
IPaintable.IBlockPaintableBlock,
IPaintable.IWrenchHideablePaint {
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite lastRemovedComponetIcon;
    private final Random rand = new Random();
    private AxisAlignedBB bounds;

    public static BlockConduitBundle create() {
        MinecraftForge.EVENT_BUS.register((Object)ConduitNetworkTickHandler.instance);
        PacketHandler.INSTANCE.registerMessage(PacketFluidLevel.class, PacketFluidLevel.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketExtractMode.class, PacketExtractMode.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketConnectionMode.class, PacketConnectionMode.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketItemConduitFilter.class, PacketItemConduitFilter.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketExistingItemFilterSnapshot.class, PacketExistingItemFilterSnapshot.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketModItemFilter.class, PacketModItemFilter.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketFluidFilter.class, PacketFluidFilter.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketRedstoneConduitSignalColor.class, PacketRedstoneConduitSignalColor.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketRedstoneConduitOutputStrength.class, PacketRedstoneConduitOutputStrength.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketOpenConduitUI.class, PacketOpenConduitUI.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketSlotVisibility.class, PacketSlotVisibility.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketOCConduitSignalColor.class, PacketOCConduitSignalColor.class, PacketHandler.nextID(), Side.SERVER);
        BlockConduitBundle result = new BlockConduitBundle();
        result.init();
        MinecraftForge.EVENT_BUS.register((Object)result);
        return result;
    }

    protected BlockConduitBundle() {
        super(ModObject.blockConduitBundle.getUnlocalisedName(), TileConduitBundle.class);
        this.setBlockBounds(0.334, 0.334, 0.334, 0.667, 0.667, 0.667);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149647_a(null);
        SoundType curType = this.func_185467_w();
        SoundEvent silent = new SoundEvent(new ResourceLocation(EnderIO.DOMAIN, "silence"));
        this.func_149672_a(new SoundType(curType.field_185860_m, curType.field_185861_n, silent, silent, curType.func_185841_e(), silent, curType.func_185842_g()));
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    private void setBlockBounds(double f, double g, double h, double i, double j, double k) {
        this.bounds = new AxisAlignedBB(f, g, h, i, j, k);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.bounds;
    }

    protected void init() {
        super.init();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            EnderIO.guiHandler.registerGuiHandler(9 + dir.ordinal(), this);
        }
        EnderIO.guiHandler.registerGuiHandler(16, this);
        SmartModelAttacher.registerNoProps((Block)this);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            BlockStateWrapperConduitBundle blockStateWrapper = new BlockStateWrapperConduitBundle(state, world, pos, ConduitRenderMapper.instance);
            TileConduitBundle bundle = (TileConduitBundle)this.getTileEntitySafe(world, pos);
            if (bundle != null) {
                blockStateWrapper.addCacheKey(bundle);
            }
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        TextureAtlasSprite tex = null;
        TileConduitBundle cb = (TileConduitBundle)world.func_175625_s(target.func_178782_a());
        if (ConduitUtil.isSolidFacadeRendered(cb, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            IBlockState paintSource = cb.getPaintSource();
            if (paintSource != null) {
                tex = RenderUtil.getTexture((IBlockState)paintSource);
            }
        } else if (target.hitInfo instanceof CollidableComponent) {
            CollidableComponent cc = (CollidableComponent)target.hitInfo;
            IConduit con = cb.getConduit(cc.conduitType);
            if (con != null) {
                tex = con.getTextureForState(cc);
            }
        }
        if (tex == null) {
            tex = IconUtil.instance.whiteTexture;
        }
        this.lastRemovedComponetIcon = tex;
        BlockPos p = target.func_178782_a();
        this.addBlockHitEffects(world, effectRenderer, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), target.field_178784_b, tex);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager effectRenderer) {
        IBlockState state = world.func_180495_p(pos);
        if (state == null || state.func_177230_c() != this || this.lastRemovedComponetIcon == null) {
            return false;
        }
        state = state.func_185899_b((IBlockAccess)world, pos);
        int i = 4;
        TextureAtlasSprite tex = this.lastRemovedComponetIcon;
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < i; ++k) {
                for (int l = 0; l < i; ++l) {
                    double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / (double)i;
                    double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / (double)i;
                    double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / (double)i;
                    ParticleDigging fx = (ParticleDigging)new ParticleDigging.Factory().func_178902_a(-1, world, d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, new int[]{0});
                    fx.func_174846_a(pos);
                    fx.func_187117_a(tex);
                    effectRenderer.func_78873_a((Particle)fx);
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlockHitEffects(World world, ParticleManager effectRenderer, int x, int y, int z, EnumFacing sideEnum, TextureAtlasSprite tex) {
        float f = 0.1f;
        double d0 = (double)x + this.rand.nextDouble() * (this.bounds.field_72336_d - this.bounds.field_72340_a - (double)(f * 2.0f)) + (double)f + this.bounds.field_72340_a;
        double d1 = (double)y + this.rand.nextDouble() * (this.bounds.field_72337_e - this.bounds.field_72338_b - (double)(f * 2.0f)) + (double)f + this.bounds.field_72338_b;
        double d2 = (double)z + this.rand.nextDouble() * (this.bounds.field_72334_f - this.bounds.field_72339_c - (double)(f * 2.0f)) + (double)f + this.bounds.field_72339_c;
        int side = sideEnum.ordinal();
        if (side == 0) {
            d1 = (double)y + this.bounds.field_72338_b - (double)f;
        } else if (side == 1) {
            d1 = (double)y + this.bounds.field_72337_e + (double)f;
        } else if (side == 2) {
            d2 = (double)z + this.bounds.field_72339_c - (double)f;
        } else if (side == 3) {
            d2 = (double)z + this.bounds.field_72334_f + (double)f;
        } else if (side == 4) {
            d0 = (double)x + this.bounds.field_72340_a - (double)f;
        } else if (side == 5) {
            d0 = (double)x + this.bounds.field_72336_d + (double)f;
        }
        ParticleDigging digFX = (ParticleDigging)Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, 0.0, 0.0, 0.0, new int[]{0});
        digFX.func_174845_l().func_70543_e(0.2f).func_70541_f(0.6f);
        digFX.func_187117_a(tex);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlaySound(PlaySoundSourceEvent event) {
        String path = event.getSound().func_147650_b().toString();
        if (path != null && path.contains("silence.step")) {
            ISound snd = event.getSound();
            World world = EnderIO.proxy.getClientWorld();
            BlockCoord bc = new BlockCoord((double)snd.func_147649_g(), (double)snd.func_147654_h(), (double)snd.func_147651_i());
            TileEntity te = bc.getTileEntity((IBlockAccess)world);
            if (te != null && te instanceof TileConduitBundle && ((TileConduitBundle)te).hasFacade()) {
                IBlockState facade = ((TileConduitBundle)te).getPaintSource();
                ConduitUtil.playHitSound(facade.func_177230_c().func_185467_w(), world, bc.x, bc.y, bc.z);
            } else {
                ConduitUtil.playHitSound(SoundType.field_185852_e, world, bc.x, bc.y, bc.z);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
    }

    public ItemStack getPickBlock(IBlockState bs, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack ret = null;
        if (target != null && target.hitInfo instanceof CollidableComponent) {
            CollidableComponent cc = (CollidableComponent)target.hitInfo;
            TileConduitBundle bundle = (TileConduitBundle)this.getTileEntity((IBlockAccess)world, pos);
            if (bundle != null) {
                IConduit conduit = bundle.getConduit(cc.conduitType);
                if (conduit != null) {
                    ret = conduit.createItem();
                } else if (cc.conduitType == null && bundle.hasFacade()) {
                    ret = new ItemStack((Block)EnderIO.blockConduitFacade, 1, 0);
                    PainterUtil2.setSourceBlock(ret, bundle.getPaintSource());
                }
            }
        }
        return ret;
    }

    public int func_180651_a(IBlockState state) {
        return state == null ? 0 : state.func_177230_c().func_176201_c(state);
    }

    public int func_149745_a(Random r) {
        return 0;
    }

    public boolean isSideSolid(IBlockState bs, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityBase te = this.getTileEntitySafe(world, pos);
        if (!(te instanceof IConduitBundle)) {
            return false;
        }
        IConduitBundle con = (IConduitBundle)te;
        return con.hasFacade();
    }

    public boolean func_176193_a(World worldIn, BlockPos pos, EnumFacing side, @Nullable ItemStack stack) {
        return super.func_176193_a(worldIn, pos, side, stack);
    }

    public boolean canBeReplacedByLeaves(IBlockState bs, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    public boolean func_149686_d(IBlockState bs) {
        return false;
    }

    public int func_149717_k(IBlockState bs) {
        return 0;
    }

    public int getLightOpacity(IBlockState bs, IBlockAccess world, BlockPos pos) {
        TileEntityBase te = this.getTileEntitySafe(world, pos);
        if (!(te instanceof IConduitBundle)) {
            return super.getLightOpacity(bs, world, pos);
        }
        IConduitBundle con = (IConduitBundle)te;
        return con.getLightOpacity();
    }

    public int getLightValue(IBlockState bs, IBlockAccess world, BlockPos pos) {
        TileEntityBase te = this.getTileEntitySafe(world, pos);
        if (!(te instanceof IConduitBundle)) {
            return super.getLightValue(bs, world, pos);
        }
        IConduitBundle con = (IConduitBundle)te;
        int result = 0;
        if (con.hasFacade()) {
            IBlockState paintSource = con.getPaintSource();
            result = paintSource.func_185906_d();
            if (paintSource.func_185914_p()) {
                return result;
            }
        }
        Collection<IConduit> conduits = con.getConduits();
        for (IConduit conduit : conduits) {
            result += conduit.getLightValue();
        }
        return result > 15 ? 15 : result;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState bs, IBlockAccess worldIn, BlockPos pos) {
        IConduitBundle te = (IConduitBundle)this.getTileEntitySafe(worldIn, pos);
        if (te != null && te.hasFacade()) {
            if (te.getFacadeRenderedAs() == IConduitBundle.FacadeRenderState.WIRE_FRAME) {
                return 255;
            }
            return this.getMixedBrightnessForFacade(bs, worldIn, pos, te.getPaintSource().func_177230_c());
        }
        return super.func_185484_c(bs, worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public int getMixedBrightnessForFacade(IBlockState bs, IBlockAccess worldIn, BlockPos pos, Block facadeBlock) {
        int i = worldIn.func_175626_b(pos, this.getLightValue(bs, worldIn, pos));
        if (i == 0 && facadeBlock instanceof BlockSlab) {
            pos = pos.func_177977_b();
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            return worldIn.func_175626_b(pos, block.getLightValue(bs, worldIn, pos));
        }
        if (facadeBlock.func_149710_n(bs)) {
            return this.getNeightbourBrightness(worldIn, pos);
        }
        return i;
    }

    private int getNeightbourBrightness(IBlockAccess worldIn, BlockPos pos) {
        int result = worldIn.func_175626_b(pos.func_177984_a(), 0);
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            int val = worldIn.func_175626_b(pos.func_177972_a(dir), 0);
            if (val <= result) continue;
            result = val;
        }
        return result;
    }

    @Deprecated
    public float func_176195_g(IBlockState bs, World world, BlockPos pos) {
        IConduitBundle te = (IConduitBundle)this.getTileEntity((IBlockAccess)world, pos);
        if (te == null) {
            return super.func_176195_g(bs, world, pos);
        }
        return te.getFacadeType().isHardened() ? this.field_149782_v * 10.0f : this.field_149782_v;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity par1Entity, Explosion explosion) {
        float resist = this.func_149638_a(par1Entity);
        IConduitBundle te = (IConduitBundle)world.func_175625_s(pos);
        return te != null && te.getFacadeType().isHardened() ? resist * 10.0f : resist;
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getState().func_177230_c() == this) {
            IConduitBundle te;
            ItemStack held = event.getEntityPlayer().func_184614_ca();
            if (held == null || held.func_77973_b().getHarvestLevel(held, "pickaxe") == -1) {
                event.setNewSpeed(event.getNewSpeed() + 2.0f);
            }
            if ((te = (IConduitBundle)event.getEntity().field_70170_p.func_175625_s(event.getPos())) != null && te.getFacadeType().isHardened()) {
                if (!ConduitUtil.isSolidFacadeRendered(te, event.getEntityPlayer())) {
                    event.setNewSpeed(event.getNewSpeed() * 6.0f);
                } else {
                    event.setNewSpeed(event.getNewSpeed() * 2.0f);
                }
            }
        }
    }

    public int func_176211_b(IBlockState bs, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IRedstoneConduit con = BlockConduitBundle.getRedstoneConduit(world, pos);
        if (con == null) {
            return 0;
        }
        return con.isProvidingStrongPower(side);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IRedstoneConduit con = BlockConduitBundle.getRedstoneConduit(world, pos);
        if (con == null) {
            return 0;
        }
        return con.isProvidingWeakPower(side);
    }

    public boolean func_149744_f(IBlockState bs) {
        return true;
    }

    public boolean removedByPlayer(IBlockState bs, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        IConduitBundle te = (IConduitBundle)world.func_175625_s(pos);
        if (te == null) {
            return true;
        }
        boolean breakBlock = true;
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        if (ConduitUtil.isSolidFacadeRendered(te, player)) {
            breakBlock = false;
            ItemStack fac = new ItemStack((Block)EnderIO.blockConduitFacade, 1, te.getFacadeType().ordinal());
            PainterUtil2.setSourceBlock(fac, te.getPaintSource());
            drop.add(fac);
            ConduitUtil.playBreakSound(te.getPaintSource().func_177230_c().func_185467_w(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            te.setPaintSource(null);
            te.setFacadeType(EnumFacadeType.BASIC);
        }
        if (breakBlock) {
            List<RaytraceResult> results = this.doRayTraceAll(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), player);
            RaytraceResult.sort(Util.getEyePosition((EntityPlayer)player), results);
            for (RaytraceResult rt : results) {
                if (this.breakConduit(te, drop, rt, player)) break;
            }
        }
        boolean bl = breakBlock = te.getConduits().isEmpty() && !te.hasFacade();
        if (!breakBlock) {
            world.func_184138_a(pos, bs, bs, 3);
        }
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
            for (ItemStack st : drop) {
                Util.dropItems((World)world, (ItemStack)st, (BlockPos)pos, (boolean)false);
            }
        }
        if (breakBlock) {
            world.func_175698_g(pos);
            return true;
        }
        return false;
    }

    private boolean breakConduit(IConduitBundle te, List<ItemStack> drop, RaytraceResult rt, EntityPlayer player) {
        if (rt == null || rt.component == null) {
            return false;
        }
        Class<? extends IConduit> type = rt.component.conduitType;
        if (!ConduitUtil.renderConduit(player, type)) {
            return false;
        }
        if (type == null) {
            ArrayList<IConduit> cons = new ArrayList<IConduit>(te.getConduits());
            boolean droppedUnconected = false;
            for (IConduit con : cons) {
                if (!con.getConduitConnections().isEmpty() || !con.getExternalConnections().isEmpty() || !ConduitUtil.renderConduit(player, con)) continue;
                te.removeConduit(con);
                drop.addAll(con.getDrops());
                droppedUnconected = true;
            }
            if (!droppedUnconected) {
                for (IConduit con : cons) {
                    if (!ConduitUtil.renderConduit(player, con)) continue;
                    te.removeConduit(con);
                    drop.addAll(con.getDrops());
                }
            }
        } else {
            IConduit con = te.getConduit(type);
            if (con != null) {
                te.removeConduit(con);
                drop.addAll(con.getDrops());
            }
        }
        BlockCoord bc = te.getLocation();
        ConduitUtil.playBreakSound(SoundType.field_185852_e, te.getBundleWorldObj(), bc.x, bc.y, bc.z);
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof IConduitBundle)) {
            return;
        }
        IConduitBundle te = (IConduitBundle)tile;
        te.onBlockRemoved();
        world.func_175713_t(pos);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        ItemStack equipped = player.func_184614_ca();
        if (!player.func_70093_af() || equipped == null || equipped.func_77973_b() != EnderIO.itemYetaWench) {
            return;
        }
        ConduitUtil.openConduitGui(world, pos, player);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack held, EnumFacing side, float hitX, float hitY, float hitZ) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        IConduitBundle bundle = (IConduitBundle)world.func_175625_s(pos);
        if (bundle == null) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack != null && Block.func_149634_a((Item)stack.func_77973_b()) == EnderIO.blockConduitFacade) {
            return this.handleFacadeClick(world, pos, player, side, bundle, stack, hand, hitX, hitY, hitZ);
        }
        if (ConduitUtil.isConduitEquipped(player, hand)) {
            if (player.func_70093_af()) {
                return false;
            }
            if (this.handleConduitClick(world, x, y, z, player, bundle, stack, hand)) {
                return true;
            }
        } else if (ConduitUtil.isProbeEquipped(player, hand) ? this.handleConduitProbeClick(world, x, y, z, player, bundle, stack) : ToolUtil.isToolEquipped(player, hand) && player.func_70093_af() && this.handleWrenchClick(world, x, y, z, player, hand)) {
            return true;
        }
        RaytraceResult closest = this.doRayTrace(world, x, y, z, player);
        List<RaytraceResult> all = null;
        if (closest != null) {
            all = this.doRayTraceAll(world, x, y, z, player);
        }
        if (closest != null && closest.component != null && closest.component.data instanceof ConduitConnectorType) {
            Object conType = (ConduitConnectorType)((Object)closest.component.data);
            if (conType == ConduitConnectorType.INTERNAL) {
                boolean result = false;
                for (IConduit con : bundle.getConduits()) {
                    if (!ConduitUtil.renderConduit(player, con.getCollidableType()) || !con.onBlockActivated(player, hand, this.getHitForConduitType(all, con.getCollidableType()), all)) continue;
                    bundle.getEntity().func_70296_d();
                    result = true;
                }
                if (result) {
                    return true;
                }
            } else {
                if (!world.field_72995_K) {
                    player.openGui((Object)EnderIO.instance, 9 + closest.component.dir.ordinal(), world, x, y, z);
                }
                return false;
            }
        }
        if (closest == null || closest.component == null || closest.component.conduitType == null && all == null) {
            return false;
        }
        if (all != null) {
            RaytraceResult.sort(Util.getEyePosition((EntityPlayer)player), all);
            for (RaytraceResult rr : all) {
                IConduit con;
                if (!ConduitUtil.renderConduit(player, rr.component.conduitType) || rr.component.data instanceof ConduitConnectorType || (con = bundle.getConduit(rr.component.conduitType)) == null || !con.onBlockActivated(player, hand, rr, all)) continue;
                bundle.getEntity().func_70296_d();
                return true;
            }
        } else {
            IConduit closestConduit = bundle.getConduit(closest.component.conduitType);
            if (closestConduit != null && ConduitUtil.renderConduit(player, closestConduit) && closestConduit.onBlockActivated(player, hand, closest, all)) {
                bundle.getEntity().func_70296_d();
                return true;
            }
        }
        return false;
    }

    private boolean handleWrenchClick(World world, int x, int y, int z, EntityPlayer player, EnumHand hand) {
        ITool tool = ToolUtil.getEquippedTool(player, hand);
        if (tool != null) {
            BlockPos pos = new BlockPos(x, y, z);
            if (tool.canUse(player.func_184586_b(hand), player, pos)) {
                if (!world.field_72995_K) {
                    this.removedByPlayer(world.func_180495_p(pos), world, pos, player, true);
                    tool.used(player.func_184586_b(hand), player, new BlockPos(x, y, z));
                }
                return true;
            }
        }
        return false;
    }

    private boolean handleConduitProbeClick(World world, int x, int y, int z, EntityPlayer player, IConduitBundle bundle, ItemStack stack) {
        if (stack.func_77952_i() != 1) {
            return false;
        }
        RaytraceResult rr = this.doRayTrace(world, x, y, z, player);
        if (rr == null || rr.component == null) {
            return false;
        }
        return ItemConduitProbe.copyPasteSettings(player, stack, bundle, rr.component.dir);
    }

    private boolean handleConduitClick(World world, int x, int y, int z, EntityPlayer player, IConduitBundle bundle, ItemStack stack, EnumHand hand) {
        IConduitItem equipped = (IConduitItem)stack.func_77973_b();
        if (!bundle.hasType(equipped.getBaseConduitType())) {
            if (!world.field_72995_K) {
                bundle.addConduit(equipped.createConduit(stack, player));
                ConduitUtil.playBreakSound(SoundType.field_185852_e, world, x, y, z);
                if (!player.field_71075_bZ.field_75098_d) {
                    --player.func_184586_b((EnumHand)hand).field_77994_a;
                }
            }
            return true;
        }
        return false;
    }

    public boolean handleFacadeClick(World world, BlockPos pos, EntityPlayer player, EnumFacing side, IConduitBundle bundle, ItemStack stack, EnumHand hand, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        IBlockState facadeID = PainterUtil2.getSourceBlock(player.func_184586_b(hand));
        if (facadeID == null) {
            return false;
        }
        int facadeType = player.func_184586_b(hand).func_77952_i();
        if (bundle.hasFacade()) {
            if (!ConduitUtil.isSolidFacadeRendered(bundle, player) || this.facadeEquals(bundle, facadeID, facadeType)) {
                return false;
            }
            if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                ItemStack drop = new ItemStack((Block)EnderIO.blockConduitFacade, 1, bundle.getFacadeType().ordinal());
                PainterUtil2.setSourceBlock(drop, bundle.getPaintSource());
                if (!player.field_71071_by.func_70441_a(drop)) {
                    ItemUtil.spawnItemInWorldWithRandomMotion((World)world, (ItemStack)drop, (BlockPos)pos, (float)hitX, (float)hitY, (float)hitZ, (float)1.2f);
                }
            }
        }
        bundle.setPaintSource(facadeID);
        bundle.setFacadeType(EnumFacadeType.getTypeFromMeta(facadeType));
        if (!world.field_72995_K) {
            ConduitUtil.playPlaceSound(facadeID.func_177230_c().func_185467_w(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        IBlockState bs = world.func_180495_p(pos);
        world.func_184138_a(pos, bs, bs, 3);
        bundle.getEntity().func_70296_d();
        return true;
    }

    private boolean facadeEquals(IConduitBundle bundle, IBlockState b, int facadeType) {
        IBlockState a = bundle.getPaintSource();
        if (a == null) {
            return false;
        }
        if (a.func_177230_c() != b.func_177230_c()) {
            return false;
        }
        if (bundle.getFacadeType().ordinal() != facadeType) {
            return false;
        }
        return a.func_177230_c().func_176201_c(a) == b.func_177230_c().func_176201_c(b);
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id == 16) {
            return null;
        }
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof IConduitBundle) {
            return new ExternalConnectionContainer(player.field_71071_by, (IConduitBundle)te, EnumFacing.values()[id - 9]);
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof IConduitBundle) {
            if (id == 16) {
                return new GuiExternalConnectionSelector((IConduitBundle)te);
            }
            return new GuiExternalConnection(player.field_71071_by, (IConduitBundle)te, EnumFacing.values()[id - 9]);
        }
        return null;
    }

    private RaytraceResult getHitForConduitType(List<RaytraceResult> all, Class<? extends IConduit> collidableType) {
        for (RaytraceResult rr : all) {
            if (rr.component == null || rr.component.conduitType != collidableType) continue;
            return rr;
        }
        return null;
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        TileConduitBundle conduit = (TileConduitBundle)this.getTileEntity((IBlockAccess)world, pos);
        if (conduit != null) {
            conduit.onNeighborBlockChange(neighborBlock);
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileConduitBundle conduit = (TileConduitBundle)this.getTileEntity(world, pos);
        if (conduit != null) {
            conduit.onNeighborChange(world, pos, neighbor);
        }
    }

    @Deprecated
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB axisalignedbb, List<AxisAlignedBB> arraylist, @Nullable Entity par7Entity) {
        IConduitBundle con = (IConduitBundle)this.getTileEntity((IBlockAccess)world, pos);
        if (con == null) {
            return;
        }
        if (con.hasFacade()) {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            super.func_185477_a(state, world, pos, axisalignedbb, arraylist, par7Entity);
        } else {
            List<CollidableComponent> bounds = con.getCollidableComponents();
            for (CollidableComponent bnd : bounds) {
                this.setBlockBounds(bnd.bound.field_72340_a, bnd.bound.field_72338_b, bnd.bound.field_72339_c, bnd.bound.field_72336_d, bnd.bound.field_72337_e, bnd.bound.field_72334_f);
                super.func_185477_a(state, world, pos, axisalignedbb, arraylist, par7Entity);
            }
            if (con.getConduits().isEmpty()) {
                this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                super.func_185477_a(state, world, pos, axisalignedbb, arraylist, par7Entity);
            }
        }
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState bs, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (!(te instanceof IConduitBundle)) {
            return null;
        }
        IConduitBundle con = (IConduitBundle)te;
        BoundingBox minBB = null;
        if (!ConduitUtil.isSolidFacadeRendered(con, EnderIO.proxy.getClientPlayer())) {
            RaytraceResult hit;
            List<RaytraceResult> results = this.doRayTraceAll(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (EntityPlayer)player);
            Iterator<RaytraceResult> iter = results.iterator();
            while (iter.hasNext()) {
                CollidableComponent component = iter.next().component;
                if (component != null && (component.conduitType != null || component.data == ConduitConnectorType.EXTERNAL)) continue;
                iter.remove();
            }
            for (RaytraceResult hit2 : results) {
                IRedstoneConduit cond = con.getConduit(IRedstoneConduit.class);
                if (cond == null || hit2.component == null || !cond.getExternalConnections().contains(hit2.component.dir) || cond.isSpecialConnection(hit2.component.dir) || hit2.component.data != "ColorController") continue;
                minBB = hit2.component.bound;
            }
            if (minBB == null && (hit = RaytraceResult.getClosestHit(Util.getEyePosition((EntityPlayer)player), results)) != null && hit.component != null && hit.component.bound != null) {
                minBB = hit.component.bound;
                if (hit.component.conduitType == null) {
                    EnumFacing dir = hit.component.dir.func_176734_d();
                    float trans = 0.0125f;
                    minBB = minBB.translate((float)dir.func_82601_c() * trans, (float)dir.func_96559_d() * trans, (float)dir.func_82599_e() * trans);
                    float scale = 0.7f;
                    minBB = minBB.scale(1.0f + (float)Math.abs(dir.func_82601_c()) * scale, 1.0f + (float)Math.abs(dir.func_96559_d()) * scale, 1.0f + (float)Math.abs(dir.func_82599_e()) * scale);
                } else {
                    minBB = minBB.scale(1.09, 1.09, 1.09);
                }
            }
        } else {
            minBB = new BoundingBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (minBB == null) {
            minBB = new BoundingBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        return new AxisAlignedBB((double)pos.func_177958_n() + minBB.field_72340_a, (double)pos.func_177956_o() + minBB.field_72338_b, (double)pos.func_177952_p() + minBB.field_72339_c, (double)pos.func_177958_n() + minBB.field_72336_d, (double)pos.func_177956_o() + minBB.field_72337_e, (double)pos.func_177952_p() + minBB.field_72334_f);
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d origin, Vec3d direction) {
        RaytraceResult raytraceResult = this.doRayTrace(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), origin, direction, null);
        RayTraceResult ret = null;
        if (raytraceResult != null && (ret = raytraceResult.movingObjectPosition) != null) {
            ret.hitInfo = raytraceResult.component;
        }
        return ret;
    }

    public RaytraceResult doRayTrace(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        List<RaytraceResult> allHits = this.doRayTraceAll(world, x, y, z, entityPlayer);
        if (allHits == null) {
            return null;
        }
        Vec3d origin = Util.getEyePosition((EntityPlayer)entityPlayer);
        return RaytraceResult.getClosestHit(origin, allHits);
    }

    public List<RaytraceResult> doRayTraceAll(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        double pitch = Math.toRadians(entityPlayer.field_70125_A);
        double yaw = Math.toRadians(entityPlayer.field_70177_z);
        double dirX = -Math.sin(yaw) * Math.cos(pitch);
        double dirY = -Math.sin(pitch);
        double dirZ = Math.cos(yaw) * Math.cos(pitch);
        double reachDistance = EnderIO.proxy.getReachDistanceForPlayer(entityPlayer);
        Vec3d origin = Util.getEyePosition((EntityPlayer)entityPlayer);
        Vec3d direction = origin.func_72441_c(dirX * reachDistance, dirY * reachDistance, dirZ * reachDistance);
        return this.doRayTraceAll(world.func_180495_p(new BlockPos(x, y, z)), world, x, y, z, origin, direction, entityPlayer);
    }

    private RaytraceResult doRayTrace(World world, int x, int y, int z, Vec3d origin, Vec3d direction, EntityPlayer entityPlayer) {
        List<RaytraceResult> allHits = this.doRayTraceAll(world.func_180495_p(new BlockPos(x, y, z)), world, x, y, z, origin, direction, entityPlayer);
        if (allHits == null) {
            return null;
        }
        return RaytraceResult.getClosestHit(origin, allHits);
    }

    protected List<RaytraceResult> doRayTraceAll(IBlockState bs, World world, int x, int y, int z, Vec3d origin, Vec3d direction, EntityPlayer player) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IConduitBundle)) {
            return null;
        }
        IConduitBundle bundle = (IConduitBundle)te;
        ArrayList<RaytraceResult> hits = new ArrayList<RaytraceResult>();
        if (player == null) {
            player = EnderIO.proxy.getClientPlayer();
        }
        if (ConduitUtil.isSolidFacadeRendered(bundle, player)) {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            RayTraceResult hitPos = super.func_180636_a(bs, world, pos, origin, direction);
            if (hitPos != null) {
                hits.add(new RaytraceResult(new CollidableComponent(null, BoundingBox.UNIT_CUBE, null, null), hitPos));
            }
        } else {
            ConduitDisplayMode mode = ConduitUtil.getDisplayMode(player);
            ArrayList<CollidableComponent> components = new ArrayList<CollidableComponent>(bundle.getCollidableComponents());
            for (CollidableComponent component : components) {
                if (component.conduitType == null && mode != ConduitDisplayMode.ALL || !ConduitUtil.renderConduit(player, component.conduitType)) continue;
                this.setBlockBounds(component.bound.field_72340_a, component.bound.field_72338_b, component.bound.field_72339_c, component.bound.field_72336_d, component.bound.field_72337_e, component.bound.field_72334_f);
                RayTraceResult hitPos = super.func_180636_a(bs, world, pos, origin, direction);
                if (hitPos == null) continue;
                hits.add(new RaytraceResult(component, hitPos));
            }
            if (bundle.getConduits().isEmpty() && !ConduitUtil.isFacadeHidden(bundle, player)) {
                this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                RayTraceResult hitPos = super.func_180636_a(bs, world, pos, origin, direction);
                if (hitPos != null) {
                    hits.add(new RaytraceResult(null, hitPos));
                }
            }
        }
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return hits;
    }

    private static IRedstoneConduit getRedstoneConduit(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IConduitBundle)) {
            return null;
        }
        IConduitBundle bundle = (IConduitBundle)te;
        return bundle.getConduit(IRedstoneConduit.class);
    }

    @Override
    public void setPaintSource(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable IBlockState paintSource) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            ((IPaintable.IPaintableTileEntity)te).setPaintSource(paintSource);
        }
    }

    @Override
    public void setPaintSource(Block block, ItemStack stack, @Nullable IBlockState paintSource) {
        PainterUtil2.setSourceBlock(stack, paintSource);
    }

    @Override
    public IBlockState getPaintSource(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityBase te = this.getTileEntitySafe(world, pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            return ((IPaintable.IPaintableTileEntity)te).getPaintSource();
        }
        return null;
    }

    @Override
    public IBlockState getPaintSource(Block block, ItemStack stack) {
        return PainterUtil2.getSourceBlock(stack);
    }

    public IBlockState getFacade(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState paintSource = this.getPaintSource(this.func_176223_P(), world, pos);
        return paintSource != null ? paintSource : world.func_180495_p(pos);
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (tab != null) {
            super.func_149666_a(itemIn, tab, list);
        }
    }
}

