/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.capability;

import crazypants.enderio.capability.InventorySlot;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

public class EnderInventory
implements IItemHandler {
    private final Map<String, InventorySlot> idents = new HashMap<String, InventorySlot>();
    private final EnumMap<Type, List<InventorySlot>> slots = new EnumMap(Type.class);
    private final View allSlots = new View(Type.ALL);

    public EnderInventory() {
        for (Type type : Type.values()) {
            this.slots.put(type, new ArrayList());
        }
    }

    public void add(Type type, Enum<?> ident, InventorySlot slot) {
        this.add(type, ident.name(), slot);
    }

    public void add(Type type, String ident, InventorySlot slot) {
        if (this.idents.containsKey(ident)) {
            throw new RuntimeException("Duplicate slot '" + ident + "'");
        }
        if (type == Type.INOUT || type == Type.ALL) {
            throw new RuntimeException("Invalid type '" + (Object)((Object)type) + "'");
        }
        this.idents.put(ident, slot);
        this.slots.get((Object)type).add(slot);
        this.slots.get((Object)Type.ALL).add(slot);
        if (type == Type.INPUT || type == Type.OUTPUT) {
            this.slots.get((Object)Type.INOUT).add(slot);
        }
    }

    public InventorySlot getSlot(Enum<?> ident) {
        return this.getSlot(ident.name());
    }

    public InventorySlot getSlot(String ident) {
        if (!this.idents.containsKey(ident)) {
            throw new RuntimeException("Unknown slot '" + ident + "'");
        }
        return this.idents.get(ident);
    }

    public View getView(Type type) {
        return new View(type);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return tag;
    }

    public void writeToNBT(NBTTagCompound tag) {
        for (Map.Entry<String, InventorySlot> entry : this.idents.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().writeToNBT(tag.func_74775_l(entry.getKey()));
        }
    }

    public void readFromNBT(NBTTagCompound tag, String name) {
        this.readFromNBT(tag.func_74775_l(name));
    }

    public void readFromNBT(NBTTagCompound tag) {
        for (Map.Entry<String, InventorySlot> entry : this.idents.entrySet()) {
            if (entry.getValue() == null) continue;
            entry.getValue().readFromNBT(tag.func_74775_l(entry.getKey()));
        }
    }

    public int getSlots() {
        return this.allSlots.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.allSlots.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.allSlots.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.allSlots.extractItem(slot, amount, simulate);
    }

    public class View
    implements IItemHandler {
        private final Type type;

        private View(Type type) {
            this.type = type;
        }

        public InventorySlot getSlot(int slot) {
            if (slot >= 0 && slot < this.getSlots()) {
                return (InventorySlot)((List)EnderInventory.this.slots.get((Object)this.type)).get(slot);
            }
            return null;
        }

        public int getSlots() {
            return ((List)EnderInventory.this.slots.get((Object)this.type)).size();
        }

        public ItemStack getStackInSlot(int slot) {
            InventorySlot inventorySlot;
            if (slot >= 0 && slot < this.getSlots() && (inventorySlot = (InventorySlot)((List)EnderInventory.this.slots.get((Object)this.type)).get(slot)) != null) {
                return inventorySlot.getStackInSlot(0);
            }
            return null;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            InventorySlot inventorySlot;
            if (slot >= 0 && slot < this.getSlots() && (inventorySlot = (InventorySlot)((List)EnderInventory.this.slots.get((Object)this.type)).get(slot)) != null) {
                return inventorySlot.insertItem(0, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            InventorySlot inventorySlot;
            if (slot >= 0 && slot < this.getSlots() && (inventorySlot = (InventorySlot)((List)EnderInventory.this.slots.get((Object)this.type)).get(slot)) != null) {
                return inventorySlot.extractItem(0, amount, simulate);
            }
            return null;
        }
    }

    public static enum Type {
        ALL,
        INPUT,
        OUTPUT,
        INOUT,
        UPGRADE,
        INTERNAL;

    }
}

