/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio;

import crazypants.enderio.EnderIO;
import crazypants.enderio.capacitor.LootSelector;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.material.Alloy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LootManager {
    private static LootManager INSTANCE = new LootManager();
    private static LootSelector ls = new LootSelector(new LootCondition[0]);

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    private LootManager() {
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent evt) {
        LootTable table = evt.getTable();
        InnerPool lp = new InnerPool();
        if (evt.getName().equals((Object)LootTableList.field_186422_d)) {
            if (Config.lootDarkSteel) {
                lp.addItem(this.createLootEntry(EnderIO.itemAlloy, Alloy.DARK_STEEL.ordinal(), 1, 3, 0.25));
            }
            if (Config.lootItemConduitProbe) {
                lp.addItem(this.createLootEntry(EnderIO.itemConduitProbe, 0.1));
            }
            if (Config.lootQuartz) {
                lp.addItem(this.createLootEntry(Items.field_151128_bU, 3, 16, 0.25));
            }
            if (Config.lootNetherWart) {
                lp.addItem(this.createLootEntry(Items.field_151075_bm, 1, 4, 0.2));
            }
            if (Config.lootEnderPearl) {
                lp.addItem(this.createLootEntry(Items.field_151079_bi, 1, 2, 0.3));
            }
            if (Config.lootTheEnder) {
                lp.addItem(this.createLootEntry((Item)DarkSteelItems.itemDarkSteelSword, 0.1));
            }
            if (Config.lootDarkSteelBoots) {
                lp.addItem(this.createLootEntry((Item)DarkSteelItems.itemDarkSteelBoots, 0.1));
            }
            lp.addItem(this.createLootCapacitor(0.15));
            lp.addItem(this.createLootCapacitor(0.15));
            lp.addItem(this.createLootCapacitor(0.15));
        } else if (evt.getName().equals((Object)LootTableList.field_186423_e)) {
            if (Config.lootElectricSteel) {
                lp.addItem(this.createLootEntry(EnderIO.itemAlloy, Alloy.ELECTRICAL_STEEL.ordinal(), 2, 6, 0.2));
            }
            if (Config.lootRedstoneAlloy) {
                lp.addItem(this.createLootEntry(EnderIO.itemAlloy, Alloy.REDSTONE_ALLOY.ordinal(), 3, 6, 0.35));
            }
            if (Config.lootDarkSteel) {
                lp.addItem(this.createLootEntry(EnderIO.itemAlloy, Alloy.DARK_STEEL.ordinal(), 3, 6, 0.35));
            }
            if (Config.lootPhasedIron) {
                lp.addItem(this.createLootEntry(EnderIO.itemAlloy, Alloy.PULSATING_IRON.ordinal(), 1, 2, 0.3));
            }
            if (Config.lootPhasedGold) {
                lp.addItem(this.createLootEntry(EnderIO.itemAlloy, Alloy.VIBRANT_ALLOY.ordinal(), 1, 2, 0.2));
            }
            if (Config.lootTheEnder) {
                lp.addItem(this.createLootEntry((Item)DarkSteelItems.itemDarkSteelSword, 1, 1, 0.25));
            }
            if (Config.lootDarkSteelBoots) {
                lp.addItem(this.createLootEntry((Item)DarkSteelItems.itemDarkSteelBoots, 1, 1, 0.25));
            }
            lp.addItem(this.createLootCapacitor(0.1));
        } else if (evt.getName().equals((Object)LootTableList.field_186429_k)) {
            if (Config.lootTheEnder) {
                lp.addItem(this.createLootEntry((Item)DarkSteelItems.itemDarkSteelSword, 0.2));
            }
            if (Config.lootTravelStaff) {
                lp.addItem(this.createLootEntry(EnderIO.itemTravelStaff, 0.1));
            }
            lp.addItem(this.createLootCapacitor(25.0));
        } else if (evt.getName().equals((Object)LootTableList.field_186430_l)) {
            if (Config.lootTheEnder) {
                lp.addItem(this.createLootEntry((Item)DarkSteelItems.itemDarkSteelSword, 1, 1, 0.25));
            }
            if (Config.lootTravelStaff) {
                lp.addItem(this.createLootEntry(EnderIO.itemTravelStaff, 1, 1, 0.1));
            }
            lp.addItem(this.createLootCapacitor(0.25));
            lp.addItem(this.createLootCapacitor(0.25));
        }
        if (!lp.isEmpty()) {
            table.addPool((LootPool)lp);
        }
    }

    private LootItem createLootEntry(Item item, double chance) {
        return new LootItem(new ItemStack(item), chance, 1, 1);
    }

    private LootItem createLootEntry(Item item, int minSize, int maxSize, double chance) {
        return new LootItem(new ItemStack(item), chance, minSize, maxSize);
    }

    private LootItem createLootEntry(Item item, int ordinal, int minStackSize, int maxStackSize, double chance) {
        return new LootItem(new ItemStack(item, 1, ordinal), chance, minStackSize, maxStackSize);
    }

    private LootItem createLootCapacitor(double weight) {
        return new CapItem(weight);
    }

    private static class InnerPool
    extends LootPool {
        private final List<LootItem> items = new ArrayList<LootItem>();

        public InnerPool() {
            super(new LootEntry[0], new LootCondition[0], new RandomValueRange(0.0f, 0.0f), new RandomValueRange(0.0f, 0.0f), "Ender IO");
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }

        public void addItem(LootItem entry) {
            if (entry != null) {
                this.items.add(entry);
            }
        }

        public void func_186449_b(Collection<ItemStack> stacks, Random rand, LootContext context) {
            for (LootItem entry : this.items) {
                ItemStack stack;
                if (!(rand.nextDouble() < entry.chance) || (stack = entry.createStack(rand)) == null) continue;
                stacks.add(stack);
            }
        }
    }

    private static class LootItem {
        ItemStack item;
        double chance;
        int minSize;
        int maxSize;

        public LootItem(ItemStack item, double chance) {
            this(item, chance, 1, 1);
        }

        public LootItem(ItemStack item, double chance, int minSize, int maxSize) {
            this.item = item;
            this.chance = chance;
            this.minSize = minSize;
            this.maxSize = maxSize;
        }

        public ItemStack createStack(Random rnd) {
            int size = this.minSize;
            if (this.maxSize > this.minSize) {
                size += rnd.nextInt(this.maxSize - this.minSize + 1);
            }
            ItemStack result = this.item.func_77946_l();
            result.field_77994_a = size;
            return result;
        }
    }

    private static class CapItem
    extends LootItem {
        public CapItem(double chance) {
            super(new ItemStack((Item)EnderIO.itemBasicCapacitor, 1, 3), chance);
        }

        @Override
        public ItemStack createStack(Random rnd) {
            ItemStack res = this.item.func_77946_l();
            ls.func_186553_a(res, rnd, null);
            return res;
        }
    }
}

