/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.widgets;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.gui.Scrollable;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class WidgetList
extends AbstractContainerWidget<WidgetList>
implements Scrollable {
    private int rowheight = 16;
    private int first = 0;
    private int selected = -1;
    private long prevTime = -1L;
    private boolean propagateEventsToChildren = false;
    private List<SelectionEvent> selectionEvents = null;
    private Set<Integer> hilightedRows = new HashSet<Integer>();
    private boolean noselection = false;
    private boolean invisibleselection = false;
    private int leftMargin = 2;
    private int topMargin = 1;

    public WidgetList(Minecraft mc, Gui gui) {
        super(mc, gui);
        this.setFilledRectThickness(-1);
        this.setFilledBackground(StyleConfig.colorListBackground);
    }

    public int getRowheight() {
        return this.rowheight;
    }

    public WidgetList setRowheight(int rowheight) {
        this.rowheight = rowheight;
        return this;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public WidgetList setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
        return this;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public WidgetList setTopMargin(int topMargin) {
        this.topMargin = topMargin;
        return this;
    }

    public int getSelected() {
        return this.selected;
    }

    public WidgetList setSelected(int selected) {
        this.selected = selected;
        return this;
    }

    public boolean isPropagateEventsToChildren() {
        return this.propagateEventsToChildren;
    }

    public boolean isInvisibleSelection() {
        return this.invisibleselection;
    }

    public WidgetList setInvisibleSelection(boolean invisibleselection) {
        this.invisibleselection = invisibleselection;
        return this;
    }

    public WidgetList setNoSelectionMode(boolean m) {
        this.noselection = m;
        return this;
    }

    public boolean isNoSelection() {
        return this.noselection;
    }

    public WidgetList setPropagateEventsToChildren(boolean propagateEventsToChildren) {
        this.propagateEventsToChildren = propagateEventsToChildren;
        return this;
    }

    public void addHilightedRow(int index) {
        this.hilightedRows.add(index);
    }

    public void clearHilightedRows() {
        this.hilightedRows.clear();
    }

    @Override
    public Widget getWidgetAtPosition(int x, int y) {
        x -= this.bounds.x;
        y -= this.bounds.y;
        this.doLayout();
        for (int i = this.first; i < this.first + this.getCountSelected() && i < this.children.size(); ++i) {
            Widget child = (Widget)this.children.get(i);
            if (!child.in(x, y) || !child.isVisible()) continue;
            return child.getWidgetAtPosition(x, y);
        }
        return this;
    }

    private void doLayout() {
        int top = 0;
        for (int i = this.first; i < this.first + this.getCountSelected() && i < this.children.size(); ++i) {
            Widget child = (Widget)this.children.get(i);
            int rh = this.rowheight == -1 ? child.getDesiredHeight() : this.rowheight;
            child.setBounds(new Rectangle(0, top, this.bounds.width, rh));
            top += rh;
        }
    }

    @Override
    public void draw(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        this.mouseWheel(0, x, y);
        super.draw(window, x, y);
        int xx = x + this.bounds.x + this.leftMargin;
        int yy = y + this.bounds.y + this.topMargin;
        int top = 0;
        for (int i = this.first; i < this.first + this.getCountSelected() && i < this.children.size(); ++i) {
            Widget child = (Widget)this.children.get(i);
            int rh = this.rowheight == -1 ? child.getDesiredHeight() : this.rowheight;
            child.setBounds(new Rectangle(0, top, this.bounds.width, rh));
            boolean hilighted = this.hilightedRows.contains(i);
            if (top + rh - 1 < this.bounds.height - 3) {
                RenderHelper.drawHorizontalLine(xx + 2, yy + top + rh - 1, xx + this.bounds.width - 7, StyleConfig.colorListSeparatorLine);
            }
            if (!this.invisibleselection) {
                if (i == this.selected && hilighted) {
                    RenderHelper.drawHorizontalGradientRect(xx, yy + top + 1, xx + this.bounds.width - 5, yy + top + rh - 2, StyleConfig.colorListSelectedHighlightedGradient1, StyleConfig.colorListSelectedHighlightedGradient2);
                } else if (i == this.selected) {
                    RenderHelper.drawHorizontalGradientRect(xx, yy + top + 1, xx + this.bounds.width - 5, yy + top + rh - 2, StyleConfig.colorListSelectedGradient1, StyleConfig.colorListSelectedGradient2);
                } else if (hilighted) {
                    RenderHelper.drawHorizontalGradientRect(xx, yy + top + 1, xx + this.bounds.width - 5, yy + top + rh - 2, StyleConfig.colorListHighlightedGradient1, StyleConfig.colorListHighlightedGradient2);
                }
            }
            if (this.isEnabledAndVisible()) {
                child.draw(window, xx, yy);
            } else {
                boolean en = child.isEnabled();
                child.setEnabled(false);
                child.draw(window, xx, yy);
                child.setEnabled(en);
            }
            top += rh;
        }
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        int yy;
        int xx;
        Widget child;
        if (!this.isEnabledAndVisible()) {
            return null;
        }
        if (this.noselection) {
            return null;
        }
        int newSelected = -1;
        int top = this.bounds.y;
        for (int i = this.first; i < this.first + this.getCountSelected() && i < this.children.size(); ++i) {
            int rh = this.rowheight == -1 ? ((Widget)this.children.get(i)).getDesiredHeight() : this.rowheight;
            Rectangle r = new Rectangle(this.bounds.x, top, this.bounds.width, rh);
            if (r.contains(x, y)) {
                newSelected = i;
                break;
            }
            top += rh;
        }
        if (newSelected != this.selected) {
            this.selected = newSelected;
            this.fireSelectionEvents(this.selected);
        }
        if (this.propagateEventsToChildren && this.selected != -1 && (child = (Widget)this.children.get(this.selected)).in(xx = x - this.bounds.x, yy = y - this.bounds.y) && child.isVisible()) {
            child.mouseClick(window, xx, yy, button);
        }
        long t = System.currentTimeMillis();
        if (this.prevTime != -1L && t - this.prevTime < 250L) {
            this.fireDoubleClickEvent(this.selected);
        }
        this.prevTime = t;
        return null;
    }

    @Override
    public void mouseRelease(int x, int y, int button) {
        super.mouseRelease(x, y, button);
    }

    @Override
    public boolean mouseWheel(int amount, int x, int y) {
        int divider = this.getMaximum() - this.getCountSelected();
        if (divider <= 0) {
            this.first = 0;
        } else if (amount > 0) {
            this.first -= 3;
        } else if (amount < 0) {
            this.first += 3;
        }
        if (this.first > divider) {
            this.first = divider;
        }
        if (this.first < 0) {
            this.first = 0;
        }
        return true;
    }

    @Override
    public int getMaximum() {
        return this.children.size();
    }

    @Override
    public int getCountSelected() {
        int rh;
        if (this.bounds == null) {
            return 0;
        }
        if (this.rowheight != -1) {
            return this.bounds.height / this.rowheight;
        }
        int totalh = 0;
        int cnt = 0;
        for (int i = this.first; i < this.children.size() && totalh + (rh = ((Widget)this.children.get(i)).getDesiredHeight()) <= this.bounds.height; ++i) {
            totalh += rh;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public int getFirstSelected() {
        return this.first;
    }

    @Override
    public void setFirstSelected(int first) {
        this.first = first;
    }

    public WidgetList addSelectionEvent(SelectionEvent event) {
        if (this.selectionEvents == null) {
            this.selectionEvents = new ArrayList<SelectionEvent>();
        }
        this.selectionEvents.add(event);
        return this;
    }

    public void removeSelectionEvent(SelectionEvent event) {
        if (this.selectionEvents != null) {
            this.selectionEvents.remove(event);
        }
    }

    private void fireSelectionEvents(int index) {
        if (this.selectionEvents != null) {
            for (SelectionEvent event : this.selectionEvents) {
                event.select(this, index);
            }
        }
    }

    private void fireDoubleClickEvent(int index) {
        if (this.selectionEvents != null) {
            for (SelectionEvent event : this.selectionEvents) {
                event.doubleClick(this, index);
            }
        }
    }

    @Override
    public WidgetList removeChild(Widget child) {
        int index = this.children.indexOf(child);
        if (index != -1) {
            HashSet<Integer> newHighlights = new HashSet<Integer>();
            for (Integer i : this.hilightedRows) {
                if (i < index) {
                    newHighlights.add(i);
                    continue;
                }
                if (i <= index) continue;
                newHighlights.add(i - 1);
            }
            this.hilightedRows = newHighlights;
        }
        return (WidgetList)super.removeChild(child);
    }

    @Override
    public void removeChildren() {
        super.removeChildren();
        this.hilightedRows.clear();
    }
}

