/*
 * Decompiled with CFR 0.152.
 */
package pcl.openprinter.tileentity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import pcl.openprinter.gui.PrintedPaperSlot;
import pcl.openprinter.gui.PrinterInkBlackSlot;
import pcl.openprinter.gui.PrinterInkColorSlot;
import pcl.openprinter.gui.PrinterPaperSlot;
import pcl.openprinter.tileentity.PrinterTE;

public class PrinterContainer
extends Container {
    protected PrinterTE tileEntity;
    private Slot colorInkSlot;
    private Slot blackInkSlot;
    private Slot paperSlot;
    private Slot scanSlot;
    private List<Slot> specialSlots;
    private List<Slot> outputSlots;
    private List<Slot> playerSlots;
    private List<Slot> hotbarSlots;

    public PrinterContainer(InventoryPlayer inventoryPlayer, PrinterTE te) {
        this.tileEntity = te;
        this.blackInkSlot = this.func_75146_a(new PrinterInkBlackSlot(this.tileEntity, 0, 30, 47));
        this.colorInkSlot = this.func_75146_a(new PrinterInkColorSlot(this.tileEntity, 1, 60, 47));
        this.paperSlot = this.func_75146_a(new PrinterPaperSlot(this.tileEntity, 2, 129, 47));
        this.specialSlots = new ArrayList<Slot>();
        this.specialSlots.add(this.blackInkSlot);
        this.specialSlots.add(this.colorInkSlot);
        this.specialSlots.add(this.paperSlot);
        this.outputSlots = new ArrayList<Slot>();
        for (int i = 3; i < 12; ++i) {
            this.outputSlots.add(this.func_75146_a(new Slot((IInventory)this.tileEntity, i, 8 + i * 18 - 54, 87)));
        }
        this.scanSlot = this.func_75146_a(new PrintedPaperSlot(this.tileEntity, 13, 94, 17));
        this.bindPlayerInventory(inventoryPlayer);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tileEntity.func_70300_a(player);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        this.playerSlots = new ArrayList<Slot>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 84 + i * 18 + 15 + 15)));
            }
        }
        this.hotbarSlots = new ArrayList<Slot>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 172)));
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        ItemStack stack = null;
        Slot slotObject = (Slot)this.field_75151_b.get(slot);
        int outputSlotStart = this.outputSlots.get((int)0).field_75222_d;
        int outputSlotEnd = this.outputSlots.get((int)(this.outputSlots.size() - 1)).field_75222_d + 1;
        int inventoryStart = this.playerSlots.get((int)0).field_75222_d;
        int hotbarStart = this.hotbarSlots.get((int)0).field_75222_d;
        int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).field_75222_d + 1;
        if (slotObject != null && slotObject.func_75216_d()) {
            ItemStack stackInSlot = slotObject.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (slot >= outputSlotStart && slot < outputSlotEnd) {
                if (!this.func_75135_a(stackInSlot, inventoryStart, hotbarEnd, true)) {
                    return null;
                }
                slotObject.func_75220_a(stackInSlot, stack);
            } else if (slot >= inventoryStart && slot < hotbarEnd) {
                Slot ss;
                boolean handledSpecialItem = false;
                Iterator<Slot> i$ = this.specialSlots.iterator();
                while (!(!i$.hasNext() || this.tileEntity.func_94041_b((ss = i$.next()).getSlotIndex(), stackInSlot) && (handledSpecialItem = this.func_75135_a(stackInSlot, ss.field_75222_d, ss.field_75222_d + 1, false)))) {
                }
                if (!handledSpecialItem && (slot >= inventoryStart && slot < hotbarStart ? !this.func_75135_a(stackInSlot, hotbarStart, hotbarEnd, false) : slot >= hotbarStart && slot < hotbarEnd && !this.func_75135_a(stackInSlot, inventoryStart, hotbarStart, false))) {
                    return null;
                }
            } else if (!this.func_75135_a(stackInSlot, inventoryStart, hotbarEnd, false)) {
                return null;
            }
            if (stackInSlot.field_77994_a == 0) {
                slotObject.func_75215_d(null);
            } else {
                slotObject.func_75218_e();
            }
            if (stackInSlot.field_77994_a == stack.field_77994_a) {
                return null;
            }
            slotObject.func_82870_a(player, stackInSlot);
        }
        return stack;
    }
}

