/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.mods.fei.client.gui.element;

import code.elix_x.excore.utils.client.gui.elements.GuiElement;
import code.elix_x.excore.utils.client.gui.elements.IGuiElement;
import code.elix_x.excore.utils.client.gui.elements.IGuiElementsHandler;
import code.elix_x.excore.utils.client.gui.elements.ListGuiElement;
import code.elix_x.excore.utils.color.RGBA;
import code.elix_x.mods.fei.api.gui.FEIGuiOverride;
import code.elix_x.mods.fei.api.gui.elements.IConfigurableFEIGuiElement;
import code.elix_x.mods.fei.api.gui.elements.INotDisableableFEIGuiElement;
import code.elix_x.mods.fei.api.gui.elements.ISaveableFEIGuiElement;
import code.elix_x.mods.fei.api.profile.Profile;
import code.elix_x.mods.fei.client.gui.FEIProfilesSwitcherSettingsGui;
import code.elix_x.mods.fei.client.gui.ProfilesGuiScreen;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import mezz.jei.Internal;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class FEIProfilesSwitcher
extends ListGuiElement<FEIGuiOverride>
implements ISaveableFEIGuiElement,
IConfigurableFEIGuiElement,
INotDisableableFEIGuiElement {
    public static final Gson gson = new Gson();
    public RGBA textColor = new RGBA(1.0f, 1.0f, 1.0f, 1.0f);
    public boolean tooltipBackground = false;
    private boolean focused;

    public FEIProfilesSwitcher() {
        super("FEI Profiles Switcher", 0, 150, 20, 80, 20, 2, 2, new RGBA(0, 0, 0, 0));
        this.inverted = true;
    }

    public int getHeight() {
        return this.focused ? super.getHeight() : this.borderY + 20 + this.borderY;
    }

    @Override
    public void load(Profile profile, JsonObject json) {
        JsonData data = (JsonData)gson.fromJson((JsonElement)json, JsonData.class);
        this.xPos = data.xPos;
        this.yPos = data.yPos;
        this.height = data.height;
        this.borderX = data.borderX;
        this.borderY = data.borderY;
        this.scrollDistance = data.scrollDistance;
        this.clickTimeThreshold = data.clickTimeThreshold;
        this.clickDistanceThreshold = data.clickDistanceThreshold;
        this.backgroundColor = data.backgroundColor;
        this.textColor = data.textColor;
        this.tooltipBackground = data.tooltipBackground;
    }

    @Override
    public JsonObject save(Profile profile) {
        JsonData data = new JsonData();
        data.xPos = this.xPos;
        data.yPos = this.yPos;
        data.height = this.height;
        data.borderX = this.borderX;
        data.borderY = this.borderY;
        data.scrollDistance = this.scrollDistance;
        data.clickTimeThreshold = this.clickTimeThreshold;
        data.clickDistanceThreshold = this.clickDistanceThreshold;
        data.backgroundColor = this.backgroundColor;
        data.textColor = this.textColor;
        data.tooltipBackground = this.tooltipBackground;
        return gson.toJsonTree((Object)data).getAsJsonObject();
    }

    @Override
    public String getUnlocalizedName() {
        return "fei.gui.override.selector.profile";
    }

    @Override
    public void openConfigGui(GuiScreen parent, FEIGuiOverride fei) {
        parent.field_146297_k.func_147108_a((GuiScreen)new FEIProfilesSwitcherSettingsGui(parent, this));
    }

    public void initGui(FEIGuiOverride fei, GuiScreen gui) {
        this.reInitElements();
        for (Profile profile : Profile.getProfiles()) {
            this.add(new FEIProfilesSwitchListElement(profile));
        }
        super.initGui((IGuiElementsHandler)fei, gui);
    }

    public void drawGuiPre(FEIGuiOverride fei, GuiScreen gui, int mouseX, int mouseY) {
        if (this.focused) {
            super.drawGuiPre((IGuiElementsHandler)fei, gui, mouseX, mouseY);
        }
    }

    public void drawBackground(FEIGuiOverride fei, GuiScreen gui, int mouseX, int mouseY) {
        if (this.focused) {
            super.drawBackground((IGuiElementsHandler)fei, gui, mouseX, mouseY);
        }
    }

    public void drawGuiPost(FEIGuiOverride fei, GuiScreen gui, int mouseX, int mouseY) {
        if (this.focused) {
            super.drawGuiPost((IGuiElementsHandler)fei, gui, mouseX, mouseY);
        } else {
            new GuiButtonExt(0, this.getXPos() + this.borderX, this.getYPos() + this.borderY, 20, 20, "").func_146112_a(gui.field_146297_k, mouseX, mouseY);
            FEIProfilesSwitcher.renderItemStackFull((ItemStack)Profile.getCurrentProfile().getIcon(), (int)(this.getXPos() + this.borderX + 2), (int)(this.getYPos() + this.borderY + 2));
            if (this.inside(mouseX, mouseY)) {
                FEIProfilesSwitcher.drawTooltip((FontRenderer)gui.field_146297_k.field_71466_p, (int)mouseX, (int)mouseY, (boolean)false, (boolean)true, (int)0, (RGBA)this.textColor, (boolean)this.tooltipBackground, (boolean)false, (String[])new String[]{Profile.getCurrentProfile().getName()});
            }
        }
    }

    public boolean handleKeyboardEvent(FEIGuiOverride fei, GuiScreen gui, boolean down, int key, char c) {
        if (down) {
            if (gui.func_146271_m() && key == 25 && !Internal.getRuntime().getItemListOverlay().hasKeyboardFocus()) {
                gui.field_146297_k.func_147108_a((GuiScreen)new ProfilesGuiScreen(gui, fei));
                return true;
            }
        }
        if (this.focused) {
            return super.handleKeyboardEvent((IGuiElementsHandler)fei, gui, down, key, c);
        }
        return false;
    }

    public boolean handleMouseEvent(FEIGuiOverride fei, GuiScreen gui, int mouseX, int mouseY, boolean down, int key) {
        if (this.focused) {
            if (!this.inside(mouseX, mouseY)) {
                this.focused = false;
                return true;
            }
            return super.handleMouseEvent((IGuiElementsHandler)fei, gui, mouseX, mouseY, down, key);
        }
        if (down && this.inside(mouseX, mouseY)) {
            if (key == 0) {
                this.focused = true;
                fei.setFocused((IGuiElement<FEIGuiOverride>)this);
                this.initGui(fei, gui);
                return true;
            }
            if (key == 1) {
                gui.field_146297_k.func_147108_a((GuiScreen)new ProfilesGuiScreen(gui, fei));
                return true;
            }
        }
        return false;
    }

    public static class JsonData {
        private int xPos;
        private int yPos;
        private int height;
        private int borderX;
        private int borderY;
        private int scrollDistance;
        private int clickTimeThreshold;
        private int clickDistanceThreshold;
        private RGBA backgroundColor;
        private RGBA textColor;
        private boolean tooltipBackground;

        private JsonData() {
        }
    }

    public class FEIProfilesSwitchListElement
    extends ListGuiElement.ListElement {
        private Profile profile;

        public FEIProfilesSwitchListElement(Profile profile) {
            super((ListGuiElement)FEIProfilesSwitcher.this);
            this.profile = profile;
        }

        public void drawGuiPost(FEIGuiOverride fei, GuiScreen gui, int index, int x, int relY, int mouseX, int mouseY) {
            new GuiButtonExt(0, x, relY, 20, 20, "").func_146112_a(gui.field_146297_k, mouseX, mouseY);
            GuiElement.renderItemStackFull((ItemStack)this.profile.getIcon(), (int)(x + 2), (int)(relY + 2));
        }

        public void drawGuiPostPost(FEIGuiOverride fei, GuiScreen gui, int index, int x, int relY, int mouseX, int mouseY) {
            if (this.inside(relY, mouseX, mouseY)) {
                GuiElement.scissorsPost();
                GuiElement.drawTooltip((FontRenderer)gui.field_146297_k.field_71466_p, (int)mouseX, (int)mouseY, (boolean)false, (boolean)true, (int)0, (RGBA)FEIProfilesSwitcher.this.textColor, (boolean)FEIProfilesSwitcher.this.tooltipBackground, (boolean)false, (String[])new String[]{this.profile.getName()});
                GuiElement.scissorsPre();
            }
        }

        public boolean handleMouseEvent(FEIGuiOverride fei, GuiScreen gui, int index, int x, int relY, int mouseX, int mouseY, boolean down, int key) {
            if (down && key == 0 && this.inside(relY, mouseX, mouseY)) {
                Profile.setCurrentProfile(this.profile);
                FEIProfilesSwitcher.this.focused = false;
                fei.looseFocus();
                return true;
            }
            return false;
        }
    }
}

