/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.mods.fei.client.gui;

import code.elix_x.mods.fei.client.gui.ProfileSettingsGuiScreen;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.ItemFilter;
import mezz.jei.api.IItemListOverlay;
import mezz.jei.api.IItemRegistry;
import mezz.jei.config.Config;
import mezz.jei.gui.Focus;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.GuiItemStackFast;
import mezz.jei.gui.ingredients.GuiItemStackFastList;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.input.GuiTextFieldFilter;
import mezz.jei.input.IKeyable;
import mezz.jei.input.IMouseHandler;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.util.Log;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class SelectProfileIconGuiScreen
extends GuiScreen {
    public final ProfileSettingsGuiScreen parent;
    private ItemListCustom list;
    private ItemStack itemstack;

    public SelectProfileIconGuiScreen(ProfileSettingsGuiScreen parent, ItemStack itemstack) {
        this.parent = parent;
        this.itemstack = itemstack;
        this.list = new ItemListCustom(new ItemFilter((IItemRegistry)Internal.getItemRegistry()));
    }

    public void func_73866_w_() {
        this.list.initGui(this.field_146294_l, this.field_146295_m);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146278_c(0);
        this.list.drawScreen(this.field_146297_k, mouseX, mouseY);
        this.list.drawTooltips(this.field_146297_k, mouseX, mouseY);
    }

    protected void func_73869_a(char c, int key) throws IOException {
        if (key == 1) {
            this.parent.setProfileItemStack(this.itemstack);
            this.field_146297_k.func_147108_a((GuiScreen)this.parent);
            return;
        }
        this.list.onKeyPressed(c, key);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.list.handleMouseScrolled(Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c, this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1, Mouse.getEventDWheel());
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0 && this.list.getStackUnderMouse() != null) {
            this.parent.setProfileItemStack(this.list.getStackUnderMouse());
            this.field_146297_k.func_147108_a((GuiScreen)this.parent);
            return;
        }
        this.list.handleMouseClicked(mouseX, mouseY, mouseButton);
    }

    private static class ItemListCustom
    implements IItemListOverlay,
    IShowsRecipeFocuses,
    IMouseHandler,
    IKeyable {
        private static final int borderPadding = 2;
        private static final int searchHeight = 16;
        private static final int buttonSize = 20;
        private static final String nextLabel = ">";
        private static final String backLabel = "<";
        private static final int itemStackPadding = 1;
        private static final int itemStackWidth = GuiItemStackGroup.getWidth((int)1);
        private static final int itemStackHeight = GuiItemStackGroup.getHeight((int)1);
        private static int firstItemIndex = 0;
        @Nonnull
        private final ItemFilter itemFilter;
        private int screenWidth;
        private int screenHeight;
        private final GuiItemStackFastList guiItemStacks = new GuiItemStackFastList();
        private GuiButton nextButton;
        private GuiButton backButton;
        private GuiTextFieldFilter searchField;
        private String pageNumDisplayString;
        private int pageNumDisplayX;
        private int pageNumDisplayY;
        private GuiItemStackFast hovered = null;

        public ItemListCustom(@Nonnull ItemFilter itemFilter) {
            this.itemFilter = itemFilter;
        }

        public void initGui(int screenWidth, int screenHeight) {
            this.screenWidth = screenWidth;
            this.screenHeight = screenHeight;
            int columns = this.getColumns();
            if (columns < 4) {
                return;
            }
            int rows = this.getRows();
            int xSize = columns * itemStackWidth;
            int xEmptySpace = this.screenWidth - xSize;
            int leftEdge = xEmptySpace / 2;
            int rightEdge = leftEdge + xSize;
            int yItemButtonSpace = this.getItemButtonYSpace();
            int itemButtonsHeight = rows * itemStackHeight;
            int buttonStartY = 24 + (yItemButtonSpace - itemButtonsHeight) / 2;
            ItemListCustom.createItemButtons(this.guiItemStacks, leftEdge, buttonStartY, columns, rows);
            this.nextButton = new GuiButtonExt(0, rightEdge - 20, 2, 20, 20, nextLabel);
            this.backButton = new GuiButtonExt(1, leftEdge, 2, 20, 20, backLabel);
            int configButtonX = rightEdge - 20 + 1;
            int configButtonY = this.screenHeight - 20 - 2;
            int searchFieldY = this.screenHeight - 16 - 2 - 2;
            int searchFieldWidth = rightEdge - leftEdge;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            this.searchField = new GuiTextFieldFilter(0, fontRenderer, leftEdge, searchFieldY, searchFieldWidth, 16);
            this.setKeyboardFocus(false);
            this.searchField.setItemFilter(this.itemFilter);
            this.updateLayout();
        }

        private static void createItemButtons(@Nonnull GuiItemStackFastList guiItemStacks, int xStart, int yStart, int columnCount, int rowCount) {
            guiItemStacks.clear();
            for (int row = 0; row < rowCount; ++row) {
                int y = yStart + row * itemStackHeight;
                for (int column = 0; column < columnCount; ++column) {
                    int x = xStart + column * itemStackWidth;
                    guiItemStacks.add(new GuiItemStackFast(x, y, 1));
                }
            }
        }

        private static boolean intersects(List<Rectangle> areas, Rectangle comparisonArea) {
            for (Rectangle area : areas) {
                if (!area.intersects(comparisonArea)) continue;
                return true;
            }
            return false;
        }

        private void updateLayout() {
            ImmutableList itemList = this.itemFilter.getItemList();
            this.guiItemStacks.set(firstItemIndex, (List)itemList);
            FontRenderer fontRendererObj = Minecraft.func_71410_x().field_71466_p;
            this.pageNumDisplayString = this.getPageNum() + 1 + "/" + this.getPageCount();
            int pageDisplayWidth = fontRendererObj.func_78256_a(this.pageNumDisplayString);
            this.pageNumDisplayX = (this.backButton.field_146128_h + this.backButton.field_146120_f + this.nextButton.field_146128_h) / 2 - pageDisplayWidth / 2;
            this.pageNumDisplayY = this.backButton.field_146129_i + Math.round((float)(this.backButton.field_146121_g - fontRendererObj.field_78288_b) / 2.0f);
            this.searchField.update();
        }

        private void nextPage() {
            int itemsCount = this.itemFilter.size();
            if (itemsCount == 0) {
                firstItemIndex = 0;
                return;
            }
            if ((firstItemIndex += this.guiItemStacks.size()) >= itemsCount) {
                firstItemIndex = 0;
            }
            this.updateLayout();
        }

        private void previousPage() {
            int itemsPerPage = this.guiItemStacks.size();
            if (itemsPerPage == 0) {
                firstItemIndex = 0;
                return;
            }
            int itemsCount = this.itemFilter.size();
            int pageNum = firstItemIndex / itemsPerPage;
            pageNum = pageNum == 0 ? itemsCount / itemsPerPage : --pageNum;
            firstItemIndex = itemsPerPage * pageNum;
            this.updateLayout();
        }

        public void drawScreen(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
            GlStateManager.func_179140_f();
            minecraft.field_71466_p.func_175065_a(this.pageNumDisplayString, (float)this.pageNumDisplayX, (float)this.pageNumDisplayY, Color.white.getRGB(), true);
            this.searchField.func_146194_f();
            this.nextButton.func_146112_a(minecraft, mouseX, mouseY);
            this.backButton.func_146112_a(minecraft, mouseX, mouseY);
            GlStateManager.func_179084_k();
            if (this.shouldShowDeleteItemTooltip(minecraft)) {
                this.hovered = this.guiItemStacks.render(minecraft, false, mouseX, mouseY);
            } else {
                boolean mouseOver = this.isMouseOver(mouseX, mouseY);
                this.hovered = this.guiItemStacks.render(minecraft, mouseOver, mouseX, mouseY);
            }
            if (this.hovered != null) {
                RenderHelper.func_74520_c();
                this.hovered.drawHovered(minecraft);
                RenderHelper.func_74518_a();
            }
            GlStateManager.func_179141_d();
        }

        private boolean shouldShowDeleteItemTooltip(Minecraft minecraft) {
            if (Config.isDeleteItemsInCheatModeActive()) {
                EntityPlayerSP player = minecraft.field_71439_g;
                if (player.field_71071_by.func_70445_o() != null) {
                    return true;
                }
            }
            return false;
        }

        public void drawTooltips(@Nonnull Minecraft minecraft, int mouseX, int mouseY) {
            boolean mouseOver = this.isMouseOver(mouseX, mouseY);
            if (mouseOver && this.shouldShowDeleteItemTooltip(minecraft)) {
                String deleteItem = Translator.translateToLocal((String)"jei.tooltip.delete.item");
                TooltipRenderer.drawHoveringText((Minecraft)minecraft, (String)deleteItem, (int)mouseX, (int)mouseY);
            }
            if (this.hovered != null) {
                this.hovered.drawTooltip(minecraft, mouseX, mouseY);
            }
        }

        public void handleTick() {
            if (this.searchField != null) {
                this.searchField.func_146178_a();
            }
        }

        public boolean isMouseOver(int mouseX, int mouseY) {
            return true;
        }

        @Nullable
        public Focus getFocusUnderMouse(int mouseX, int mouseY) {
            if (!this.isMouseOver(mouseX, mouseY)) {
                return null;
            }
            Focus focus = this.guiItemStacks.getFocusUnderMouse(mouseX, mouseY);
            if (focus != null) {
                this.setKeyboardFocus(false);
                focus.setAllowsCheating();
            }
            return focus;
        }

        public boolean canSetFocusWithMouse() {
            return true;
        }

        public boolean handleMouseClicked(int mouseX, int mouseY, int mouseButton) {
            if (!this.isMouseOver(mouseX, mouseY)) {
                this.setKeyboardFocus(false);
                return false;
            }
            boolean buttonClicked = this.handleMouseClickedButtons(mouseX, mouseY);
            if (buttonClicked) {
                this.setKeyboardFocus(false);
                return true;
            }
            return this.handleMouseClickedSearch(mouseX, mouseY, mouseButton);
        }

        public boolean handleMouseScrolled(int mouseX, int mouseY, int scrollDelta) {
            if (!this.isMouseOver(mouseX, mouseY)) {
                return false;
            }
            if (scrollDelta < 0) {
                this.nextPage();
                return true;
            }
            if (scrollDelta > 0) {
                this.previousPage();
                return true;
            }
            return false;
        }

        private boolean handleMouseClickedButtons(int mouseX, int mouseY) {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (this.nextButton.func_146116_c(minecraft, mouseX, mouseY)) {
                this.nextPage();
                this.nextButton.func_146113_a(minecraft.func_147118_V());
                return true;
            }
            if (this.backButton.func_146116_c(minecraft, mouseX, mouseY)) {
                this.previousPage();
                this.backButton.func_146113_a(minecraft.func_147118_V());
                return true;
            }
            return false;
        }

        private boolean handleMouseClickedSearch(int mouseX, int mouseY, int mouseButton) {
            boolean searchClicked = this.searchField.isMouseOver(mouseX, mouseY);
            this.setKeyboardFocus(searchClicked);
            if (searchClicked && this.searchField.handleMouseClicked(mouseX, mouseY, mouseButton)) {
                this.updateLayout();
            }
            return searchClicked;
        }

        public boolean hasKeyboardFocus() {
            return this.searchField != null && this.searchField.func_146206_l();
        }

        public void setKeyboardFocus(boolean keyboardFocus) {
            if (this.searchField != null) {
                this.searchField.func_146195_b(keyboardFocus);
            }
        }

        public boolean onKeyPressed(char typedChar, int keyCode) {
            if (this.hasKeyboardFocus()) {
                char character = Keyboard.getEventCharacter();
                boolean changed = this.searchField.func_146201_a(character, Keyboard.getEventKey());
                if (changed) {
                    while (firstItemIndex >= this.itemFilter.size() && firstItemIndex > 0) {
                        this.previousPage();
                    }
                    this.updateLayout();
                }
                return changed || ChatAllowedCharacters.func_71566_a((char)character);
            }
            return false;
        }

        private int getItemButtonXSpace() {
            return this.screenWidth - 4;
        }

        private int getItemButtonYSpace() {
            return this.screenHeight - 46;
        }

        private int getColumns() {
            return this.getItemButtonXSpace() / itemStackWidth;
        }

        private int getRows() {
            return this.getItemButtonYSpace() / itemStackHeight;
        }

        private int getPageCount() {
            int itemCount = this.itemFilter.size();
            int stacksPerPage = this.guiItemStacks.size();
            if (stacksPerPage == 0) {
                return 1;
            }
            int pageCount = MathUtil.divideCeil((int)itemCount, (int)stacksPerPage);
            pageCount = Math.max(1, pageCount);
            return pageCount;
        }

        private int getPageNum() {
            int stacksPerPage = this.guiItemStacks.size();
            if (stacksPerPage == 0) {
                return 1;
            }
            return firstItemIndex / stacksPerPage;
        }

        @Nullable
        public ItemStack getStackUnderMouse() {
            if (this.hovered == null) {
                return null;
            }
            return this.hovered.getItemStack();
        }

        public void setFilterText(@Nullable String filterText) {
            if (filterText == null) {
                Log.error((String)"null filterText", (Object[])new Object[]{new NullPointerException()});
                return;
            }
            this.searchField.func_146180_a(filterText);
        }

        @Nonnull
        public String getFilterText() {
            return this.searchField.func_146179_b();
        }
    }
}

