/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.mods.fei.client.gui;

import code.elix_x.excore.utils.client.gui.elements.ButtonGuiElement;
import code.elix_x.excore.utils.client.gui.elements.IGuiElement;
import code.elix_x.excore.utils.client.gui.elements.IntegralIncrementerGuiElement;
import code.elix_x.excore.utils.client.gui.elements.StringGuiElement;
import code.elix_x.excore.utils.color.RGBA;
import code.elix_x.mods.fei.api.gui.ElementBasicSettingsGuiScreen;
import code.elix_x.mods.fei.api.gui.FEIGuiOverride;
import code.elix_x.mods.fei.client.gui.ConfigureGridUtilitiesGui;
import code.elix_x.mods.fei.client.gui.element.FEIUtilsGrid;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.util.Rectangle;

public class FEIUtilsGridSettingsGui
extends ElementBasicSettingsGuiScreen {
    private FEIUtilsGrid grid;

    public FEIUtilsGridSettingsGui(GuiScreen parent, FEIUtilsGrid grid) {
        super(parent, grid.toRectangle(), true, true, grid.getBorderX(), grid.getBorderY(), grid.backgroundColor, grid.textColor, grid.tooltipBackground);
        this.grid = grid;
    }

    @Override
    protected void addElements() {
        this.add((IGuiElement)new ButtonGuiElement("Utilities", this.xPos, this.nextY, this.guiWidth - 4, 20, 2, 2, I18n.func_74838_a((String)"fei.gui.settings.grid.utilities")){

            public void onButtonPressed() {
                super.onButtonPressed();
                FEIUtilsGridSettingsGui.this.field_146297_k.func_147108_a((GuiScreen)new ConfigureGridUtilitiesGui((GuiScreen)FEIUtilsGridSettingsGui.this, FEIUtilsGridSettingsGui.this.grid));
            }
        });
        this.nextY += 24;
        super.addElements();
        String ex = I18n.func_74838_a((String)"fei.gui.settings.grid.elementx") + " ";
        String ey = I18n.func_74838_a((String)"fei.gui.settings.elementy") + " ";
        int sw = Math.max(this.field_146289_q.func_78256_a(ex), this.field_146289_q.func_78256_a(ey));
        this.add((IGuiElement)new StringGuiElement("Element X", this.xPos, this.nextY + 16 - 8, 2, 2, ex, this.field_146289_q, new RGBA(1.0f, 1.0f, 1.0f, 1.0f)));
        this.add((IGuiElement)new IntegralIncrementerGuiElement("Element X Incrementer", this.xPos + 2 + sw + 2, this.nextY, 24, 8, 16, 2, 2, 1, 2, 64, this.grid.elementX){

            public int getValue() {
                return ((FEIUtilsGridSettingsGui)FEIUtilsGridSettingsGui.this).grid.elementX;
            }

            public void setValue(int value) {
                super.setValue(value);
                ((FEIUtilsGridSettingsGui)FEIUtilsGridSettingsGui.this).grid.elementX = this.value;
                FEIUtilsGridSettingsGui.this.element.setWidth(FEIUtilsGridSettingsGui.this.grid.getWidth());
            }
        });
        this.nextY += 20;
        this.add((IGuiElement)new StringGuiElement("Element Y", this.xPos, this.nextY + 16 - 8, 2, 2, ey, this.field_146289_q, new RGBA(1.0f, 1.0f, 1.0f, 1.0f)));
        this.add((IGuiElement)new IntegralIncrementerGuiElement("Element Y Incrementer", this.xPos + 2 + sw + 2, this.nextY, 24, 8, 16, 2, 2, 1, 2, 64, this.grid.elementY){

            public int getValue() {
                return ((FEIUtilsGridSettingsGui)FEIUtilsGridSettingsGui.this).grid.elementY;
            }

            public void setValue(int value) {
                super.setValue(value);
                ((FEIUtilsGridSettingsGui)FEIUtilsGridSettingsGui.this).grid.elementY = this.value;
                FEIUtilsGridSettingsGui.this.element.setHeight(FEIUtilsGridSettingsGui.this.grid.getHeight());
            }
        });
        this.nextY += 20;
    }

    @Override
    protected int checkSizeX(int prevSize) {
        for (int x = this.borderX; x <= prevSize + this.grid.elementX + this.borderX; x += this.grid.elementX + this.borderX) {
        }
        return x -= this.grid.elementX + this.borderX;
    }

    @Override
    protected int checkSizeY(int prevSize) {
        for (int y = this.borderY; y <= prevSize + this.grid.elementY + this.borderY; y += this.grid.elementY + this.borderY) {
        }
        return y -= this.grid.elementY + this.borderY;
    }

    @Override
    protected void setBorderX(int borderX) {
        this.grid.setBorderX(borderX);
        this.element.setWidth(this.grid.getWidth());
        this.borderX = borderX;
    }

    @Override
    protected void setBorderY(int borderY) {
        this.grid.setBorderY(borderY);
        this.element.setHeight(this.grid.getHeight());
        this.borderY = borderY;
    }

    @Override
    protected void drawElement(Rectangle element) {
        this.grid.setXPos(element.getX());
        this.grid.setYPos(element.getY());
        this.grid.setBorderX(this.borderX);
        this.grid.setBorderY(this.borderY);
        this.grid.setElementsXY((element.getWidth() - this.borderX) / (this.grid.elementX + this.borderX), (element.getHeight() - this.borderY) / (this.grid.elementY + this.borderY));
        this.grid.drawGuiPost(FEIGuiOverride.instance(), (GuiScreen)this, -1, -1);
    }

    protected void onClose() {
        this.grid.setXPos(this.element.getX());
        this.grid.setYPos(this.element.getY());
        this.grid.setBorderX(this.borderX);
        this.grid.setBorderY(this.borderY);
        this.grid.setElementsXY((this.element.getWidth() - this.borderX) / (this.grid.elementX + this.borderX), (this.element.getHeight() - this.borderY) / (this.grid.elementY + this.borderY));
        this.grid.tooltipBackground = this.tooltipBackground;
    }
}

