/*
 * Decompiled with CFR 0.152.
 */
package mod.flatcoloredblocks.config;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import mod.flatcoloredblocks.FlatColoredBlocks;
import mod.flatcoloredblocks.config.Configured;
import mod.flatcoloredblocks.config.EnumFlatBlockTextures;
import mod.flatcoloredblocks.config.EnumFlatTransparentBlockTextures;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModConfig
extends Configuration {
    private final File myPath;
    public int LAST_MAX_SHADES;
    @Configured(category="Crafing")
    public String solidCraftingBlock;
    @Configured(category="Crafing")
    public String transparentCraftingBlock;
    @Configured(category="Crafing")
    public String glowingCraftingBlock;
    @Configured(category="Crafing")
    public int solidCraftingOutput;
    @Configured(category="Crafing")
    public int transparentCraftingOutput;
    @Configured(category="Crafing")
    public int glowingCraftingOutput;
    @Configured(category="Integration")
    public boolean ShowBlocksInJEI;
    @Configured(category="Saturation")
    public int SATURATION_SHADES;
    @Configured(category="Saturation")
    public double SATURATION_RANGE_EXPONENT;
    @Configured(category="Saturation")
    public double SATURATION_MIN;
    @Configured(category="Saturation")
    public double SATURATION_MAX;
    @Configured(category="Saturation")
    public int SATURATION_SHADES_GLOWING;
    @Configured(category="Saturation")
    public double SATURATION_RANGE_EXPONENT_GLOWING;
    @Configured(category="Saturation")
    public double SATURATION_MIN_GLOWING;
    @Configured(category="Saturation")
    public double SATURATION_MAX_GLOWING;
    @Configured(category="Saturation")
    public int SATURATION_SHADES_TRANSPARENT;
    @Configured(category="Saturation")
    public double SATURATION_RANGE_EXPONENT_TRANSPARENT;
    @Configured(category="Saturation")
    public double SATURATION_MIN_TRANSPARENT;
    @Configured(category="Saturation")
    public double SATURATION_MAX_TRANSPARENT;
    @Configured(category="Hue")
    public int HUE_SHADES;
    @Configured(category="Hue")
    public double HUE_RANGE_EXPONENT;
    @Configured(category="Hue")
    public double HUE_MIN;
    @Configured(category="Hue")
    public double HUE_MAX;
    @Configured(category="Hue")
    public int HUE_SHADES_GLOWING;
    @Configured(category="Hue")
    public double HUE_RANGE_EXPONENT_GLOWING;
    @Configured(category="Hue")
    public double HUE_MIN_GLOWING;
    @Configured(category="Hue")
    public double HUE_MAX_GLOWING;
    @Configured(category="Hue")
    public int HUE_SHADES_TRANSPARENT;
    @Configured(category="Hue")
    public double HUE_RANGE_EXPONENT_TRANSPARENT;
    @Configured(category="Hue")
    public double HUE_MIN_TRANSPARENT;
    @Configured(category="Hue")
    public double HUE_MAX_TRANSPARENT;
    @Configured(category="Value")
    public int VALUE_SHADES;
    @Configured(category="Value")
    public double VALUE_RANGE_EXPONENT;
    @Configured(category="Value")
    public double VALUE_MIN;
    @Configured(category="Value")
    public double VALUE_MAX;
    @Configured(category="Value")
    public int VALUE_SHADES_GLOWING;
    @Configured(category="Value")
    public double VALUE_RANGE_EXPONENT_GLOWING;
    @Configured(category="Value")
    public double VALUE_MIN_GLOWING;
    @Configured(category="Value")
    public double VALUE_MAX_GLOWING;
    @Configured(category="Value")
    public int VALUE_SHADES_TRANSPARENT;
    @Configured(category="Value")
    public double VALUE_RANGE_EXPONENT_TRANSPARENT;
    @Configured(category="Value")
    public double VALUE_MIN_TRANSPARENT;
    @Configured(category="Value")
    public double VALUE_MAX_TRANSPARENT;
    @Configured(category="Glowing")
    public boolean GLOWING_EMITS_LIGHT;
    @Configured(category="Glowing")
    public int GLOWING_SHADES;
    @Configured(category="Glowing")
    public double GLOWING_RANGE_EXPONENT;
    @Configured(category="Glowing")
    public double GLOWING_MIN;
    @Configured(category="Glowing")
    public double GLOWING_MAX;
    @Configured(category="Transparency")
    public int TRANSPARENCY_SHADES;
    @Configured(category="Transparency")
    public double TRANSPARENCY_RANGE_EXPONENT;
    @Configured(category="Transparency")
    public double TRANSPARENCY_MIN;
    @Configured(category="Transparency")
    public double TRANSPARENCY_MAX;
    @Configured(category="Texture")
    public EnumFlatBlockTextures DISPLAY_TEXTURE;
    @Configured(category="Texture")
    public EnumFlatBlockTextures DISPLAY_TEXTURE_GLOWING;
    @Configured(category="Texture")
    public EnumFlatTransparentBlockTextures DISPLAY_TEXTURE_TRANSPARENT;

    void setDefaults() {
        this.solidCraftingBlock = "cobblestone";
        this.transparentCraftingBlock = "blockGlass";
        this.glowingCraftingBlock = "glowstone";
        this.solidCraftingOutput = 1;
        this.transparentCraftingOutput = 1;
        this.glowingCraftingOutput = 1;
        this.LAST_MAX_SHADES = 0;
        this.GLOWING_SHADES = 1;
        this.GLOWING_RANGE_EXPONENT = 1.0;
        this.GLOWING_MIN = 1.0;
        this.GLOWING_MAX = 1.0;
        this.GLOWING_EMITS_LIGHT = true;
        this.TRANSPARENCY_SHADES = 1;
        this.TRANSPARENCY_RANGE_EXPONENT = 1.0;
        this.TRANSPARENCY_MIN = 0.5;
        this.TRANSPARENCY_MAX = 0.5;
        this.HUE_SHADES = 32;
        this.SATURATION_SHADES = 4;
        this.VALUE_SHADES = 10;
        this.SATURATION_RANGE_EXPONENT = 0.9;
        this.SATURATION_MIN = 0.2;
        this.SATURATION_MAX = 1.0;
        this.HUE_RANGE_EXPONENT = 1.0;
        this.HUE_MIN = 0.0;
        this.HUE_MAX = 0.96;
        this.VALUE_RANGE_EXPONENT = 1.0;
        this.VALUE_MIN = 0.2;
        this.VALUE_MAX = 1.0;
        this.HUE_SHADES_GLOWING = 32;
        this.SATURATION_SHADES_GLOWING = 4;
        this.VALUE_SHADES_GLOWING = 10;
        this.SATURATION_RANGE_EXPONENT_GLOWING = 0.9;
        this.SATURATION_MIN_GLOWING = 0.2;
        this.SATURATION_MAX_GLOWING = 1.0;
        this.HUE_RANGE_EXPONENT_GLOWING = 1.0;
        this.HUE_MIN_GLOWING = 0.0;
        this.HUE_MAX_GLOWING = 0.96;
        this.VALUE_RANGE_EXPONENT_GLOWING = 1.0;
        this.VALUE_MIN_GLOWING = 0.2;
        this.VALUE_MAX_GLOWING = 1.0;
        this.HUE_SHADES_TRANSPARENT = 32;
        this.SATURATION_SHADES_TRANSPARENT = 4;
        this.VALUE_SHADES_TRANSPARENT = 10;
        this.SATURATION_RANGE_EXPONENT_TRANSPARENT = 0.9;
        this.SATURATION_MIN_TRANSPARENT = 0.2;
        this.SATURATION_MAX_TRANSPARENT = 1.0;
        this.HUE_RANGE_EXPONENT_TRANSPARENT = 1.0;
        this.HUE_MIN_TRANSPARENT = 0.0;
        this.HUE_MAX_TRANSPARENT = 0.96;
        this.VALUE_RANGE_EXPONENT_TRANSPARENT = 1.0;
        this.VALUE_MIN_TRANSPARENT = 0.2;
        this.VALUE_MAX_TRANSPARENT = 1.0;
        this.DISPLAY_TEXTURE = EnumFlatBlockTextures.DRYWALL;
        this.DISPLAY_TEXTURE_GLOWING = EnumFlatBlockTextures.PULSE;
        this.DISPLAY_TEXTURE_TRANSPARENT = EnumFlatTransparentBlockTextures.SEMI_GLASS;
        this.ShowBlocksInJEI = false;
    }

    public ModConfig(File path) {
        super(path);
        this.myPath = path;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setDefaults();
        this.populateSettings();
        this.save();
    }

    public void updateLastMaxShades() {
        this.LAST_MAX_SHADES = FlatColoredBlocks.instance.getFullNumberOfShades();
        this.get("StartupGui", "LAST_MAX_SHADES", this.LAST_MAX_SHADES).set(this.LAST_MAX_SHADES);
    }

    void populateSettings() {
        this.LAST_MAX_SHADES = this.get("StartupGui", "LAST_MAX_SHADES", 0).getInt();
        Class<ModConfig> me = ModConfig.class;
        for (Field f : me.getDeclaredFields()) {
            Configured c = f.getAnnotation(Configured.class);
            if (c == null) continue;
            try {
                if (f.getType() == Long.TYPE || f.getType() == Long.class) {
                    long defaultValue = f.getLong((Object)this);
                    long value = this.get(c.category(), f.getName(), (int)defaultValue).getInt();
                    f.set((Object)this, value);
                    continue;
                }
                if (f.getType().isEnum()) {
                    Enum defaultValue = (Enum)f.get((Object)this);
                    try {
                        Enum[] valuesList = (Enum[])f.getType().getMethod("values", new Class[0]).invoke(null, new Object[0]);
                        String[] values = new String[valuesList.length];
                        for (int x = 0; x < values.length; ++x) {
                            values[x] = valuesList[x].name();
                        }
                        String strValue = this.get(c.category(), f.getName(), defaultValue.name(), "", values).getString();
                        Method method = f.getType().getMethod("valueOf", Class.class, String.class);
                        Enum value = (Enum)method.invoke(null, f.getType(), strValue);
                        f.set((Object)this, value);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (f.getType() == String.class) {
                    String defaultValue = (String)f.get((Object)this);
                    String value = this.get(c.category(), f.getName(), defaultValue).getString();
                    f.set((Object)this, value);
                    continue;
                }
                if (f.getType() == Integer.TYPE || f.getType() == Integer.class) {
                    int defaultValue = f.getInt((Object)this);
                    int value = this.get(c.category(), f.getName(), defaultValue).getInt();
                    f.set((Object)this, value);
                    continue;
                }
                if (f.getType() == Double.TYPE || f.getType() == Double.class) {
                    double defaultValue = f.getDouble((Object)this);
                    double value = this.get(c.category(), f.getName(), defaultValue).getDouble();
                    f.set((Object)this, value);
                    continue;
                }
                if (f.getType() != Boolean.TYPE && f.getType() != Boolean.class) continue;
                boolean defaultValue = f.getBoolean((Object)this);
                boolean value = this.get(c.category(), f.getName(), defaultValue).getBoolean();
                f.set((Object)this, value);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Property get(String category, String key, String defaultValue, String comment, Property.Type type) {
        Property prop = super.get(category, key, defaultValue, comment, type);
        return prop == null ? null : prop.setRequiresMcRestart(true);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals("flatcoloredblocks")) {
            this.populateSettings();
            this.save();
        }
    }

    public void save() {
        if (this.hasChanged()) {
            super.save();
        }
    }

    public String getFilePath() {
        return this.myPath.getAbsolutePath();
    }
}

