/*
 * Decompiled with CFR 0.152.
 */
package mod.flatcoloredblocks.block;

import java.util.Set;
import mod.flatcoloredblocks.block.BlockFlatColored;
import mod.flatcoloredblocks.block.EnumFlatColorAttributes;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public class ItemBlockFlatColored
extends ItemBlock {
    public BlockFlatColored getColoredBlock() {
        return (BlockFlatColored)this.field_150939_a;
    }

    private IBlockState getStateFromStack(ItemStack stack) {
        return this.func_179223_d().func_176203_a(stack.func_77952_i());
    }

    private String getColorPrefix(Set<EnumFlatColorAttributes> which) {
        if (which.contains((Object)EnumFlatColorAttributes.dark)) {
            return "flatcoloredblocks.dark";
        }
        if (which.contains((Object)EnumFlatColorAttributes.light)) {
            return "flatcoloredblocks.light";
        }
        return "flatcoloredblocks.";
    }

    private String getColorHueName(Set<EnumFlatColorAttributes> characteristics) {
        for (EnumFlatColorAttributes c : characteristics) {
            if (c.isModifier) continue;
            return c.name();
        }
        return EnumFlatColorAttributes.black.name();
    }

    public ItemBlockFlatColored(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77653_i(ItemStack stack) {
        IBlockState state = this.getStateFromStack(stack);
        int shadeNum = this.getColoredBlock().getShadeNumber(state);
        Set<EnumFlatColorAttributes> colorChars = this.getColoredBlock().getFlatColorAttributes(state);
        String type = this.getTypeLocalization();
        String prefix = this.getColorPrefix(colorChars);
        String hue = this.getColorHueName(colorChars);
        return type + I18n.func_74838_a((String)(prefix + hue + ".name")) + " #" + shadeNum;
    }

    private String getTypeLocalization() {
        switch (this.getColoredBlock().getType()) {
            case GLOWING: {
                return I18n.func_74838_a((String)"flatcoloredblocks.Glowing.name") + " ";
            }
            case TRANSPARENT: {
                return I18n.func_74838_a((String)"flatcoloredblocks.Transparent.name") + " ";
            }
        }
        return "";
    }

    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        IBlockState state = this.getStateFromStack(stack);
        return this.getColoredBlock().colorFromState(state);
    }
}

