/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.TeslaUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public final class WorldUtil {
    public static boolean doItemInteraction(int slotExtract, int slotInsert, TileEntity extract, TileEntity insert, EnumFacing extractSide, EnumFacing insertSide) {
        ItemStack remaining;
        ItemStack theoreticalExtract = WorldUtil.extractItem(slotExtract, extract, extractSide, Integer.MAX_VALUE, true);
        if (theoreticalExtract != null && !ItemStack.func_77989_b((ItemStack)(remaining = WorldUtil.insertItem(slotInsert, insert, insertSide, theoreticalExtract, false)), (ItemStack)theoreticalExtract)) {
            int toExtract = remaining == null ? theoreticalExtract.field_77994_a : theoreticalExtract.field_77994_a - remaining.field_77994_a;
            WorldUtil.extractItem(slotExtract, extract, extractSide, toExtract, false);
            return true;
        }
        return false;
    }

    public static ItemStack insertItem(int slotInsert, TileEntity insert, EnumFacing insertSide, ItemStack stack, boolean simulate) {
        IItemHandler insertCap;
        if (insert.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, insertSide) && (insertCap = (IItemHandler)insert.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, insertSide)) != null) {
            return insertCap.insertItem(slotInsert, stack, simulate);
        }
        return stack;
    }

    public static ItemStack extractItem(int slotExtract, TileEntity extract, EnumFacing extractSide, int amount, boolean simulate) {
        IItemHandler extractCap;
        if (extract.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, extractSide) && (extractCap = (IItemHandler)extract.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, extractSide)) != null) {
            return extractCap.extractItem(slotExtract, amount, simulate);
        }
        return null;
    }

    public static void doEnergyInteraction(TileEntity tile) {
        for (EnumFacing side : EnumFacing.values()) {
            TileEntity otherTile = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177972_a(side));
            if (otherTile == null) continue;
            IEnergyReceiver handlerTo = null;
            IEnergyProvider handlerFrom = null;
            if (tile instanceof IEnergyProvider && otherTile instanceof IEnergyReceiver) {
                handlerTo = (IEnergyReceiver)otherTile;
                handlerFrom = (IEnergyProvider)tile;
            } else if (tile instanceof IEnergyReceiver && otherTile instanceof IEnergyProvider) {
                handlerTo = (IEnergyReceiver)tile;
                handlerFrom = (IEnergyProvider)otherTile;
            }
            if (handlerFrom != null && handlerTo != null) {
                int drain = handlerFrom.extractEnergy(side, Integer.MAX_VALUE, true);
                if (drain <= 0 || !handlerTo.canConnectEnergy(side.func_176734_d())) continue;
                int filled = handlerTo.receiveEnergy(side.func_176734_d(), drain, false);
                handlerFrom.extractEnergy(side, filled, false);
                continue;
            }
            if (!ActuallyAdditions.teslaLoaded) continue;
            TeslaUtil.doWrappedTeslaRFInteraction(tile, otherTile, side);
        }
    }

    public static void doFluidInteraction(TileEntity tile) {
        block0: for (EnumFacing side : EnumFacing.values()) {
            TileEntity otherTile = tile.func_145831_w().func_175625_s(tile.func_174877_v().func_177972_a(side));
            if (otherTile == null) continue;
            for (int i = 0; i < 2; ++i) {
                int filled;
                FluidStack drain;
                if (tile instanceof net.minecraftforge.fluids.IFluidHandler && otherTile instanceof net.minecraftforge.fluids.IFluidHandler) {
                    net.minecraftforge.fluids.IFluidHandler handlerTo = (net.minecraftforge.fluids.IFluidHandler)(i == 0 ? tile : otherTile);
                    net.minecraftforge.fluids.IFluidHandler handlerFrom = (net.minecraftforge.fluids.IFluidHandler)(i == 0 ? otherTile : tile);
                    drain = handlerFrom.drain(side, Integer.MAX_VALUE, false);
                    if (drain == null || !handlerTo.canFill(side.func_176734_d(), drain.getFluid())) continue;
                    filled = handlerTo.fill(side.func_176734_d(), drain.copy(), true);
                    handlerFrom.drain(side, filled, true);
                    continue block0;
                }
                IFluidHandler handlerFrom = (IFluidHandler)(i == 0 ? tile : otherTile).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, i == 0 ? side : side.func_176734_d());
                IFluidHandler handlerTo = (IFluidHandler)(i == 0 ? otherTile : tile).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, i == 0 ? side.func_176734_d() : side);
                if (handlerFrom == null || handlerTo == null || (drain = handlerFrom.drain(Integer.MAX_VALUE, false)) == null) continue;
                filled = handlerTo.fill(drain.copy(), true);
                handlerFrom.drain(filled, true);
                continue block0;
            }
        }
    }

    public static boolean hasBlocksInPlacesGiven(BlockPos[] positions, Block block, int meta, World world) {
        for (BlockPos pos : positions) {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() == block && block.func_176201_c(state) == meta) continue;
            return false;
        }
        return true;
    }

    public static ItemStack useItemAtSide(EnumFacing side, World world, BlockPos pos, ItemStack stack) {
        if (world instanceof WorldServer && stack != null && stack.func_77973_b() != null) {
            BlockPos offsetPos = pos.func_177972_a(side);
            IBlockState state = world.func_180495_p(offsetPos);
            Block block = state.func_177230_c();
            boolean replaceable = block.func_176200_f((IBlockAccess)world, offsetPos);
            if (replaceable && !(block instanceof IFluidBlock) && !(block instanceof BlockLiquid)) {
                FluidStack fluid = null;
                if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
                    fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
                } else if (stack.func_77973_b() instanceof IFluidContainerItem) {
                    fluid = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
                }
                if (fluid != null && fluid.amount >= 1000 && fluid.getFluid().getBlock() != null && fluid.getFluid().getBlock().func_176196_c(world, offsetPos) && world.func_180501_a(offsetPos, fluid.getFluid().getBlock().func_176223_P(), 2)) {
                    return stack.func_77973_b().getContainerItem(stack);
                }
            }
            if (replaceable && stack.func_77973_b() == Items.field_151137_ax) {
                world.func_180501_a(offsetPos, Blocks.field_150488_af.func_176223_P(), 2);
                --stack.field_77994_a;
                return stack;
            }
            if (replaceable && stack.func_77973_b() instanceof IPlantable && ((IPlantable)stack.func_77973_b()).getPlant((IBlockAccess)world, offsetPos).func_177230_c().func_176196_c(world, offsetPos) && world.func_180501_a(offsetPos, ((IPlantable)stack.func_77973_b()).getPlant((IBlockAccess)world, offsetPos), 2)) {
                --stack.field_77994_a;
                return stack;
            }
            try {
                if (world instanceof WorldServer) {
                    FakePlayer fake = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
                    stack.func_179546_a((EntityPlayer)fake, world, offsetPos, fake.func_184600_cs(), side.func_176734_d(), 0.5f, 0.5f, 0.5f);
                    return stack;
                }
            }
            catch (Exception e) {
                ModUtil.LOGGER.error("Something that places Blocks at " + offsetPos.func_177958_n() + ", " + offsetPos.func_177956_o() + ", " + offsetPos.func_177952_p() + " in World " + world.field_73011_w.getDimension() + " threw an Exception! Don't let that happen again!", (Throwable)e);
            }
        }
        return stack;
    }

    public static void dropItemAtSide(EnumFacing side, World world, BlockPos pos, ItemStack stack) {
        BlockPos coords = pos.func_177972_a(side);
        EntityItem item = new EntityItem(world, (double)coords.func_177958_n() + 0.5, (double)coords.func_177956_o() + 0.5, (double)coords.func_177952_p() + 0.5, stack);
        item.field_70159_w = 0.0;
        item.field_70181_x = 0.0;
        item.field_70179_y = 0.0;
        world.func_72838_d((Entity)item);
    }

    public static EnumFacing getDirectionBySidesInOrder(int side) {
        switch (side) {
            case 0: {
                return EnumFacing.UP;
            }
            case 1: {
                return EnumFacing.DOWN;
            }
            case 2: {
                return EnumFacing.NORTH;
            }
            case 3: {
                return EnumFacing.EAST;
            }
            case 4: {
                return EnumFacing.SOUTH;
            }
        }
        return EnumFacing.WEST;
    }

    public static EnumFacing getDirectionByPistonRotation(int meta) {
        return EnumFacing.values()[meta];
    }

    public static ArrayList<Material> getMaterialsAround(World world, BlockPos pos) {
        ArrayList<Material> blocks = new ArrayList<Material>();
        blocks.add(world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH)).func_185904_a());
        blocks.add(world.func_180495_p(pos.func_177972_a(EnumFacing.EAST)).func_185904_a());
        blocks.add(world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH)).func_185904_a());
        blocks.add(world.func_180495_p(pos.func_177972_a(EnumFacing.WEST)).func_185904_a());
        return blocks;
    }

    public static boolean addToInventory(IInventory inventory, List<ItemStack> stacks, boolean actuallyDo, boolean shouldAlwaysWork) {
        return WorldUtil.addToInventory(inventory, stacks, EnumFacing.UP, actuallyDo, shouldAlwaysWork);
    }

    public static boolean addToInventory(IInventory inventory, List<ItemStack> stacks, EnumFacing side, boolean actuallyDo, boolean shouldAlwaysWork) {
        return WorldUtil.addToInventory(inventory, 0, inventory.func_70302_i_(), stacks, side, actuallyDo, shouldAlwaysWork);
    }

    public static boolean addToInventory(IInventory inventory, int start, int end, List<ItemStack> stacks, EnumFacing side, boolean actuallyDo, boolean shouldAlwaysWork) {
        ItemStack[] backupSlots = null;
        if (!actuallyDo) {
            backupSlots = new ItemStack[inventory.func_70302_i_()];
            for (int i = 0; i < backupSlots.length; ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack == null) continue;
                backupSlots[i] = stack.func_77946_l();
            }
        }
        int working = 0;
        block1: for (ItemStack stackToPutIn : stacks) {
            for (int i = start; i < end; ++i) {
                if (!shouldAlwaysWork && (inventory instanceof ISidedInventory && !((ISidedInventory)inventory).func_180462_a(i, stackToPutIn, side) || !inventory.func_94041_b(i, stackToPutIn))) continue;
                ItemStack stackInQuestion = inventory.func_70301_a(i);
                if (stackToPutIn == null || stackInQuestion != null && (!ItemUtil.canBeStacked(stackInQuestion, stackToPutIn) || stackInQuestion.func_77976_d() < stackInQuestion.field_77994_a + stackToPutIn.field_77994_a)) continue;
                if (stackInQuestion == null) {
                    inventory.func_70299_a(i, stackToPutIn.func_77946_l());
                } else {
                    stackInQuestion.field_77994_a += stackToPutIn.field_77994_a;
                }
                ++working;
                continue block1;
            }
        }
        if (!actuallyDo) {
            for (int i = 0; i < backupSlots.length; ++i) {
                inventory.func_70299_a(i, backupSlots[i]);
            }
        }
        return working >= stacks.size();
    }

    public static int findFirstFilledSlot(ItemStack[] slots) {
        for (int i = 0; i < slots.length; ++i) {
            if (slots[i] == null) continue;
            return i;
        }
        return 0;
    }

    public static RayTraceResult getNearestPositionWithAir(World world, EntityPlayer player, int reach) {
        return WorldUtil.getMovingObjectPosWithReachDistance(world, player, reach, false, false, true);
    }

    private static RayTraceResult getMovingObjectPosWithReachDistance(World world, EntityPlayer player, double distance, boolean p1, boolean p2, boolean p3) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        double d0 = player.field_70165_t;
        double d1 = player.field_70163_u + (double)player.func_70047_e();
        double d2 = player.field_70161_v;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3d vec31 = vec3.func_72441_c((double)f6 * distance, (double)f5 * distance, (double)f7 * distance);
        return world.func_147447_a(vec3, vec31, p1, p2, p3);
    }

    public static RayTraceResult getNearestBlockWithDefaultReachDistance(World world, EntityPlayer player) {
        return WorldUtil.getNearestBlockWithDefaultReachDistance(world, player, false, true, false);
    }

    public static RayTraceResult getNearestBlockWithDefaultReachDistance(World world, EntityPlayer player, boolean stopOnLiquids, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        return WorldUtil.getMovingObjectPosWithReachDistance(world, player, player instanceof EntityPlayerMP ? ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() : 5.0, stopOnLiquids, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock);
    }

    public static boolean playerHarvestBlock(ItemStack stack, World world, EntityPlayer player, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!world.field_72995_K) {
            world.func_180498_a(player, 2001, pos, Block.func_176210_f((IBlockState)state));
        } else {
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_176208_a(world, pos, state, player);
            if (block.removedByPlayer(state, world, pos, player, false)) {
                block.func_176206_d(world, pos, state);
            }
            if (!world.field_72995_K && player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            }
            return true;
        }
        stack.func_179548_a(world, state, pos, player);
        if (!world.field_72995_K) {
            if (player instanceof EntityPlayerMP) {
                EntityPlayerMP playerMp = (EntityPlayerMP)player;
                int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMp.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMp, (BlockPos)pos);
                if (xp == -1) {
                    return false;
                }
                TileEntity tileEntity = world.func_175625_s(pos);
                if (block.removedByPlayer(state, world, pos, player, true)) {
                    block.func_176206_d(world, pos, state);
                    block.func_180657_a(world, player, pos, state, tileEntity, stack);
                    block.func_180637_b(world, pos, xp);
                }
                playerMp.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
                return true;
            }
        } else {
            if (block.removedByPlayer(state, world, pos, player, true)) {
                block.func_176206_d(world, pos, state);
            }
            if (stack.field_77994_a <= 0 && stack == player.func_184614_ca()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)EnumHand.MAIN_HAND);
                player.func_184611_a(EnumHand.MAIN_HAND, null);
            }
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, mc.field_71476_x.field_178784_b));
            return true;
        }
        return false;
    }
}

