/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.CrusherRecipe;
import de.ellpeck.actuallyadditions.api.recipe.EmpowererRecipe;
import de.ellpeck.actuallyadditions.api.recipe.LensConversionRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;

public final class RecipeUtil {
    public static LensConversionRecipe lastReconstructorRecipe() {
        List<LensConversionRecipe> list = ActuallyAdditionsAPI.RECONSTRUCTOR_LENS_CONVERSION_RECIPES;
        return list.get(list.size() - 1);
    }

    public static CrusherRecipe lastCrusherRecipe() {
        List<CrusherRecipe> list = ActuallyAdditionsAPI.CRUSHER_RECIPES;
        return list.get(list.size() - 1);
    }

    public static IRecipe lastIRecipe() {
        List list = CraftingManager.func_77594_a().func_77592_b();
        Object recipe = list.get(list.size() - 1);
        return recipe instanceof IRecipe ? (IRecipe)recipe : null;
    }

    public static EmpowererRecipe lastEmpowererRecipe() {
        List<EmpowererRecipe> list = ActuallyAdditionsAPI.EMPOWERER_RECIPES;
        return list.get(list.size() - 1);
    }

    public static List<ItemStack> getCrusherRecipeOutputOnes(CrusherRecipe recipe) {
        return RecipeUtil.doRecipeOrWhatever(recipe.outputOneStack, recipe.outputOne, recipe.outputOneAmount);
    }

    public static List<ItemStack> getCrusherRecipeOutputTwos(CrusherRecipe recipe) {
        return RecipeUtil.doRecipeOrWhatever(recipe.outputTwoStack, recipe.outputTwo, recipe.outputTwoAmount);
    }

    public static List<ItemStack> getCrusherRecipeInputs(CrusherRecipe recipe) {
        return RecipeUtil.doRecipeOrWhatever(recipe.inputStack, recipe.input, 1);
    }

    public static List<ItemStack> getConversionLensInputs(LensConversionRecipe recipe) {
        return RecipeUtil.doRecipeOrWhatever(recipe.inputStack, recipe.input, 1);
    }

    public static List<ItemStack> getConversionLensOutputs(LensConversionRecipe recipe) {
        return RecipeUtil.doRecipeOrWhatever(recipe.outputStack, recipe.output, 1);
    }

    private static List<ItemStack> doRecipeOrWhatever(ItemStack stack, String oredict, int amount) {
        if (stack != null) {
            return Collections.singletonList(stack.func_77946_l());
        }
        if (oredict == null || oredict.isEmpty()) {
            return null;
        }
        List stacks = OreDictionary.getOres((String)oredict, (boolean)false);
        if (stacks != null && !stacks.isEmpty()) {
            ArrayList<ItemStack> stacksCopy = new ArrayList<ItemStack>();
            for (ItemStack aStack : stacks) {
                if (aStack == null) continue;
                ItemStack stackCopy = aStack.func_77946_l();
                stackCopy.field_77994_a = amount;
                stacksCopy.add(stackCopy);
            }
            return stacksCopy;
        }
        return null;
    }
}

