/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util;

import de.ellpeck.actuallyadditions.mod.misc.ParticleColored;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketServerToClient;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public final class AssetUtil {
    public static final ResourceLocation GUI_INVENTORY_LOCATION = AssetUtil.getGuiLocation("guiInventory");

    public static ResourceLocation getGuiLocation(String file) {
        return new ResourceLocation("actuallyadditions", "textures/gui/" + file + ".png");
    }

    public static ResourceLocation getBookletGuiLocation(String file) {
        return new ResourceLocation("actuallyadditions", "textures/gui/booklet/" + file + ".png");
    }

    @SideOnly(value=Side.CLIENT)
    public static void displayNameString(FontRenderer font, int xSize, int yPositionOfMachineText, String text) {
        font.func_78276_b(text, xSize / 2 - font.func_78256_a(text) / 2, yPositionOfMachineText, 0xFFFFFF);
    }

    @SideOnly(value=Side.CLIENT)
    public static void displayNameString(FontRenderer font, int xSize, int yPositionOfMachineText, TileEntity tile) {
        AssetUtil.displayNameString(font, xSize, yPositionOfMachineText, tile.func_145748_c_().func_150254_d());
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderBlockInWorld(Block block, int meta) {
        AssetUtil.renderItemInWorld(new ItemStack(block, 1, meta));
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderItemInWorld(ItemStack stack) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179123_a();
        RenderHelper.func_74519_b();
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
        RenderHelper.func_74518_a();
        GlStateManager.func_179099_b();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderStackToGui(ItemStack stack, int x, int y, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        RenderHelper.func_74520_c();
        GlStateManager.func_179126_j();
        GlStateManager.func_179091_B();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        Minecraft mc = Minecraft.func_71410_x();
        boolean flagBefore = mc.field_71466_p.func_82883_a();
        mc.field_71466_p.func_78264_a(false);
        Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, 0, 0);
        Minecraft.func_71410_x().func_175599_af().func_180453_a(mc.field_71466_p, stack, 0, 0, null);
        mc.field_71466_p.func_78264_a(flagBefore);
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawHorizontalGradientRect(int left, int top, int right, int bottom, int startColor, int endColor, float zLevel) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        renderer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        renderer.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        renderer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderNameTag(String tag, double x, double y, double z) {
        FontRenderer fontrenderer = Minecraft.func_71410_x().field_71466_p;
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)Minecraft.func_71410_x().func_175598_ae().field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-f1), (float)(-f1), (float)f1);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer renderer = tessellator.func_178180_c();
        int i = 0;
        int j = fontrenderer.func_78256_a(tag) / 2;
        GlStateManager.func_179090_x();
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b((double)(-j - 1), (double)(-1 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        renderer.func_181662_b((double)(-j - 1), (double)(8 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        renderer.func_181662_b((double)(j + 1), (double)(8 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        renderer.func_181662_b((double)(j + 1), (double)(-1 + i), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        fontrenderer.func_78276_b(tag, -fontrenderer.func_78256_a(tag) / 2, i, 0x20FFFFFF);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        fontrenderer.func_78276_b(tag, -fontrenderer.func_78256_a(tag) / 2, i, -1);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void shootParticles(World world, double startX, double startY, double startZ, double endX, double endY, double endZ, float[] color, int particleAmount, float particleSize, float ageMultiplier) {
        if (!world.field_72995_K) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74780_a("StartX", startX);
            data.func_74780_a("StartY", startY);
            data.func_74780_a("StartZ", startZ);
            data.func_74780_a("EndX", endX);
            data.func_74780_a("EndY", endY);
            data.func_74780_a("EndZ", endZ);
            data.func_74776_a("Color1", color[0]);
            data.func_74776_a("Color2", color[1]);
            data.func_74776_a("Color3", color[2]);
            data.func_74768_a("ParticleAmount", particleAmount);
            data.func_74776_a("ParticleSize", particleSize);
            data.func_74776_a("AgeMultiplier", ageMultiplier);
            PacketHandler.theNetwork.sendToAllAround((IMessage)new PacketServerToClient(data, PacketHandler.PARTICLE_HANDLER), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), startX, startY, startZ, 96.0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderParticlesFromAToB(double startX, double startY, double startZ, double endX, double endY, double endZ, int particleAmount, float particleSize, float[] color, float ageMultiplier) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (Minecraft.func_71410_x().field_71439_g.func_70011_f(startX, startY, startZ) <= 64.0 || Minecraft.func_71410_x().field_71439_g.func_70011_f(endX, endY, endZ) <= 64.0) {
            double difX = startX - endX;
            double difY = startY - endY;
            double difZ = startZ - endZ;
            double distance = new Vec3d(startX, startY, startZ).func_72438_d(new Vec3d(endX, endY, endZ));
            for (int times = 0; times < Math.max(particleAmount / 2, 1); ++times) {
                for (double i = 0.0; i <= 1.0; i += 1.0 / (distance * (double)particleAmount)) {
                    ParticleColored fx = new ParticleColored((World)world, difX * i + endX + 0.5, difY * i + endY + 0.5, difZ * i + endZ + 0.5, particleSize, color[0], color[1], color[2], ageMultiplier);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
                }
            }
        }
    }
}

