/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import de.ellpeck.actuallyadditions.mod.fluids.InitFluids;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityOilGenerator
extends TileEntityBase
implements IEnergyProvider,
net.minecraftforge.fluids.IFluidHandler {
    public static final int ENERGY_PRODUCED = 76;
    private static final int BURN_TIME = 100;
    public final EnergyStorage storage = new EnergyStorage(50000);
    public final FluidTank tank = new FluidTank(2000){

        public boolean canDrain() {
            return false;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == InitFluids.fluidOil;
        }
    };
    public int currentBurnTime;
    private int lastEnergy;
    private int lastTank;
    private int lastBurnTime;

    public TileEntityOilGenerator() {
        super("oilGenerator");
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @SideOnly(value=Side.CLIENT)
    public int getTankScaled(int i) {
        return this.tank.getFluidAmount() * i / this.tank.getCapacity();
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurningScaled(int i) {
        return this.currentBurnTime * i / 100;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("BurnTime", this.currentBurnTime);
        }
        this.storage.writeToNBT(compound);
        this.tank.writeToNBT(compound);
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentBurnTime = compound.func_74762_e("BurnTime");
        }
        this.storage.readFromNBT(compound);
        this.tank.readFromNBT(compound);
        super.readSyncableNBT(compound, type);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            boolean flag;
            boolean bl = flag = this.currentBurnTime > 0;
            if (this.currentBurnTime > 0) {
                --this.currentBurnTime;
                this.storage.receiveEnergy(76, false);
            }
            int fuelUsed = 50;
            if (7600 <= this.storage.getMaxEnergyStored() - this.storage.getEnergyStored() && this.currentBurnTime <= 0 && this.tank.getFluidAmount() >= fuelUsed) {
                this.currentBurnTime = 100;
                this.tank.drainInternal(fuelUsed, true);
            }
            if (flag != this.currentBurnTime > 0) {
                this.func_70296_d();
            }
            if ((this.storage.getEnergyStored() != this.lastEnergy || this.tank.getFluidAmount() != this.lastTank || this.lastBurnTime != this.currentBurnTime) && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
                this.lastTank = this.tank.getFluidAmount();
                this.lastBurnTime = this.currentBurnTime;
            }
        }
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public IFluidHandler getFluidHandler(EnumFacing facing) {
        return facing != EnumFacing.DOWN ? this.tank : null;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        IFluidHandler handler = this.getFluidHandler(from);
        return handler == null ? 0 : handler.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        IFluidHandler handler = this.getFluidHandler(from);
        return handler == null ? null : handler.drain(resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        IFluidHandler handler = this.getFluidHandler(from);
        return handler == null ? null : handler.drain(maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        IFluidHandler handler = this.getFluidHandler(from);
        if (handler != null) {
            for (IFluidTankProperties prop : handler.getTankProperties()) {
                if (prop == null || !prop.canFillFluidType(new FluidStack(fluid, Integer.MAX_VALUE))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        IFluidHandler handler = this.getFluidHandler(from);
        if (handler != null) {
            for (IFluidTankProperties prop : handler.getTankProperties()) {
                if (prop == null || !prop.canDrainFluidType(new FluidStack(fluid, Integer.MAX_VALUE))) continue;
                return true;
            }
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        IFluidHandler handler = this.getFluidHandler(from);
        if (handler instanceof IFluidTank) {
            return new FluidTankInfo[]{((IFluidTank)handler).getInfo()};
        }
        return null;
    }
}

