/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileEntityLeafGenerator
extends TileEntityBase
implements IEnergyProvider,
IEnergyDisplay {
    public static final int RANGE = 7;
    public static final int ENERGY_PRODUCED = 300;
    public final EnergyStorage storage = new EnergyStorage(35000);
    private int nextUseCounter;
    private int oldEnergy;

    public TileEntityLeafGenerator() {
        super("leafGenerator");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isRedstonePowered) {
                if (this.nextUseCounter >= 5) {
                    this.nextUseCounter = 0;
                    if (300 <= this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) {
                        ArrayList<BlockPos> breakPositions = new ArrayList<BlockPos>();
                        for (int reachX = -7; reachX < 8; ++reachX) {
                            for (int reachZ = -7; reachZ < 8; ++reachZ) {
                                for (int reachY = -7; reachY < 8; ++reachY) {
                                    BlockPos pos = this.field_174879_c.func_177982_a(reachX, reachY, reachZ);
                                    Block block = this.field_145850_b.func_180495_p(pos).func_177230_c();
                                    if (block == null || !block.isLeaves(this.field_145850_b.func_180495_p(pos), (IBlockAccess)this.field_145850_b, pos)) continue;
                                    breakPositions.add(pos);
                                }
                            }
                        }
                        if (!breakPositions.isEmpty()) {
                            Collections.shuffle(breakPositions);
                            BlockPos theCoord = (BlockPos)breakPositions.get(0);
                            if (!ConfigBoolValues.LESS_BLOCK_BREAKING_EFFECTS.isEnabled()) {
                                this.field_145850_b.func_175718_b(2001, theCoord, Block.func_176210_f((IBlockState)this.field_145850_b.func_180495_p(theCoord)));
                            }
                            this.field_145850_b.func_175698_g(theCoord);
                            this.storage.receiveEnergy(300, false);
                            if (!ConfigBoolValues.LESS_PARTICLES.isEnabled()) {
                                AssetUtil.shootParticles(this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), theCoord.func_177958_n(), theCoord.func_177956_o(), theCoord.func_177952_p(), new float[]{0.24313726f, 0.6392157f, 0.2901961f}, 5, 1.0f, 1.0f);
                            }
                        }
                    }
                } else {
                    ++this.nextUseCounter;
                }
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.storage.extractEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }
}

