/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.laser.ConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityItemViewer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityLaserRelayItem
extends TileEntityLaserRelay {
    public final Map<BlockPos, IItemHandler> handlersAround = new ConcurrentHashMap<BlockPos, IItemHandler>();

    public TileEntityLaserRelayItem(String name) {
        super(name, true);
    }

    public TileEntityLaserRelayItem() {
        this("laserRelayItem");
    }

    public boolean isWhitelisted(ItemStack stack, boolean output) {
        return true;
    }

    @Override
    public void saveAllHandlersAround() {
        this.handlersAround.clear();
        for (int i = 0; i <= 5; ++i) {
            IItemHandler handler;
            EnumFacing side = WorldUtil.getDirectionBySidesInOrder(i);
            BlockPos pos = this.func_174877_v().func_177972_a(side);
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            if (tile == null || tile instanceof TileEntityItemViewer || tile instanceof TileEntityLaserRelay || (handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d())) == null) continue;
            this.handlersAround.put(tile.func_174877_v(), handler);
        }
    }

    public List<TileEntityItemViewer.GenericItemHandlerInfo> getItemHandlersInNetwork(Network network) {
        ArrayList<BlockPos> alreadyChecked = new ArrayList<BlockPos>();
        ArrayList<TileEntityItemViewer.GenericItemHandlerInfo> handlers = new ArrayList<TileEntityItemViewer.GenericItemHandlerInfo>();
        for (ConnectionPair pair : network.connections) {
            for (BlockPos relay : pair.positions) {
                if (relay == null || alreadyChecked.contains(relay)) continue;
                alreadyChecked.add(relay);
                TileEntity aRelayTile = this.field_145850_b.func_175625_s(relay);
                if (!(aRelayTile instanceof TileEntityLaserRelayItem)) continue;
                TileEntityLaserRelayItem relayTile = (TileEntityLaserRelayItem)aRelayTile;
                TileEntityItemViewer.GenericItemHandlerInfo info = new TileEntityItemViewer.GenericItemHandlerInfo(relayTile);
                Map<BlockPos, IItemHandler> handlersAroundTile = relayTile.handlersAround;
                for (Map.Entry<BlockPos, IItemHandler> handler : handlersAroundTile.entrySet()) {
                    if (alreadyChecked.contains(handler.getKey())) continue;
                    alreadyChecked.add(handler.getKey());
                    info.handlers.add(handler.getValue());
                }
                handlers.add(info);
            }
        }
        return handlers;
    }
}

