/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.IEnergyReceiver;
import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.laser.ConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.util.compat.TeslaUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileEntityLaserRelayEnergy
extends TileEntityLaserRelay
implements IEnergyReceiver {
    public final ConcurrentHashMap<EnumFacing, TileEntity> receiversAround = new ConcurrentHashMap();
    public static final int CAP = 1000;

    public TileEntityLaserRelayEnergy(String name) {
        super(name, false);
    }

    public TileEntityLaserRelayEnergy() {
        this("laserRelay");
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.transmitEnergy(from, maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.getEnergyCap();
    }

    public int transmitEnergy(EnumFacing from, int maxTransmit, boolean simulate) {
        Network network;
        int transmitted = 0;
        if (maxTransmit > 0 && (network = ActuallyAdditionsAPI.connectionHandler.getNetworkFor(this.field_174879_c, this.field_145850_b)) != null) {
            transmitted = this.transferEnergyToReceiverInNeed(from, network, maxTransmit, simulate);
        }
        return transmitted;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public void saveAllHandlersAround() {
        this.receiversAround.clear();
        for (EnumFacing side : EnumFacing.values()) {
            BlockPos pos = this.func_174877_v().func_177972_a(side);
            TileEntity tile = this.field_145850_b.func_175625_s(pos);
            if (tile == null || tile instanceof TileEntityLaserRelay || !(tile instanceof IEnergyReceiver) && (!ActuallyAdditions.teslaLoaded || !tile.hasCapability(TeslaUtil.teslaConsumer, side.func_176734_d()))) continue;
            this.receiversAround.put(side, tile);
        }
    }

    private int transferEnergyToReceiverInNeed(EnumFacing from, Network network, int maxTransfer, boolean simulate) {
        int transmitted = 0;
        ArrayList<BlockPos> alreadyChecked = new ArrayList<BlockPos>();
        for (ConnectionPair pair : network.connections) {
            for (BlockPos relay : pair.positions) {
                if (relay == null || alreadyChecked.contains(relay)) continue;
                alreadyChecked.add(relay);
                TileEntity relayTile = this.field_145850_b.func_175625_s(relay);
                if (!(relayTile instanceof TileEntityLaserRelayEnergy)) continue;
                TileEntityLaserRelayEnergy theRelay = (TileEntityLaserRelayEnergy)relayTile;
                double highestLoss = Math.max(theRelay.getLossPercentage(), this.getLossPercentage());
                int lowestCap = Math.min(theRelay.getEnergyCap(), this.getEnergyCap());
                for (Map.Entry<EnumFacing, TileEntity> receiver : theRelay.receiversAround.entrySet()) {
                    ITeslaConsumer cap;
                    int deduct;
                    int theoreticalReceived;
                    if (receiver == null) continue;
                    EnumFacing side = receiver.getKey();
                    EnumFacing opp = side.func_176734_d();
                    TileEntity tile = receiver.getValue();
                    if (alreadyChecked.contains(tile.func_174877_v())) continue;
                    alreadyChecked.add(tile.func_174877_v());
                    if (theRelay == this && side == from) continue;
                    if (tile instanceof IEnergyReceiver) {
                        IEnergyReceiver iReceiver = (IEnergyReceiver)tile;
                        if (iReceiver.canConnectEnergy(opp)) {
                            theoreticalReceived = iReceiver.receiveEnergy(opp, Math.min(maxTransfer, lowestCap) - transmitted, true);
                            deduct = this.calcDeduction(theoreticalReceived, highestLoss);
                            transmitted += iReceiver.receiveEnergy(opp, theoreticalReceived - deduct, simulate);
                            transmitted += deduct;
                        }
                    } else if (ActuallyAdditions.teslaLoaded && tile.hasCapability(TeslaUtil.teslaConsumer, opp) && (cap = (ITeslaConsumer)tile.getCapability(TeslaUtil.teslaConsumer, opp)) != null) {
                        theoreticalReceived = (int)cap.givePower((long)(Math.min(maxTransfer, lowestCap) - transmitted), true);
                        deduct = this.calcDeduction(theoreticalReceived, highestLoss);
                        transmitted = (int)((long)transmitted + cap.givePower((long)(theoreticalReceived - deduct), simulate));
                        transmitted += deduct;
                    }
                    if (transmitted < maxTransfer) continue;
                    return transmitted;
                }
            }
        }
        return transmitted;
    }

    private int calcDeduction(int theoreticalReceived, double highestLoss) {
        return ConfigBoolValues.LASER_RELAY_LOSS.isEnabled() ? (int)((double)theoreticalReceived * (highestLoss / 100.0)) : 0;
    }

    public int getEnergyCap() {
        return 1000;
    }

    public double getLossPercentage() {
        return 5.0;
    }
}

