/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.laser.ConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.items.ItemLaserWrench;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.Util;
import io.netty.util.internal.ConcurrentSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityLaserRelay
extends TileEntityBase {
    public static final int MAX_DISTANCE = 15;
    private static final float[] COLOR = new float[]{1.0f, 0.0f, 0.0f};
    private static final float[] COLOR_ITEM = new float[]{0.54509807f, 0.36862746f, 1.0f};
    public final boolean isItem;
    private Set<ConnectionPair> tempConnectionStorage;
    private boolean hasCheckedHandlersAround;

    public TileEntityLaserRelay(String name, boolean isItem) {
        super(name);
        this.isItem = isItem;
    }

    @Override
    public void receiveSyncCompound(NBTTagCompound compound) {
        ActuallyAdditionsAPI.connectionHandler.removeRelayFromNetwork(this.field_174879_c, this.field_145850_b);
        NBTTagList list = compound.func_150295_c("Connections", 10);
        if (!list.func_82582_d()) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ConnectionPair pair = ConnectionPair.readFromNBT(list.func_150305_b(i));
                ActuallyAdditionsAPI.connectionHandler.addConnection(pair.positions[0], pair.positions[1], this.field_145850_b, pair.suppressConnectionRender);
            }
        }
        super.receiveSyncCompound(compound);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        NBTTagList list = new NBTTagList();
        ConcurrentSet<ConnectionPair> connections = ActuallyAdditionsAPI.connectionHandler.getConnectionsFor(this.field_174879_c, this.field_145850_b);
        if (connections != null && !connections.isEmpty()) {
            for (ConnectionPair pair : connections) {
                list.func_74742_a((NBTBase)pair.writeToNBT());
            }
        }
        compound.func_74782_a("Connections", (NBTBase)list);
        return compound;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.field_145850_b.field_72995_K) {
            this.renderParticles();
        } else if (!this.hasCheckedHandlersAround) {
            this.saveAllHandlersAround();
            this.hasCheckedHandlersAround = true;
        }
    }

    public void saveAllHandlersAround() {
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticles() {
        EntityPlayerSP player;
        if (Util.RANDOM.nextInt(ConfigBoolValues.LESS_PARTICLES.isEnabled() ? 16 : 8) == 0 && (player = Minecraft.func_71410_x().field_71439_g) != null) {
            PlayerData.PlayerSave data = PlayerData.getDataFromPlayer((EntityPlayer)player);
            ItemLaserWrench.WrenchMode mode = ItemLaserWrench.WrenchMode.values()[data.theCompound.func_74762_e("LaserWrenchMode")];
            if (mode != ItemLaserWrench.WrenchMode.NO_PARTICLES) {
                Network network;
                ItemStack stack = player.func_184614_ca();
                if ((mode == ItemLaserWrench.WrenchMode.ALWAYS_PARTICLES || stack != null && stack.func_77973_b() instanceof ItemLaserWrench) && (network = ActuallyAdditionsAPI.connectionHandler.getNetworkFor(this.field_174879_c, this.field_145850_b)) != null) {
                    for (ConnectionPair aPair : network.connections) {
                        if (aPair.suppressConnectionRender || !aPair.contains(this.field_174879_c) || !this.field_174879_c.equals((Object)aPair.positions[0])) continue;
                        AssetUtil.renderParticlesFromAToB(aPair.positions[0].func_177958_n(), aPair.positions[0].func_177956_o(), aPair.positions[0].func_177952_p(), aPair.positions[1].func_177958_n(), aPair.positions[1].func_177956_o(), aPair.positions[1].func_177952_p(), ConfigBoolValues.LESS_PARTICLES.isEnabled() ? 1 : Util.RANDOM.nextInt(3) + 1, 0.8f, this.isItem ? COLOR_ITEM : COLOR, 1.0f);
                    }
                }
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.tempConnectionStorage = ActuallyAdditionsAPI.connectionHandler.getConnectionsFor(this.field_174879_c, this.field_145850_b);
        ActuallyAdditionsAPI.connectionHandler.removeRelayFromNetwork(this.field_174879_c, this.field_145850_b);
    }

    public void func_145829_t() {
        if (this.tempConnectionStorage != null) {
            for (ConnectionPair pair : this.tempConnectionStorage) {
                ActuallyAdditionsAPI.connectionHandler.addConnection(pair.positions[0], pair.positions[1], this.field_145850_b, pair.suppressConnectionRender);
            }
            this.tempConnectionStorage = null;
        }
        super.func_145829_t();
    }
}

