/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItem;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItemWhitelist;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;

public class TileEntityItemViewer
extends TileEntityInventoryBase {
    public TileEntityLaserRelayItem connectedRelay;
    private boolean hasCheckedRelayOnLoad;

    public TileEntityItemViewer() {
        super(0, "itemViewer");
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K && !this.hasCheckedRelayOnLoad) {
            this.saveConnectedRelay();
            this.hasCheckedRelayOnLoad = true;
        }
    }

    private List<GenericItemHandlerInfo> getItemHandlerInfos() {
        Network network;
        TileEntityLaserRelayItem relay = this.connectedRelay;
        if (relay != null && (network = ActuallyAdditionsAPI.connectionHandler.getNetworkFor(relay.func_174877_v(), this.field_145850_b)) != null) {
            return relay.getItemHandlersInNetwork(network);
        }
        return null;
    }

    private SpecificItemHandlerInfo getSwitchedIndexHandler(int i) {
        List<GenericItemHandlerInfo> infos = this.getItemHandlerInfos();
        if (infos != null && !infos.isEmpty()) {
            Collections.sort(infos);
            int currentI = 0;
            if (!infos.isEmpty()) {
                for (GenericItemHandlerInfo info : infos) {
                    for (IItemHandler handler : info.handlers) {
                        int slotAmount = handler.getSlots();
                        if (currentI + slotAmount > i) {
                            return new SpecificItemHandlerInfo(handler, i - currentI, info.relayInQuestion);
                        }
                        currentI += slotAmount;
                    }
                }
            }
        }
        return null;
    }

    public void saveConnectedRelay() {
        TileEntityLaserRelayItem tileFound = null;
        if (this.field_145850_b != null) {
            for (int i = 0; i <= 5; ++i) {
                EnumFacing side = WorldUtil.getDirectionBySidesInOrder(i);
                BlockPos pos = this.func_174877_v().func_177972_a(side);
                TileEntity tile = this.field_145850_b.func_175625_s(pos);
                if (!(tile instanceof TileEntityLaserRelayItem)) continue;
                if (tileFound != null) {
                    this.connectedRelay = null;
                    return;
                }
                tileFound = (TileEntityLaserRelayItem)tile;
            }
        }
        this.connectedRelay = tileFound;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        SpecificItemHandlerInfo handler = this.getSwitchedIndexHandler(index);
        if (handler != null && this.isWhitelisted(handler, stack, true) && ItemStack.func_179545_c((ItemStack)handler.handler.getStackInSlot(handler.switchedIndex), (ItemStack)stack)) {
            ItemStack gaveBack = handler.handler.extractItem(handler.switchedIndex, stack.field_77994_a, true);
            return gaveBack != null;
        }
        return false;
    }

    private boolean isWhitelisted(SpecificItemHandlerInfo handler, ItemStack stack, boolean output) {
        boolean whitelisted = handler.relayInQuestion.isWhitelisted(stack, output);
        TileEntityLaserRelayItem connected = this.connectedRelay;
        if (connected != null && connected != handler.relayInQuestion) {
            return whitelisted && connected.isWhitelisted(stack, !output);
        }
        return whitelisted;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        SpecificItemHandlerInfo handler = this.getSwitchedIndexHandler(index);
        if (handler != null && this.isWhitelisted(handler, stack, false)) {
            ItemStack gaveBack = handler.handler.insertItem(handler.switchedIndex, stack, true);
            return !ItemStack.func_77989_b((ItemStack)gaveBack, (ItemStack)stack);
        }
        return false;
    }

    @Override
    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70304_b(i);
        }
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        if (stack != null) {
            SpecificItemHandlerInfo handler = this.getSwitchedIndexHandler(i);
            if (handler != null) {
                ItemStack toInsert = stack.func_77946_l();
                ItemStack inSlot = handler.handler.getStackInSlot(handler.switchedIndex);
                if (inSlot != null) {
                    toInsert.field_77994_a -= inSlot.field_77994_a;
                }
                handler.handler.insertItem(handler.switchedIndex, toInsert, false);
            }
        } else {
            this.func_70304_b(i);
        }
    }

    @Override
    public int func_70302_i_() {
        int size = 0;
        List<GenericItemHandlerInfo> infos = this.getItemHandlerInfos();
        if (infos != null) {
            for (GenericItemHandlerInfo info : infos) {
                for (IItemHandler handler : info.handlers) {
                    size += handler.getSlots();
                }
            }
        }
        return size;
    }

    @Override
    public ItemStack func_70301_a(int i) {
        SpecificItemHandlerInfo handler = this.getSwitchedIndexHandler(i);
        if (handler != null) {
            return handler.handler.getStackInSlot(handler.switchedIndex);
        }
        return null;
    }

    @Override
    public ItemStack func_70298_a(int i, int j) {
        SpecificItemHandlerInfo handler = this.getSwitchedIndexHandler(i);
        if (handler != null) {
            return handler.handler.extractItem(handler.switchedIndex, j, false);
        }
        return null;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        SpecificItemHandlerInfo handler = this.getSwitchedIndexHandler(index);
        if (handler != null) {
            ItemStack stackInSlot = handler.handler.getStackInSlot(handler.switchedIndex);
            if (stackInSlot != null) {
                handler.handler.extractItem(handler.switchedIndex, stackInSlot.field_77994_a, false);
            }
            return stackInSlot;
        }
        return null;
    }

    public static class GenericItemHandlerInfo
    implements Comparable<GenericItemHandlerInfo> {
        public final List<IItemHandler> handlers = new ArrayList<IItemHandler>();
        public final TileEntityLaserRelayItem relayInQuestion;

        public GenericItemHandlerInfo(TileEntityLaserRelayItem relayInQuestion) {
            this.relayInQuestion = relayInQuestion;
        }

        @Override
        public int compareTo(GenericItemHandlerInfo other) {
            boolean thisWhitelist = this.relayInQuestion instanceof TileEntityLaserRelayItemWhitelist;
            boolean otherWhitelist = other.relayInQuestion instanceof TileEntityLaserRelayItemWhitelist;
            if (!thisWhitelist && otherWhitelist) {
                return 1;
            }
            if (thisWhitelist && !otherWhitelist) {
                return -1;
            }
            return 0;
        }
    }

    private static class SpecificItemHandlerInfo {
        public final IItemHandler handler;
        public final int switchedIndex;
        public final TileEntityLaserRelayItem relayInQuestion;

        public SpecificItemHandlerInfo(IItemHandler handler, int switchedIndex, TileEntityLaserRelayItem relayInQuestion) {
            this.handler = handler;
            this.switchedIndex = switchedIndex;
            this.relayInQuestion = relayInQuestion;
        }
    }
}

