/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.network.gui.INumberReactor;
import de.ellpeck.actuallyadditions.mod.tile.FilterSettings;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityInputter
extends TileEntityInventoryBase
implements IButtonReactor,
INumberReactor {
    public static final int PUT_FILTER_START = 13;
    public static final int PULL_FILTER_START = 1;
    public static final int OKAY_BUTTON_ID = 133;
    public int sideToPut = -1;
    public int slotToPutStart;
    public int slotToPutEnd;
    public TileEntity placeToPut;
    public int sideToPull = -1;
    public int slotToPullStart;
    public int slotToPullEnd;
    public TileEntity placeToPull;
    public boolean isAdvanced;
    private int lastPutSide;
    private int lastPutStart;
    private int lastPutEnd;
    private int lastPullSide;
    private int lastPullStart;
    private int lastPullEnd;
    public FilterSettings leftFilter = new FilterSettings(1, 13, true, true, false, 0, -1000);
    public FilterSettings rightFilter = new FilterSettings(13, 25, true, true, false, 0, -2000);
    private boolean hasCheckedTilesAround;

    public TileEntityInputter(int slots, String name) {
        super(slots, name);
    }

    public TileEntityInputter() {
        super(1, "inputter");
        this.isAdvanced = false;
    }

    @Override
    public void onNumberReceived(int text, int textID, EntityPlayer player) {
        if (text != -1) {
            if (textID == 0) {
                this.slotToPutStart = Math.max(text, 0);
            }
            if (textID == 1) {
                this.slotToPutEnd = Math.max(text, 0);
            }
            if (textID == 2) {
                this.slotToPullStart = Math.max(text, 0);
            }
            if (textID == 3) {
                this.slotToPullEnd = Math.max(text, 0);
            }
        }
        this.func_70296_d();
    }

    private boolean newPulling() {
        for (EnumFacing side : EnumFacing.values()) {
            IItemHandler cap;
            if (!this.placeToPull.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) || (cap = (IItemHandler)this.placeToPull.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) == null) continue;
            for (int i = Math.max(this.slotToPullStart, 0); i < Math.min(this.slotToPullEnd, cap.getSlots()); ++i) {
                if (!this.checkBothFilters(cap.getStackInSlot(i), false) || !WorldUtil.doItemInteraction(i, 0, this.placeToPull, this, side, null)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean newPutting() {
        if (this.checkBothFilters(this.slots[0], true)) {
            for (EnumFacing side : EnumFacing.values()) {
                IItemHandler cap;
                if (!this.placeToPut.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) || (cap = (IItemHandler)this.placeToPut.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) == null) continue;
                for (int i = Math.max(this.slotToPutStart, 0); i < Math.min(this.slotToPutEnd, cap.getSlots()); ++i) {
                    if (!WorldUtil.doItemInteraction(0, i, this, this.placeToPut, null, side)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void pull() {
        if (this.newPulling() || !(this.placeToPull instanceof IInventory)) {
            return;
        }
        IInventory theInventory = (IInventory)this.placeToPull;
        if (theInventory.func_70302_i_() > 0) {
            int theSlotToPull = this.slotToPullStart;
            int maxSize = theInventory.func_70297_j_();
            ISidedInventory theSided = null;
            if (theInventory instanceof ISidedInventory) {
                theSided = (ISidedInventory)theInventory;
            }
            boolean can = false;
            ItemStack theStack = null;
            for (int i = Math.max(theSlotToPull, 0); i < Math.min(this.slotToPullEnd, theInventory.func_70302_i_()); ++i) {
                ItemStack tempStack = theInventory.func_70301_a(i);
                if (tempStack != null) {
                    maxSize = tempStack.func_77976_d() < this.func_70297_j_() ? tempStack.func_77976_d() : this.func_70297_j_();
                }
                if (tempStack != null && (this.slots[0] == null || ItemUtil.canBeStacked(tempStack, this.slots[0]) && this.slots[0].field_77994_a < maxSize) && this.checkBothFilters(tempStack, false)) {
                    if (theSided != null) {
                        for (int j = 0; j <= 5; ++j) {
                            if (!theSided.func_180461_b(i, tempStack, EnumFacing.values()[j])) continue;
                            theStack = tempStack;
                            theSlotToPull = i;
                            can = true;
                            break;
                        }
                    } else {
                        theStack = tempStack;
                        theSlotToPull = i;
                        can = true;
                    }
                }
                if (can) break;
            }
            if (can) {
                if (this.slots[0] != null) {
                    if (ItemUtil.canBeStacked(theStack, this.slots[0])) {
                        if (theStack.field_77994_a <= maxSize - this.slots[0].field_77994_a) {
                            this.slots[0].field_77994_a += theStack.field_77994_a;
                            theInventory.func_70299_a(theSlotToPull, null);
                        } else if (theStack.field_77994_a > maxSize - this.slots[0].field_77994_a) {
                            theInventory.func_70298_a(theSlotToPull, maxSize - this.slots[0].field_77994_a);
                            this.slots[0].field_77994_a = maxSize;
                        }
                    }
                } else {
                    ItemStack toBePut = theStack.func_77946_l();
                    if (maxSize < toBePut.field_77994_a) {
                        toBePut.field_77994_a = maxSize;
                    }
                    this.func_70299_a(0, toBePut);
                    if (theStack.field_77994_a == toBePut.field_77994_a) {
                        theInventory.func_70299_a(theSlotToPull, null);
                    } else {
                        theInventory.func_70298_a(theSlotToPull, toBePut.field_77994_a);
                    }
                }
            }
        }
    }

    private void put() {
        if (this.newPutting() || !(this.placeToPut instanceof IInventory)) {
            return;
        }
        IInventory theInventory = (IInventory)this.placeToPut;
        if (theInventory.func_70302_i_() > 0) {
            int theSlotToPut = this.slotToPutStart;
            int maxSize = theInventory.func_70297_j_();
            ISidedInventory theSided = null;
            if (theInventory instanceof ISidedInventory) {
                theSided = (ISidedInventory)theInventory;
            }
            boolean can = false;
            if (this.slots[0] != null) {
                ItemStack theStack = null;
                for (int i = Math.max(theSlotToPut, 0); i < Math.min(this.slotToPutEnd, theInventory.func_70302_i_()); ++i) {
                    ItemStack tempStack = theInventory.func_70301_a(i);
                    if (tempStack != null) {
                        maxSize = tempStack.func_77976_d() < theInventory.func_70297_j_() ? tempStack.func_77976_d() : theInventory.func_70297_j_();
                    }
                    if (theInventory.func_94041_b(i, this.slots[0]) && (tempStack == null || ItemUtil.canBeStacked(tempStack, this.slots[0]) && tempStack.field_77994_a < maxSize) && this.checkBothFilters(this.slots[0], true)) {
                        if (theSided != null) {
                            for (int j = 0; j <= 5; ++j) {
                                if (!theSided.func_180462_a(i, this.slots[0], EnumFacing.values()[j])) continue;
                                theStack = tempStack;
                                theSlotToPut = i;
                                can = true;
                                break;
                            }
                        } else {
                            theStack = tempStack;
                            theSlotToPut = i;
                            can = true;
                        }
                    }
                    if (can) break;
                }
                if (can) {
                    if (theStack != null) {
                        ItemStack copiedStack = theStack.func_77946_l();
                        if (ItemUtil.canBeStacked(copiedStack, this.slots[0])) {
                            if (this.slots[0].field_77994_a <= maxSize - copiedStack.field_77994_a) {
                                copiedStack.field_77994_a += this.slots[0].field_77994_a;
                                this.slots[0] = null;
                                theInventory.func_70299_a(theSlotToPut, copiedStack);
                            } else if (this.slots[0].field_77994_a > maxSize - copiedStack.field_77994_a) {
                                this.func_70298_a(0, maxSize - copiedStack.field_77994_a);
                                copiedStack.field_77994_a = maxSize;
                                theInventory.func_70299_a(theSlotToPut, copiedStack);
                            }
                        }
                    } else {
                        ItemStack toBePut = this.slots[0].func_77946_l();
                        if (maxSize < toBePut.field_77994_a) {
                            toBePut.field_77994_a = maxSize;
                        }
                        theInventory.func_70299_a(theSlotToPut, toBePut);
                        if (this.slots[0].field_77994_a == toBePut.field_77994_a) {
                            this.slots[0] = null;
                        } else {
                            this.func_70298_a(0, toBePut.field_77994_a);
                        }
                    }
                }
            }
        }
    }

    private boolean checkBothFilters(ItemStack stack, boolean output) {
        return !this.isAdvanced || (output ? this.rightFilter : this.leftFilter).check(stack, this.slots);
    }

    public void initVars() {
        IItemHandler cap;
        EnumFacing side;
        if (this.sideToPull != -1) {
            side = WorldUtil.getDirectionBySidesInOrder(this.sideToPull);
            this.placeToPull = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
            if (this.slotToPullEnd <= 0 && this.placeToPull != null) {
                if (this.placeToPull instanceof IInventory) {
                    this.slotToPullEnd = ((IInventory)this.placeToPull).func_70302_i_();
                } else if (this.placeToPull.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (cap = (IItemHandler)this.placeToPull.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                    this.slotToPullEnd = cap.getSlots();
                }
            }
        }
        if (this.sideToPut != -1) {
            side = WorldUtil.getDirectionBySidesInOrder(this.sideToPut);
            this.placeToPut = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
            if (this.slotToPutEnd <= 0 && this.placeToPut != null) {
                if (this.placeToPut instanceof IInventory) {
                    this.slotToPutEnd = ((IInventory)this.placeToPut).func_70302_i_();
                } else if (this.placeToPut.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && (cap = (IItemHandler)this.placeToPut.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                    this.slotToPutEnd = cap.getSlots();
                }
            }
        }
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        this.leftFilter.onButtonPressed(buttonID);
        this.rightFilter.onButtonPressed(buttonID);
        if (buttonID == 0 || buttonID == 1) {
            this.slotToPutStart = 0;
            this.slotToPutEnd = 0;
        }
        if (buttonID == 2 || buttonID == 3) {
            this.slotToPullStart = 0;
            this.slotToPullEnd = 0;
        }
        if (buttonID == 0) {
            ++this.sideToPut;
        }
        if (buttonID == 1) {
            --this.sideToPut;
        }
        if (buttonID == 2) {
            ++this.sideToPull;
        }
        if (buttonID == 3) {
            --this.sideToPull;
        }
        if (this.sideToPut >= 6) {
            this.sideToPut = -1;
        } else if (this.sideToPut < -1) {
            this.sideToPut = 5;
        } else if (this.sideToPull >= 6) {
            this.sideToPull = -1;
        } else if (this.sideToPull < -1) {
            this.sideToPull = 5;
        }
        this.func_70296_d();
        this.initVars();
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("SideToPut", this.sideToPut);
            compound.func_74768_a("SlotToPut", this.slotToPutStart);
            compound.func_74768_a("SlotToPutEnd", this.slotToPutEnd);
            compound.func_74768_a("SideToPull", this.sideToPull);
            compound.func_74768_a("SlotToPull", this.slotToPullStart);
            compound.func_74768_a("SlotToPullEnd", this.slotToPullEnd);
            this.leftFilter.writeToNBT(compound, "LeftFilter");
            this.rightFilter.writeToNBT(compound, "RightFilter");
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.sideToPut = compound.func_74762_e("SideToPut");
            this.slotToPutStart = compound.func_74762_e("SlotToPut");
            this.slotToPutEnd = compound.func_74762_e("SlotToPutEnd");
            this.sideToPull = compound.func_74762_e("SideToPull");
            this.slotToPullStart = compound.func_74762_e("SlotToPull");
            this.slotToPullEnd = compound.func_74762_e("SlotToPullEnd");
            this.leftFilter.readFromNBT(compound, "LeftFilter");
            this.rightFilter.readFromNBT(compound, "RightFilter");
        }
        super.readSyncableNBT(compound, type);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.hasCheckedTilesAround) {
                this.initVars();
                this.hasCheckedTilesAround = true;
            }
            if (!(this.isRedstonePowered || this.sideToPull == this.sideToPut && this.slotToPullStart == this.slotToPutStart && this.slotToPullEnd == this.slotToPutEnd)) {
                if (this.sideToPull != -1 && this.placeToPull != null) {
                    this.pull();
                }
                if (this.slots[0] != null && this.sideToPut != -1 && this.placeToPut != null) {
                    this.put();
                }
            }
            if ((this.sideToPut != this.lastPutSide || this.sideToPull != this.lastPullSide || this.slotToPullStart != this.lastPullStart || this.slotToPullEnd != this.lastPullEnd || this.slotToPutStart != this.lastPutStart || this.slotToPutEnd != this.lastPutEnd || this.leftFilter.needsUpdateSend() || this.rightFilter.needsUpdateSend()) && this.sendUpdateWithInterval()) {
                this.lastPutSide = this.sideToPut;
                this.lastPullSide = this.sideToPull;
                this.lastPullStart = this.slotToPullStart;
                this.lastPullEnd = this.slotToPullEnd;
                this.lastPutStart = this.slotToPutStart;
                this.lastPutEnd = this.slotToPutEnd;
                this.leftFilter.updateLasts();
                this.rightFilter.updateLasts();
            }
        }
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return i == 0;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == 0;
    }
}

