/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.Util;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TileEntityHeatCollector
extends TileEntityBase
implements IEnergyProvider,
IEnergyDisplay {
    public static final int ENERGY_PRODUCE = 40;
    public static final int BLOCKS_NEEDED = 4;
    public final EnergyStorage storage = new EnergyStorage(30000);
    private int oldEnergy;

    public TileEntityHeatCollector() {
        super("heatCollector");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            ArrayList<Integer> blocksAround = new ArrayList<Integer>();
            if (40 <= this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) {
                for (int i = 1; i <= 5; ++i) {
                    BlockPos coords = this.field_174879_c.func_177972_a(WorldUtil.getDirectionBySidesInOrder(i));
                    IBlockState state = this.field_145850_b.func_180495_p(coords);
                    Block block = state.func_177230_c();
                    if (block == null || block.func_149688_o(this.field_145850_b.func_180495_p(coords)) != Material.field_151587_i || block.func_176201_c(state) != 0) continue;
                    blocksAround.add(i);
                }
                if (blocksAround.size() >= 4) {
                    this.storage.receiveEnergy(40, false);
                    this.func_70296_d();
                    if (Util.RANDOM.nextInt(10000) == 0) {
                        int randomSide = (Integer)blocksAround.get(Util.RANDOM.nextInt(blocksAround.size()));
                        this.field_145850_b.func_175698_g(this.field_174879_c.func_177972_a(WorldUtil.getDirectionBySidesInOrder(randomSide)));
                    }
                }
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return from == EnumFacing.UP;
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }
}

