/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.misc.SoundHandler;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.recipe.CrusherRecipeRegistry;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFurnaceDouble;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityGrinder
extends TileEntityInventoryBase
implements IEnergyReceiver,
IButtonReactor {
    public static final int SLOT_INPUT_1 = 0;
    public static final int SLOT_OUTPUT_1_1 = 1;
    public static final int SLOT_OUTPUT_1_2 = 2;
    public static final int SLOT_INPUT_2 = 3;
    public static final int SLOT_OUTPUT_2_1 = 4;
    public static final int SLOT_OUTPUT_2_2 = 5;
    public static final int ENERGY_USE = 40;
    public final EnergyStorage storage = new EnergyStorage(60000);
    public int firstCrushTime;
    public int secondCrushTime;
    public boolean isDouble;
    private int lastEnergy;
    private int lastFirstCrush;
    private int lastSecondCrush;
    public boolean isAutoSplit;
    private boolean lastAutoSplit;

    public TileEntityGrinder(int slots, String name) {
        super(slots, name);
    }

    public TileEntityGrinder() {
        super(3, "grinder");
        this.isDouble = false;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("FirstCrushTime", this.firstCrushTime);
            compound.func_74768_a("SecondCrushTime", this.secondCrushTime);
            compound.func_74757_a("IsAutoSplit", this.isAutoSplit);
        }
        this.storage.writeToNBT(compound);
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.firstCrushTime = compound.func_74762_e("FirstCrushTime");
            this.secondCrushTime = compound.func_74762_e("SecondCrushTime");
            this.isAutoSplit = compound.func_74767_n("IsAutoSplit");
        }
        this.storage.readFromNBT(compound);
        super.readSyncableNBT(compound, type);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (this.isDouble && this.isAutoSplit) {
                TileEntityFurnaceDouble.autoSplit(this.slots, 0, 3);
            }
            boolean flag = this.firstCrushTime > 0 || this.secondCrushTime > 0;
            boolean canCrushOnFirst = this.canCrushOn(0, 1, 2);
            boolean canCrushOnSecond = false;
            if (this.isDouble) {
                canCrushOnSecond = this.canCrushOn(3, 4, 5);
            }
            boolean shouldPlaySound = false;
            if (canCrushOnFirst) {
                if (this.storage.getEnergyStored() >= 40) {
                    if (this.firstCrushTime % 30 == 0) {
                        shouldPlaySound = true;
                    }
                    ++this.firstCrushTime;
                    if (this.firstCrushTime >= this.getMaxCrushTime()) {
                        this.finishCrushing(0, 1, 2);
                        this.firstCrushTime = 0;
                    }
                    this.storage.extractEnergy(40, false);
                }
            } else {
                this.firstCrushTime = 0;
            }
            if (this.isDouble) {
                if (canCrushOnSecond) {
                    if (this.storage.getEnergyStored() >= 40) {
                        if (this.secondCrushTime % 30 == 0) {
                            shouldPlaySound = true;
                        }
                        ++this.secondCrushTime;
                        if (this.secondCrushTime >= this.getMaxCrushTime()) {
                            this.finishCrushing(3, 4, 5);
                            this.secondCrushTime = 0;
                        }
                        this.storage.extractEnergy(40, false);
                    }
                } else {
                    this.secondCrushTime = 0;
                }
            }
            if (flag != (this.firstCrushTime > 0 || this.secondCrushTime > 0)) {
                this.func_70296_d();
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                Block block = state.func_177230_c();
                int meta = block.func_176201_c(state);
                if (meta == 1) {
                    if (!(this.canCrushOn(0, 1, 2) || this.isDouble && this.canCrushOn(3, 4, 5))) {
                        this.field_145850_b.func_180501_a(this.field_174879_c, block.func_176203_a(0), 2);
                    }
                } else {
                    this.field_145850_b.func_180501_a(this.field_174879_c, block.func_176203_a(1), 2);
                }
            }
            if ((this.lastEnergy != this.storage.getEnergyStored() || this.lastFirstCrush != this.firstCrushTime || this.lastSecondCrush != this.secondCrushTime || this.isAutoSplit != this.lastAutoSplit) && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
                this.lastFirstCrush = this.firstCrushTime;
                this.lastSecondCrush = this.secondCrushTime;
                this.lastAutoSplit = this.isAutoSplit;
            }
            if (shouldPlaySound && !ConfigBoolValues.LESS_SOUND.isEnabled()) {
                this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundHandler.crusher, SoundCategory.BLOCKS, 0.15f, 1.0f);
            }
        }
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return (i == 0 || i == 3) && CrusherRecipeRegistry.getRecipeFromInput(stack) != null;
    }

    public boolean canCrushOn(int theInput, int theFirstOutput, int theSecondOutput) {
        List<ItemStack> outputOnes;
        if (this.slots[theInput] != null && (outputOnes = CrusherRecipeRegistry.getOutputOnes(this.slots[theInput])) != null && !outputOnes.isEmpty()) {
            ItemStack outputTwo;
            ItemStack outputOne = outputOnes.get(0);
            List<ItemStack> outputTwos = CrusherRecipeRegistry.getOutputTwos(this.slots[theInput]);
            ItemStack itemStack = outputTwo = outputTwos == null ? null : outputTwos.get(0);
            if (outputOne != null) {
                if (outputOne.func_77952_i() == Short.MAX_VALUE) {
                    outputOne.func_77964_b(0);
                }
                if (outputTwo != null && outputTwo.func_77952_i() == Short.MAX_VALUE) {
                    outputTwo.func_77964_b(0);
                }
                if ((this.slots[theFirstOutput] == null || this.slots[theFirstOutput].func_77969_a(outputOne) && this.slots[theFirstOutput].field_77994_a <= this.slots[theFirstOutput].func_77976_d() - outputOne.field_77994_a) && (outputTwo == null || this.slots[theSecondOutput] == null || this.slots[theSecondOutput].func_77969_a(outputTwo) && this.slots[theSecondOutput].field_77994_a <= this.slots[theSecondOutput].func_77976_d() - outputTwo.field_77994_a)) {
                    return true;
                }
            }
        }
        return false;
    }

    private int getMaxCrushTime() {
        return this.isDouble ? 150 : 100;
    }

    public void finishCrushing(int theInput, int theFirstOutput, int theSecondOutput) {
        ItemStack outputTwo;
        List<ItemStack> outputTwos;
        ItemStack outputOne;
        List<ItemStack> outputOnes = CrusherRecipeRegistry.getOutputOnes(this.slots[theInput]);
        if (outputOnes != null && (outputOne = outputOnes.get(0)) != null) {
            if (outputOne.func_77952_i() == Short.MAX_VALUE) {
                outputOne.func_77964_b(0);
            }
            if (this.slots[theFirstOutput] == null) {
                this.slots[theFirstOutput] = outputOne.func_77946_l();
            } else if (this.slots[theFirstOutput].func_77973_b() == outputOne.func_77973_b()) {
                this.slots[theFirstOutput].field_77994_a += outputOne.field_77994_a;
            }
        }
        if ((outputTwos = CrusherRecipeRegistry.getOutputTwos(this.slots[theInput])) != null && (outputTwo = outputTwos.get(0)) != null) {
            int rand;
            if (outputTwo.func_77952_i() == Short.MAX_VALUE) {
                outputTwo.func_77964_b(0);
            }
            if ((rand = Util.RANDOM.nextInt(100) + 1) <= CrusherRecipeRegistry.getOutputTwoChance(this.slots[theInput])) {
                if (this.slots[theSecondOutput] == null) {
                    this.slots[theSecondOutput] = outputTwo.func_77946_l();
                } else if (this.slots[theSecondOutput].func_77973_b() == outputTwo.func_77973_b()) {
                    this.slots[theSecondOutput].field_77994_a += outputTwo.field_77994_a;
                }
            }
        }
        --this.slots[theInput].field_77994_a;
        if (this.slots[theInput].field_77994_a <= 0) {
            this.slots[theInput] = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @SideOnly(value=Side.CLIENT)
    public int getFirstTimeToScale(int i) {
        return this.firstCrushTime * i / this.getMaxCrushTime();
    }

    @SideOnly(value=Side.CLIENT)
    public int getSecondTimeToScale(int i) {
        return this.secondCrushTime * i / this.getMaxCrushTime();
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == 1 || slot == 2 || slot == 4 || slot == 5;
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            this.isAutoSplit = !this.isAutoSplit;
            this.func_70296_d();
        }
    }
}

