/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFurnaceDouble
extends TileEntityInventoryBase
implements IEnergyReceiver,
IButtonReactor {
    public static final int SLOT_INPUT_1 = 0;
    public static final int SLOT_OUTPUT_1 = 1;
    public static final int SLOT_INPUT_2 = 2;
    public static final int SLOT_OUTPUT_2 = 3;
    public static final int ENERGY_USE = 25;
    private static final int SMELT_TIME = 80;
    public final EnergyStorage storage = new EnergyStorage(30000);
    public int firstSmeltTime;
    public int secondSmeltTime;
    private int lastEnergy;
    private int lastFirstSmelt;
    private int lastSecondSmelt;
    public boolean isAutoSplit;
    private boolean lastAutoSplit;

    public TileEntityFurnaceDouble() {
        super(4, "furnaceDouble");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("FirstSmeltTime", this.firstSmeltTime);
            compound.func_74768_a("SecondSmeltTime", this.secondSmeltTime);
            compound.func_74757_a("IsAutoSplit", this.isAutoSplit);
        }
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.firstSmeltTime = compound.func_74762_e("FirstSmeltTime");
            this.secondSmeltTime = compound.func_74762_e("SecondSmeltTime");
            this.isAutoSplit = compound.func_74767_n("IsAutoSplit");
        }
        this.storage.readFromNBT(compound);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (this.isAutoSplit) {
                TileEntityFurnaceDouble.autoSplit(this.slots, 0, 2);
            }
            boolean flag = this.firstSmeltTime > 0 || this.secondSmeltTime > 0;
            boolean canSmeltOnFirst = this.canSmeltOn(0, 1);
            boolean canSmeltOnSecond = this.canSmeltOn(2, 3);
            if (canSmeltOnFirst) {
                if (this.storage.getEnergyStored() >= 25) {
                    ++this.firstSmeltTime;
                    if (this.firstSmeltTime >= 80) {
                        this.finishBurning(0, 1);
                        this.firstSmeltTime = 0;
                    }
                    this.storage.extractEnergy(25, false);
                }
            } else {
                this.firstSmeltTime = 0;
            }
            if (canSmeltOnSecond) {
                if (this.storage.getEnergyStored() >= 25) {
                    ++this.secondSmeltTime;
                    if (this.secondSmeltTime >= 80) {
                        this.finishBurning(2, 3);
                        this.secondSmeltTime = 0;
                    }
                    this.storage.extractEnergy(25, false);
                }
            } else {
                this.secondSmeltTime = 0;
            }
            if (flag != (this.firstSmeltTime > 0 || this.secondSmeltTime > 0)) {
                this.func_70296_d();
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                Block block = state.func_177230_c();
                int meta = block.func_176201_c(state);
                if (meta > 3) {
                    if (!this.canSmeltOn(0, 1) && !this.canSmeltOn(2, 3)) {
                        this.field_145850_b.func_180501_a(this.field_174879_c, block.func_176203_a(meta - 4), 2);
                    }
                } else {
                    this.field_145850_b.func_180501_a(this.field_174879_c, block.func_176203_a(meta + 4), 2);
                }
            }
            if ((this.lastEnergy != this.storage.getEnergyStored() || this.lastFirstSmelt != this.firstSmeltTime || this.lastSecondSmelt != this.secondSmeltTime || this.isAutoSplit != this.lastAutoSplit) && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
                this.lastFirstSmelt = this.firstSmeltTime;
                this.lastAutoSplit = this.isAutoSplit;
                this.lastSecondSmelt = this.secondSmeltTime;
            }
        }
    }

    public static void autoSplit(ItemStack[] slots, int slot1, int slot2) {
        ItemStack first = slots[slot1];
        ItemStack second = slots[slot2];
        if (first != null || second != null) {
            ItemStack toSplit = null;
            if (first == null && second != null) {
                toSplit = second;
            } else if (second == null && first != null) {
                toSplit = first;
            } else if (!(!ItemUtil.canBeStacked(first, second) || first.field_77994_a >= first.func_77976_d() && second.field_77994_a >= second.func_77976_d() || first.field_77994_a <= second.field_77994_a + 1 && first.field_77994_a >= second.field_77994_a - 1 || second.field_77994_a <= first.field_77994_a + 1 && second.field_77994_a >= first.field_77994_a - 1)) {
                toSplit = first;
                toSplit.field_77994_a += second.field_77994_a;
            }
            if (toSplit != null && toSplit.field_77994_a > 1) {
                ItemStack splitFirst = toSplit.func_77946_l();
                ItemStack secondSplit = splitFirst.func_77979_a(splitFirst.field_77994_a / 2);
                slots[slot1] = splitFirst;
                slots[slot2] = secondSplit;
            }
        }
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return (i == 0 || i == 2) && FurnaceRecipes.func_77602_a().func_151395_a(stack) != null;
    }

    public boolean canSmeltOn(int theInput, int theOutput) {
        if (this.slots[theInput] != null) {
            ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[theInput]);
            if (this.slots[theInput] != null && output != null && (this.slots[theOutput] == null || this.slots[theOutput].func_77969_a(output) && this.slots[theOutput].field_77994_a <= this.slots[theOutput].func_77976_d() - output.field_77994_a)) {
                return true;
            }
        }
        return false;
    }

    public void finishBurning(int theInput, int theOutput) {
        ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[theInput]);
        if (this.slots[theOutput] == null) {
            this.slots[theOutput] = output.func_77946_l();
        } else if (this.slots[theOutput].func_77973_b() == output.func_77973_b()) {
            this.slots[theOutput].field_77994_a += output.field_77994_a;
        }
        --this.slots[theInput].field_77994_a;
        if (this.slots[theInput].field_77994_a <= 0) {
            this.slots[theInput] = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getFirstTimeToScale(int i) {
        return this.firstSmeltTime * i / 80;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSecondTimeToScale(int i) {
        return this.secondSmeltTime * i / 80;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == 1 || slot == 3;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        if (buttonID == 0) {
            this.isAutoSplit = !this.isAutoSplit;
            this.func_70296_d();
        }
    }
}

