/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.Util;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;

public class TileEntityFishingNet
extends TileEntityBase {
    public int timeUntilNextDrop;

    public TileEntityFishingNet() {
        super("fishingNet");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("TimeUntilNextDrop", this.timeUntilNextDrop);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.timeUntilNextDrop = compound.func_74762_e("TimeUntilNextDrop");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K && !this.isRedstonePowered && this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_185904_a() == Material.field_151586_h) {
            if (this.timeUntilNextDrop > 0) {
                --this.timeUntilNextDrop;
                if (this.timeUntilNextDrop <= 0) {
                    LootContext.Builder builder = new LootContext.Builder((WorldServer)this.field_145850_b);
                    List fishables = this.field_145850_b.func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(Util.RANDOM, builder.func_186471_a());
                    for (ItemStack fishable : fishables) {
                        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
                        if (tile != null && tile instanceof IInventory) {
                            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                            list.add(fishable);
                            WorldUtil.addToInventory((IInventory)tile, list, EnumFacing.DOWN, true, false);
                            continue;
                        }
                        EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, fishable);
                        item.lifespan = 2000;
                        this.field_145850_b.func_72838_d((Entity)item);
                    }
                }
            } else {
                int time = 15000;
                this.timeUntilNextDrop = time + Util.RANDOM.nextInt(time / 2);
            }
        }
    }
}

