/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class TileEntityFireworkBox
extends TileEntityBase
implements IEnergyReceiver,
IEnergyDisplay {
    public static final int USE_PER_SHOT = 300;
    public final EnergyStorage storage = new EnergyStorage(20000);
    private int timeUntilNextFirework;
    private int oldEnergy;

    public TileEntityFireworkBox() {
        super("fireworkBox");
    }

    public static void spawnFireworks(World world, double x, double y, double z) {
        int range = 4;
        int amount = Util.RANDOM.nextInt(5) + 1;
        for (int i = 0; i < amount; ++i) {
            ItemStack firework = TileEntityFireworkBox.makeFirework();
            double newX = x + MathHelper.func_82716_a((Random)Util.RANDOM, (double)0.0, (double)(range * 2)) - (double)range;
            double newZ = z + MathHelper.func_82716_a((Random)Util.RANDOM, (double)0.0, (double)(range * 2)) - (double)range;
            EntityFireworkRocket rocket = new EntityFireworkRocket(world, newX, y + 0.5, newZ, firework);
            world.func_72838_d((Entity)rocket);
        }
    }

    private static ItemStack makeFirework() {
        NBTTagList list = new NBTTagList();
        int chargesAmount = Util.RANDOM.nextInt(2) + 1;
        for (int i = 0; i < chargesAmount; ++i) {
            list.func_74742_a((NBTBase)TileEntityFireworkBox.makeFireworkCharge());
        }
        NBTTagCompound compound1 = new NBTTagCompound();
        compound1.func_74782_a("Explosions", (NBTBase)list);
        compound1.func_74774_a("Flight", (byte)(Util.RANDOM.nextInt(3) + 1));
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Fireworks", (NBTBase)compound1);
        ItemStack firework = new ItemStack(Items.field_151152_bP);
        firework.func_77982_d(compound);
        return firework;
    }

    private static NBTTagCompound makeFireworkCharge() {
        NBTTagCompound compound = new NBTTagCompound();
        if (Util.RANDOM.nextFloat() >= 0.65f) {
            if (Util.RANDOM.nextFloat() >= 0.5f) {
                compound.func_74757_a("Flicker", true);
            } else {
                compound.func_74757_a("Trail", true);
            }
        }
        int[] colors = new int[MathHelper.func_76136_a((Random)Util.RANDOM, (int)1, (int)6)];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = ItemDye.field_150922_c[Util.RANDOM.nextInt(ItemDye.field_150922_c.length)];
        }
        compound.func_74783_a("Colors", colors);
        compound.func_74774_a("Type", (byte)Util.RANDOM.nextInt(5));
        return compound;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isRedstonePowered && !this.isPulseMode) {
                if (this.timeUntilNextFirework > 0) {
                    --this.timeUntilNextFirework;
                    if (this.timeUntilNextFirework <= 0) {
                        this.doWork();
                    }
                } else {
                    this.timeUntilNextFirework = 100;
                }
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    private void doWork() {
        if (this.storage.getEnergyStored() >= 300) {
            TileEntityFireworkBox.spawnFireworks(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            this.storage.extractEnergy(300, false);
        }
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }
}

