/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.Util;
import java.util.List;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFeeder
extends TileEntityInventoryBase {
    public static final int THRESHOLD = 30;
    private static final int TIME = 100;
    public int currentTimer;
    public int currentAnimalAmount;
    private int lastAnimalAmount;
    private int lastTimer;

    public TileEntityFeeder() {
        super(1, "feeder");
    }

    @SideOnly(value=Side.CLIENT)
    public int getCurrentTimerToScale(int i) {
        return this.currentTimer * i / 100;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        compound.func_74768_a("Timer", this.currentTimer);
        if (type == TileEntityBase.NBTType.SYNC) {
            compound.func_74768_a("Animals", this.currentAnimalAmount);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.currentTimer = compound.func_74762_e("Timer");
        if (type == TileEntityBase.NBTType.SYNC) {
            this.currentAnimalAmount = compound.func_74762_e("Animals");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            boolean theFlag = this.currentTimer > 0;
            int range = 5;
            List animals = this.field_145850_b.func_72872_a(EntityAnimal.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - range), (double)(this.field_174879_c.func_177956_o() - range), (double)(this.field_174879_c.func_177952_p() - range), (double)(this.field_174879_c.func_177958_n() + range), (double)(this.field_174879_c.func_177956_o() + range), (double)(this.field_174879_c.func_177952_p() + range)));
            if (animals != null) {
                this.currentAnimalAmount = animals.size();
                if (this.currentAnimalAmount >= 2) {
                    if (this.currentAnimalAmount < 30) {
                        if (this.currentTimer >= 100) {
                            EntityAnimal randomAnimal;
                            this.currentTimer = 0;
                            if (this.slots[0] != null && !(randomAnimal = (EntityAnimal)animals.get(Util.RANDOM.nextInt(this.currentAnimalAmount))).func_70880_s() && randomAnimal.func_70874_b() == 0 && randomAnimal.func_70877_b(this.slots[0])) {
                                this.feedAnimal(randomAnimal);
                                --this.slots[0].field_77994_a;
                                if (this.slots[0].field_77994_a == 0) {
                                    this.slots[0] = this.slots[0].func_77973_b().getContainerItem(this.slots[0]);
                                }
                            }
                        } else {
                            ++this.currentTimer;
                        }
                    } else {
                        this.currentTimer = 0;
                    }
                } else {
                    this.currentTimer = 0;
                }
            }
            if (theFlag != this.currentTimer > 0) {
                this.func_70296_d();
            }
            if ((this.lastAnimalAmount != this.currentAnimalAmount || this.lastTimer != this.currentTimer) && this.sendUpdateWithInterval()) {
                this.lastAnimalAmount = this.currentAnimalAmount;
                this.lastTimer = this.currentTimer;
            }
        }
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return true;
    }

    public void feedAnimal(EntityAnimal animal) {
        animal.func_146082_f(null);
        for (int i = 0; i < 7; ++i) {
            double d = Util.RANDOM.nextGaussian() * 0.02;
            double d1 = Util.RANDOM.nextGaussian() * 0.02;
            double d2 = Util.RANDOM.nextGaussian() * 0.02;
            this.field_145850_b.func_175688_a(EnumParticleTypes.HEART, animal.field_70165_t + (double)(Util.RANDOM.nextFloat() * animal.field_70130_N * 2.0f) - (double)animal.field_70130_N, animal.field_70163_u + 0.5 + (double)(Util.RANDOM.nextFloat() * animal.field_70131_O), animal.field_70161_v + (double)(Util.RANDOM.nextFloat() * animal.field_70130_N * 2.0f) - (double)animal.field_70130_N, d, d1, d2, new int[0]);
        }
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return false;
    }
}

