/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyContainerItem;
import cofh.api.energy.IEnergyProvider;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.compat.TeslaUtil;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityEnervator
extends TileEntityInventoryBase
implements IEnergyProvider {
    public final EnergyStorage storage = new EnergyStorage(500000);
    private int lastEnergy;

    public TileEntityEnervator() {
        super(2, "enervator");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        this.storage.writeToNBT(compound);
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        this.storage.readFromNBT(compound);
        super.readSyncableNBT(compound, type);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (this.slots[0] != null && this.slots[1] == null && this.storage.getEnergyStored() < this.storage.getMaxEnergyStored()) {
                int extracted = 0;
                boolean canTakeUp = false;
                int maxExtract = this.storage.getMaxEnergyStored() - this.storage.getEnergyStored();
                if (this.slots[0].func_77973_b() instanceof IEnergyContainerItem) {
                    IEnergyContainerItem item = (IEnergyContainerItem)this.slots[0].func_77973_b();
                    extracted = item.extractEnergy(this.slots[0], maxExtract, false);
                    canTakeUp = item.getEnergyStored(this.slots[0]) <= 0;
                } else if (ActuallyAdditions.teslaLoaded) {
                    ITeslaProducer cap;
                    if (this.slots[0].hasCapability(TeslaUtil.teslaProducer, null) && (cap = (ITeslaProducer)this.slots[0].getCapability(TeslaUtil.teslaProducer, null)) != null) {
                        extracted = (int)cap.takePower((long)maxExtract, false);
                    }
                    if (this.slots[0].hasCapability(TeslaUtil.teslaHolder, null) && (cap = (ITeslaHolder)this.slots[0].getCapability(TeslaUtil.teslaHolder, null)) != null) {
                        boolean bl = canTakeUp = cap.getStoredPower() <= 0L;
                    }
                }
                if (extracted > 0) {
                    this.storage.receiveEnergy(extracted, false);
                }
                if (canTakeUp) {
                    this.slots[1] = this.slots[0].func_77946_l();
                    --this.slots[0].field_77994_a;
                    if (this.slots[0].field_77994_a <= 0) {
                        this.slots[0] = null;
                    }
                }
            }
            if (this.lastEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
            }
        }
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return i == 0 && (stack.func_77973_b() instanceof IEnergyContainerItem || ActuallyAdditions.teslaLoaded && stack.hasCapability(TeslaUtil.teslaProducer, null));
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == 1;
    }
}

