/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.EmpowererRecipe;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityDisplayStand;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class TileEntityEmpowerer
extends TileEntityInventoryBase {
    private int processTime;

    public TileEntityEmpowerer() {
        super(1, "empowerer");
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            EmpowererRecipe recipe = TileEntityEmpowerer.getRecipeForInput(this.slots[0]);
            if (recipe != null) {
                TileEntityDisplayStand[] modifierStands = this.getFittingModifiers(recipe, recipe.time);
                if (modifierStands != null) {
                    boolean lessParticles = ConfigBoolValues.LESS_PARTICLES.isEnabled();
                    ++this.processTime;
                    boolean done = this.processTime >= recipe.time;
                    for (TileEntityDisplayStand stand : modifierStands) {
                        stand.storage.extractEnergy(recipe.energyPerStand / recipe.time, false);
                        if (done) {
                            stand.func_70298_a(0, 1);
                        }
                        if (lessParticles) continue;
                        AssetUtil.shootParticles(this.field_145850_b, stand.func_174877_v().func_177958_n(), (float)stand.func_174877_v().func_177956_o() + 0.45f, stand.func_174877_v().func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), recipe.particleColor, 8, 0.5f, 1.0f);
                    }
                    if (!lessParticles && this.processTime % 5 == 0 && this.field_145850_b instanceof WorldServer) {
                        ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.FIREWORKS_SPARK, false, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + 0.5, 3, 0.0, 0.0, 0.0, 0.1, new int[0]);
                    }
                    if (done) {
                        if (!lessParticles) {
                            ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.END_ROD, false, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + 0.5, 300, 0.0, 0.0, 0.0, 0.25, new int[0]);
                        }
                        this.slots[0] = recipe.output.func_77946_l();
                        this.func_70296_d();
                        this.processTime = 0;
                    }
                }
            } else {
                this.processTime = 0;
            }
        }
    }

    private TileEntityDisplayStand[] getFittingModifiers(EmpowererRecipe recipe, int powerDivider) {
        TileEntityDisplayStand[] modifierStands = new TileEntityDisplayStand[4];
        List<ItemStack> itemsStillNeeded = Arrays.asList(recipe.modifier1, recipe.modifier2, recipe.modifier3, recipe.modifier4);
        for (int i = 0; i < EnumFacing.field_176754_o.length; ++i) {
            ItemStack standItem;
            TileEntityDisplayStand stand;
            EnumFacing facing = EnumFacing.field_176754_o[i];
            BlockPos offset = this.field_174879_c.func_177967_a(facing, 3);
            TileEntity tile = this.field_145850_b.func_175625_s(offset);
            if (tile != null && tile instanceof TileEntityDisplayStand) {
                stand = (TileEntityDisplayStand)tile;
                standItem = stand.func_70301_a(0);
                if (stand.storage.getEnergyStored() < recipe.energyPerStand / powerDivider || !ItemUtil.contains(itemsStillNeeded, standItem, true)) {
                    return null;
                }
            } else {
                return null;
            }
            modifierStands[i] = stand;
            itemsStillNeeded.remove(standItem);
        }
        return modifierStands;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            compound.func_74768_a("ProcessTime", this.processTime);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type == TileEntityBase.NBTType.SAVE_TILE) {
            this.processTime = compound.func_74762_e("ProcessTime");
        }
    }

    public static EmpowererRecipe getRecipeForInput(ItemStack input) {
        if (input != null) {
            for (EmpowererRecipe recipe : ActuallyAdditionsAPI.EMPOWERER_RECIPES) {
                if (recipe.input == null || !recipe.input.func_77969_a(input)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public boolean shouldSyncSlots() {
        return true;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.sendUpdate();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return TileEntityEmpowerer.getRecipeForInput(stack) != null;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return TileEntityEmpowerer.getRecipeForInput(stack) == null;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }
}

