/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class TileEntityDropper
extends TileEntityInventoryBase {
    private int currentTime;

    public TileEntityDropper() {
        super(9, "dropper");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("CurrentTime", this.currentTime);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentTime = compound.func_74762_e("CurrentTime");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!(this.field_145850_b.field_72995_K || this.isRedstonePowered || this.isPulseMode)) {
            if (this.currentTime > 0) {
                --this.currentTime;
                if (this.currentTime <= 0) {
                    this.doWork();
                }
            } else {
                this.currentTime = 5;
            }
        }
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return true;
    }

    private void doWork() {
        if (this.removeFromInventory(false) != null) {
            ItemStack stack = this.removeFromInventory(true);
            stack.field_77994_a = 1;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            WorldUtil.dropItemAtSide(WorldUtil.getDirectionByPistonRotation(state.func_177230_c().func_176201_c(state)), this.field_145850_b, this.field_174879_c, stack);
        }
    }

    public ItemStack removeFromInventory(boolean actuallyDo) {
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            ItemStack slot = this.slots[i].func_77946_l();
            if (actuallyDo) {
                --this.slots[i].field_77994_a;
                if (this.slots[i].field_77994_a <= 0) {
                    this.slots[i] = null;
                }
            }
            return slot;
        }
        return null;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return true;
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }
}

