/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.Util;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityDirectionalBreaker
extends TileEntityInventoryBase
implements IEnergyReceiver {
    public static final int RANGE = 8;
    public static final int ENERGY_USE = 5;
    public final EnergyStorage storage = new EnergyStorage(10000);
    private int lastEnergy;
    private int currentTime;

    public TileEntityDirectionalBreaker() {
        super(9, "directionalBreaker");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("CurrentTime", this.currentTime);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentTime = compound.func_74762_e("CurrentTime");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isRedstonePowered && !this.isPulseMode) {
                if (this.currentTime > 0) {
                    --this.currentTime;
                    if (this.currentTime <= 0) {
                        this.doWork();
                    }
                } else {
                    this.currentTime = 15;
                }
            }
            if (this.storage.getEnergyStored() != this.lastEnergy && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
            }
        }
    }

    private void doWork() {
        if (this.storage.getEnergyStored() >= 40) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            EnumFacing sideToManipulate = WorldUtil.getDirectionByPistonRotation(state.func_177230_c().func_176201_c(state));
            for (int i = 0; i < 8; ++i) {
                BlockPos coordsBlock = this.field_174879_c.func_177967_a(sideToManipulate, i + 1);
                Block blockToBreak = this.field_145850_b.func_180495_p(coordsBlock).func_177230_c();
                if (blockToBreak == null || blockToBreak instanceof BlockAir || !(blockToBreak.func_176195_g(this.field_145850_b.func_180495_p(coordsBlock), this.field_145850_b, this.field_174879_c) > -1.0f)) continue;
                List drops = blockToBreak.getDrops((IBlockAccess)this.field_145850_b, coordsBlock, this.field_145850_b.func_180495_p(coordsBlock), 0);
                float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)this.field_145850_b, (BlockPos)coordsBlock, (IBlockState)this.field_145850_b.func_180495_p(coordsBlock), (int)0, (float)1.0f, (boolean)false, null);
                if (!(Util.RANDOM.nextFloat() <= chance) || !WorldUtil.addToInventory((IInventory)this, drops, false, true)) continue;
                if (!ConfigBoolValues.LESS_BLOCK_BREAKING_EFFECTS.isEnabled()) {
                    this.field_145850_b.func_175718_b(2001, coordsBlock, Block.func_176210_f((IBlockState)this.field_145850_b.func_180495_p(coordsBlock)));
                }
                this.field_145850_b.func_175698_g(coordsBlock);
                WorldUtil.addToInventory((IInventory)this, drops, true, true);
                this.storage.extractEnergy(5, false);
                this.func_70296_d();
            }
        }
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return true;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }
}

