/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import de.ellpeck.actuallyadditions.api.recipe.CoffeeIngredient;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.ItemCoffee;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.misc.SoundHandler;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCoffeeMachine
extends TileEntityInventoryBase
implements IButtonReactor,
IEnergyReceiver,
IFluidHandler {
    public static final int SLOT_COFFEE_BEANS = 0;
    public static final int SLOT_INPUT = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int CACHE_USE = 15;
    public static final int ENERGY_USED = 150;
    public static final int WATER_USE = 500;
    public static final int COFFEE_CACHE_MAX_AMOUNT = 300;
    private static final int TIME_USED = 500;
    public final EnergyStorage storage = new EnergyStorage(300000);
    public final FluidTank tank = new FluidTank(4000){

        public boolean canDrain() {
            return false;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == FluidRegistry.WATER;
        }
    };
    public int coffeeCacheAmount;
    public int brewTime;
    private int lastEnergy;
    private int lastTank;
    private int lastCoffeeAmount;
    private int lastBrewTime;

    public TileEntityCoffeeMachine() {
        super(11, "coffeeMachine");
    }

    @SideOnly(value=Side.CLIENT)
    public int getCoffeeScaled(int i) {
        return this.coffeeCacheAmount * i / 300;
    }

    @SideOnly(value=Side.CLIENT)
    public int getWaterScaled(int i) {
        return this.tank.getFluidAmount() * i / this.tank.getCapacity();
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrewScaled(int i) {
        return this.brewTime * i / 500;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        this.tank.writeToNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("Cache", this.coffeeCacheAmount);
            compound.func_74768_a("Time", this.brewTime);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        this.tank.readFromNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.coffeeCacheAmount = compound.func_74762_e("Cache");
            this.brewTime = compound.func_74762_e("Time");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            this.storeCoffee();
            if (this.brewTime > 0 || this.isRedstonePowered) {
                this.brew();
            }
            if ((this.coffeeCacheAmount != this.lastCoffeeAmount || this.storage.getEnergyStored() != this.lastEnergy || this.tank.getFluidAmount() != this.lastTank || this.brewTime != this.lastBrewTime) && this.sendUpdateWithInterval()) {
                this.lastCoffeeAmount = this.coffeeCacheAmount;
                this.lastEnergy = this.storage.getEnergyStored();
                this.lastTank = this.tank.getFluidAmount();
                this.lastBrewTime = this.brewTime;
            }
        }
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return i >= 3 && ItemCoffee.getIngredientFromStack(stack) != null || i == 0 && stack.func_77973_b() == InitItems.itemCoffeeBean || i == 1 && stack.func_77973_b() == InitItems.itemMisc && stack.func_77952_i() == TheMiscItems.CUP.ordinal();
    }

    public void storeCoffee() {
        int toAdd;
        if (this.slots[0] != null && this.slots[0].func_77973_b() == InitItems.itemCoffeeBean && (toAdd = 2) <= 300 - this.coffeeCacheAmount) {
            --this.slots[0].field_77994_a;
            if (this.slots[0].field_77994_a <= 0) {
                this.slots[0] = null;
            }
            this.coffeeCacheAmount += toAdd;
        }
    }

    public void brew() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.slots[1] != null && this.slots[1].func_77973_b() == InitItems.itemMisc && this.slots[1].func_77952_i() == TheMiscItems.CUP.ordinal() && this.slots[2] == null && this.coffeeCacheAmount >= 15 && this.tank.getFluid() != null && this.tank.getFluid().getFluid() == FluidRegistry.WATER && this.tank.getFluidAmount() >= 500) {
                if (this.storage.getEnergyStored() >= 150) {
                    if (this.brewTime % 30 == 0 && !ConfigBoolValues.LESS_SOUND.isEnabled()) {
                        this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundHandler.coffeeMachine, SoundCategory.BLOCKS, 0.35f, 1.0f);
                    }
                    ++this.brewTime;
                    this.storage.extractEnergy(150, false);
                    if (this.brewTime >= 500) {
                        this.brewTime = 0;
                        ItemStack output = new ItemStack(InitItems.itemCoffee);
                        for (int i = 3; i < this.slots.length; ++i) {
                            CoffeeIngredient ingredient;
                            if (this.slots[i] == null || (ingredient = ItemCoffee.getIngredientFromStack(this.slots[i])) == null || !ingredient.effect(output)) continue;
                            --this.slots[i].field_77994_a;
                            if (this.slots[i].field_77994_a > 0) continue;
                            this.slots[i] = this.slots[i].func_77973_b().getContainerItem(this.slots[i]);
                        }
                        this.slots[2] = output.func_77946_l();
                        --this.slots[1].field_77994_a;
                        if (this.slots[1].field_77994_a <= 0) {
                            this.slots[1] = null;
                        }
                        this.coffeeCacheAmount -= 15;
                        this.tank.drainInternal(500, true);
                    }
                }
            } else {
                this.brewTime = 0;
            }
        }
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == 2 || slot >= 3 && slot < this.slots.length && ItemCoffee.getIngredientFromStack(stack) == null;
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        if (buttonID == 0 && this.brewTime <= 0) {
            this.brew();
        }
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public FluidTank getFluidHandler(EnumFacing facing) {
        return facing != EnumFacing.DOWN ? this.tank : null;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        FluidTank handler = this.getFluidHandler(from);
        return handler == null ? 0 : handler.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        FluidTank handler = this.getFluidHandler(from);
        return handler == null ? null : handler.drain(resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        FluidTank handler = this.getFluidHandler(from);
        return handler == null ? null : handler.drain(maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        FluidTank handler = this.getFluidHandler(from);
        if (handler != null) {
            for (IFluidTankProperties prop : handler.getTankProperties()) {
                if (prop == null || !prop.canFillFluidType(new FluidStack(fluid, Integer.MAX_VALUE))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        FluidTank handler = this.getFluidHandler(from);
        if (handler != null) {
            for (IFluidTankProperties prop : handler.getTankProperties()) {
                if (prop == null || !prop.canDrainFluidType(new FluidStack(fluid, Integer.MAX_VALUE))) continue;
                return true;
            }
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTank handler = this.getFluidHandler(from);
        if (handler instanceof IFluidTank) {
            return new FluidTankInfo[]{((IFluidTank)handler).getInfo()};
        }
        return null;
    }
}

