/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.fluids.InitFluids;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCanolaPress
extends TileEntityInventoryBase
implements IEnergyReceiver,
IFluidHandler {
    public static final int PRODUCE = 80;
    public static final int ENERGY_USE = 35;
    private static final int TIME = 30;
    public final EnergyStorage storage = new EnergyStorage(40000);
    public final FluidTank tank = new FluidTank(2000){

        public boolean canFill() {
            return false;
        }
    };
    public int currentProcessTime;
    private int lastEnergyStored;
    private int lastTankAmount;
    private int lastProcessTime;

    public TileEntityCanolaPress() {
        super(1, "canolaPress");
    }

    @SideOnly(value=Side.CLIENT)
    public int getTankScaled(int i) {
        return this.tank.getFluidAmount() * i / this.tank.getCapacity();
    }

    @SideOnly(value=Side.CLIENT)
    public int getProcessScaled(int i) {
        return this.currentProcessTime * i / 30;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("ProcessTime", this.currentProcessTime);
        }
        this.storage.writeToNBT(compound);
        this.tank.writeToNBT(compound);
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentProcessTime = compound.func_74762_e("ProcessTime");
        }
        this.storage.readFromNBT(compound);
        this.tank.readFromNBT(compound);
        super.readSyncableNBT(compound, type);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (this.isCanola(0) && 80 <= this.tank.getCapacity() - this.tank.getFluidAmount()) {
                if (this.storage.getEnergyStored() >= 35) {
                    ++this.currentProcessTime;
                    this.storage.extractEnergy(35, false);
                    if (this.currentProcessTime >= 30) {
                        this.currentProcessTime = 0;
                        --this.slots[0].field_77994_a;
                        if (this.slots[0].field_77994_a == 0) {
                            this.slots[0] = null;
                        }
                        this.tank.fillInternal(new FluidStack(InitFluids.fluidCanolaOil, 80), true);
                        this.func_70296_d();
                    }
                }
            } else {
                this.currentProcessTime = 0;
            }
            if ((this.storage.getEnergyStored() != this.lastEnergyStored || this.tank.getFluidAmount() != this.lastTankAmount | this.currentProcessTime != this.lastProcessTime) && this.sendUpdateWithInterval()) {
                this.lastEnergyStored = this.storage.getEnergyStored();
                this.lastProcessTime = this.currentProcessTime;
                this.lastTankAmount = this.tank.getFluidAmount();
            }
        }
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return i == 0 && stack.func_77973_b() == InitItems.itemMisc && stack.func_77952_i() == TheMiscItems.CANOLA.ordinal();
    }

    public boolean isCanola(int slot) {
        return this.slots[slot] != null && this.slots[slot].func_77973_b() == InitItems.itemMisc && this.slots[slot].func_77952_i() == TheMiscItems.CANOLA.ordinal();
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return false;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public FluidTank getFluidHandler(EnumFacing facing) {
        return facing != EnumFacing.UP ? this.tank : null;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        FluidTank handler = this.getFluidHandler(from);
        return handler == null ? 0 : handler.fill(resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        FluidTank handler = this.getFluidHandler(from);
        return handler == null ? null : handler.drain(resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        FluidTank handler = this.getFluidHandler(from);
        return handler == null ? null : handler.drain(maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        FluidTank handler = this.getFluidHandler(from);
        if (handler != null) {
            for (IFluidTankProperties prop : handler.getTankProperties()) {
                if (prop == null || !prop.canFillFluidType(new FluidStack(fluid, Integer.MAX_VALUE))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        FluidTank handler = this.getFluidHandler(from);
        if (handler != null) {
            for (IFluidTankProperties prop : handler.getTankProperties()) {
                if (prop == null || !prop.canDrainFluidType(new FluidStack(fluid, Integer.MAX_VALUE))) continue;
                return true;
            }
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTank handler = this.getFluidHandler(from);
        if (handler instanceof IFluidTank) {
            return new FluidTankInfo[]{((IFluidTank)handler).getInfo()};
        }
        return null;
    }
}

