/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigIntValues;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketServerToClient;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityAtomicReconstructor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBookletStand;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBreaker;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCanolaPress;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCoalGenerator;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCoffeeMachine;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCompost;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityDirectionalBreaker;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityDisplayStand;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityDropper;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityEmpowerer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityEnergizer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityEnervator;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFeeder;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFermentingBarrel;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFireworkBox;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFishingNet;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFluidCollector;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFluidPlacer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFurnaceDouble;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityFurnaceSolar;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGiantChest;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGiantChestLarge;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGiantChestMedium;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGreenhouseGlass;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGrinder;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGrinderDouble;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityHeatCollector;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInputter;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInputterAdvanced;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityItemRepairer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityItemViewer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergy;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergyAdvanced;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergyExtreme;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItem;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItemWhitelist;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLavaFactoryController;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLeafGenerator;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityMiner;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityOilGenerator;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomBooster;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomBreaker;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomEnergyface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomItemface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomLiquiface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomPlacer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomRedstoneface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPlacer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPlayerInterface;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityRangedCollector;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityShockSuppressor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntitySmileyCloud;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityXPSolidifier;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.TeslaUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;

public abstract class TileEntityBase
extends TileEntity
implements ITickable {
    public final String name;
    public boolean isRedstonePowered;
    public boolean isPulseMode;
    protected int ticksElapsed;

    public TileEntityBase(String name) {
        this.name = name;
    }

    public static void init() {
        ModUtil.LOGGER.info("Registering TileEntities...");
        TileEntityBase.register(TileEntityCompost.class, "Compost");
        TileEntityBase.register(TileEntityFeeder.class, "Feeder");
        TileEntityBase.register(TileEntityGiantChest.class, "GiantChest");
        TileEntityBase.register(TileEntityGiantChestMedium.class, "GiantChestMedium");
        TileEntityBase.register(TileEntityGiantChestLarge.class, "GiantChestLarge");
        TileEntityBase.register(TileEntityGrinder.class, "Grinder");
        TileEntityBase.register(TileEntityFurnaceDouble.class, "FurnaceDouble");
        TileEntityBase.register(TileEntityInputter.class, "Inputter");
        TileEntityBase.register(TileEntityFishingNet.class, "FishingNet");
        TileEntityBase.register(TileEntityFurnaceSolar.class, "FurnaceSolar");
        TileEntityBase.register(TileEntityHeatCollector.class, "HeatCollector");
        TileEntityBase.register(TileEntityItemRepairer.class, "Repairer");
        TileEntityBase.register(TileEntityGreenhouseGlass.class, "GreenhouseGlass");
        TileEntityBase.register(TileEntityBreaker.class, "Breaker");
        TileEntityBase.register(TileEntityDropper.class, "Dropper");
        TileEntityBase.register(TileEntityInputterAdvanced.class, "InputterAdvanced");
        TileEntityBase.register(TileEntityPlacer.class, "Placer");
        TileEntityBase.register(TileEntityGrinderDouble.class, "GrinderDouble");
        TileEntityBase.register(TileEntityCanolaPress.class, "CanolaPress");
        TileEntityBase.register(TileEntityFermentingBarrel.class, "FermentingBarrel");
        TileEntityBase.register(TileEntityOilGenerator.class, "OilGenerator");
        TileEntityBase.register(TileEntityCoalGenerator.class, "CoalGenerator");
        TileEntityBase.register(TileEntityPhantomItemface.class, "PhantomItemface");
        TileEntityBase.register(TileEntityPhantomLiquiface.class, "PhantomLiquiface");
        TileEntityBase.register(TileEntityPhantomEnergyface.class, "PhantomEnergyface");
        TileEntityBase.register(TileEntityPlayerInterface.class, "PlayerInterface");
        TileEntityBase.register(TileEntityPhantomPlacer.class, "PhantomPlacer");
        TileEntityBase.register(TileEntityPhantomBreaker.class, "PhantomBreaker");
        TileEntityBase.register(TileEntityFluidCollector.class, "FluidCollector");
        TileEntityBase.register(TileEntityFluidPlacer.class, "FluidPlacer");
        TileEntityBase.register(TileEntityLavaFactoryController.class, "LavaFactoryController");
        TileEntityBase.register(TileEntityCoffeeMachine.class, "CoffeeMachine");
        TileEntityBase.register(TileEntityPhantomBooster.class, "PhantomBooster");
        TileEntityBase.register(TileEntityEnergizer.class, "Energizer");
        TileEntityBase.register(TileEntityEnervator.class, "Enervator");
        TileEntityBase.register(TileEntityXPSolidifier.class, "XPSolidifier");
        TileEntityBase.register(TileEntitySmileyCloud.class, "Cloud");
        TileEntityBase.register(TileEntityLeafGenerator.class, "LeafGenerator");
        TileEntityBase.register(TileEntityDirectionalBreaker.class, "DirectionalBreaker");
        TileEntityBase.register(TileEntityRangedCollector.class, "RangedCollector");
        TileEntityBase.register(TileEntityAtomicReconstructor.class, "AtomicReconstructor");
        TileEntityBase.register(TileEntityMiner.class, "Miner");
        TileEntityBase.register(TileEntityFireworkBox.class, "FireworkBox");
        TileEntityBase.register(TileEntityPhantomRedstoneface.class, "PhantomRedstoneface");
        TileEntityBase.register(TileEntityLaserRelayItem.class, "LaserRelayItem");
        TileEntityBase.register(TileEntityLaserRelayEnergy.class, "LaserRelay");
        TileEntityBase.register(TileEntityLaserRelayEnergyAdvanced.class);
        TileEntityBase.register(TileEntityLaserRelayEnergyExtreme.class);
        TileEntityBase.register(TileEntityLaserRelayItemWhitelist.class, "LaserRelayItemWhitelist");
        TileEntityBase.register(TileEntityItemViewer.class, "ItemViewer");
        TileEntityBase.register(TileEntityBookletStand.class, "BookletStand");
        TileEntityBase.register(TileEntityDisplayStand.class, "DisplayStand");
        TileEntityBase.register(TileEntityShockSuppressor.class, "ShockSuppressor");
        TileEntityBase.register(TileEntityEmpowerer.class);
    }

    private static void register(Class<? extends TileEntityBase> tileClass, String legacyName) {
        try {
            String name = "actuallyadditions:" + tileClass.newInstance().name;
            if (legacyName != null && !legacyName.isEmpty()) {
                String oldName = "actuallyadditions:tileEntity" + legacyName;
                GameRegistry.registerTileEntityWithAlternatives(tileClass, (String)name, (String[])new String[]{oldName});
            } else {
                GameRegistry.registerTileEntity(tileClass, (String)name);
            }
        }
        catch (Exception e) {
            ModUtil.LOGGER.fatal("Registering a TileEntity failed!", (Throwable)e);
        }
    }

    private static void register(Class<? extends TileEntityBase> tileClass) {
        TileEntityBase.register(tileClass, null);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readSyncableNBT(compound, NBTType.SAVE_TILE);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        this.writeSyncableNBT(compound, NBTType.SAVE_TILE);
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189517_E_();
        if (compound != null) {
            return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
        }
        return null;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (pkt != null) {
            NBTTagCompound compound = pkt.func_148857_g();
            this.func_145839_a(compound);
            this.receiveSyncCompound(compound);
        }
    }

    public void receiveSyncCompound(NBTTagCompound compound) {
        this.readSyncableNBT(compound, NBTType.SYNC);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.writeSyncableNBT(tag, NBTType.SYNC);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound compound) {
        super.handleUpdateTag(compound);
        this.receiveSyncCompound(compound);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return !oldState.func_177230_c().func_149667_c(newState.func_177230_c());
    }

    public void writeSyncableNBT(NBTTagCompound compound, NBTType type) {
        if (type == NBTType.SAVE_TILE) {
            compound.func_74757_a("Redstone", this.isRedstonePowered);
            compound.func_74768_a("TicksElapsed", this.ticksElapsed);
        }
        if (this.isRedstoneToggle() && (type != NBTType.SAVE_BLOCK || this.isPulseMode)) {
            compound.func_74757_a("IsPulseMode", this.isPulseMode);
        }
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("container.actuallyadditions." + this.name + ".name", new Object[0]);
    }

    public void readSyncableNBT(NBTTagCompound compound, NBTType type) {
        if (type == NBTType.SAVE_TILE) {
            this.isRedstonePowered = compound.func_74767_n("Redstone");
            this.ticksElapsed = compound.func_74762_e("TicksElapsed");
        }
        if (this.isRedstoneToggle()) {
            this.isPulseMode = compound.func_74767_n("IsPulseMode");
        }
    }

    public void func_73660_a() {
        this.updateEntity();
    }

    public void updateEntity() {
        ++this.ticksElapsed;
        if (!this.field_145850_b.field_72995_K) {
            if (this instanceof IEnergyReceiver || this instanceof IEnergyProvider) {
                WorldUtil.doEnergyInteraction(this);
            }
            if (this instanceof net.minecraftforge.fluids.IFluidHandler || this.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                WorldUtil.doFluidInteraction(this);
            }
        }
    }

    public void setRedstonePowered(boolean powered) {
        this.isRedstonePowered = powered;
        this.func_70296_d();
    }

    public boolean canPlayerUse(EntityPlayer player) {
        return player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0 && !this.func_145837_r() && this.field_145850_b.func_175625_s(this.field_174879_c) == this;
    }

    protected boolean sendUpdateWithInterval() {
        if (this.ticksElapsed % ConfigIntValues.TILE_ENTITY_UPDATE_INTERVAL.getValue() == 0) {
            this.sendUpdate();
            return true;
        }
        return false;
    }

    public void sendUpdate() {
        NBTTagCompound compound;
        if (!this.field_145850_b.field_72995_K && (compound = this.func_189517_E_()) != null) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74782_a("Data", (NBTBase)compound);
            data.func_74768_a("X", this.field_174879_c.func_177958_n());
            data.func_74768_a("Y", this.field_174879_c.func_177956_o());
            data.func_74768_a("Z", this.field_174879_c.func_177952_p());
            PacketHandler.theNetwork.sendToAllAround((IMessage)new PacketServerToClient(data, PacketHandler.TILE_ENTITY_HANDLER), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 128.0));
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        T cap;
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            IFluidHandler tank = this.getFluidHandler(facing);
            if (tank != null) {
                return (T)tank;
            }
        } else if (ActuallyAdditions.teslaLoaded && (cap = TeslaUtil.wrapTeslaToRF(this, capability, facing)) != null) {
            return cap;
        }
        return (T)super.getCapability(capability, facing);
    }

    public IFluidHandler getFluidHandler(EnumFacing facing) {
        return null;
    }

    public boolean isRedstoneToggle() {
        return false;
    }

    public void activateOnPulse() {
    }

    public static enum NBTType {
        SAVE_TILE,
        SYNC,
        SAVE_BLOCK;

    }
}

