/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.items.ItemDrill;
import de.ellpeck.actuallyadditions.mod.items.ItemFilter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class FilterSettings {
    public final int startSlot;
    public final int endSlot;
    public boolean isWhitelist;
    private boolean lastWhitelist;
    public boolean respectMeta;
    private boolean lastRespectMeta;
    public boolean respectNBT;
    private boolean lastRespectNBT;
    public int respectOredict;
    private int lastRecpectOredict;
    public final int whitelistButtonId;
    public final int metaButtonId;
    public final int nbtButtonId;
    public final int oredictButtonId;

    public FilterSettings(int startSlot, int endSlot, boolean defaultWhitelist, boolean defaultRespectMeta, boolean defaultRespectNBT, int defaultRespectOredict, int buttonIdStart) {
        this.startSlot = startSlot;
        this.endSlot = endSlot;
        this.isWhitelist = defaultWhitelist;
        this.respectMeta = defaultRespectMeta;
        this.respectNBT = defaultRespectNBT;
        this.respectOredict = defaultRespectOredict;
        this.whitelistButtonId = buttonIdStart;
        this.metaButtonId = buttonIdStart + 1;
        this.nbtButtonId = buttonIdStart + 2;
        this.oredictButtonId = buttonIdStart + 3;
    }

    public void writeToNBT(NBTTagCompound tag, String name) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("Whitelist", this.isWhitelist);
        compound.func_74757_a("Meta", this.respectMeta);
        compound.func_74757_a("NBT", this.respectNBT);
        compound.func_74768_a("Oredict", this.respectOredict);
        tag.func_74782_a(name, (NBTBase)compound);
    }

    public void readFromNBT(NBTTagCompound tag, String name) {
        NBTTagCompound compound = tag.func_74775_l(name);
        this.isWhitelist = compound.func_74767_n("Whitelist");
        this.respectMeta = compound.func_74767_n("Meta");
        this.respectNBT = compound.func_74767_n("NBT");
        this.respectOredict = compound.func_74762_e("Oredict");
    }

    public boolean needsUpdateSend() {
        return this.lastWhitelist != this.isWhitelist || this.lastRespectMeta != this.respectMeta || this.lastRespectNBT != this.respectNBT || this.lastRecpectOredict != this.respectOredict;
    }

    public void updateLasts() {
        this.lastWhitelist = this.isWhitelist;
        this.lastRespectMeta = this.respectMeta;
        this.lastRespectNBT = this.respectNBT;
        this.lastRecpectOredict = this.respectOredict;
    }

    public void onButtonPressed(int id) {
        if (id == this.whitelistButtonId) {
            this.isWhitelist = !this.isWhitelist;
        } else if (id == this.metaButtonId) {
            this.respectMeta = !this.respectMeta;
        } else if (id == this.nbtButtonId) {
            this.respectNBT = !this.respectNBT;
        } else if (id == this.oredictButtonId) {
            this.respectOredict = this.respectOredict + 1 > 2 ? 0 : ++this.respectOredict;
        }
    }

    public boolean check(ItemStack stack, ItemStack[] slots) {
        return FilterSettings.check(stack, slots, this.startSlot, this.endSlot, this.isWhitelist, this.respectMeta, this.respectNBT, this.respectOredict);
    }

    public static boolean check(ItemStack stack, ItemStack[] slots, int startSlot, int endSlot, boolean whitelist, boolean meta, boolean nbt, int oredict) {
        if (stack != null) {
            for (int i = startSlot; i < endSlot; ++i) {
                if (slots[i] == null) continue;
                if (FilterSettings.areEqualEnough(slots[i], stack, meta, nbt, oredict)) {
                    return whitelist;
                }
                if (!(slots[i].func_77973_b() instanceof ItemFilter)) continue;
                ItemStack[] filterSlots = new ItemStack[24];
                ItemDrill.loadSlotsFromNBT(filterSlots, slots[i]);
                if (filterSlots == null || filterSlots.length <= 0) continue;
                for (ItemStack filterSlot : filterSlots) {
                    if (filterSlot == null || !FilterSettings.areEqualEnough(filterSlot, stack, meta, nbt, oredict)) continue;
                    return whitelist;
                }
            }
        }
        return !whitelist;
    }

    private static boolean areEqualEnough(ItemStack first, ItemStack second, boolean meta, boolean nbt, int oredict) {
        boolean nbtFine;
        if (first.func_77973_b() != second.func_77973_b()) {
            return false;
        }
        boolean metaFine = !meta || first.func_77952_i() == second.func_77952_i();
        boolean bl = nbtFine = !nbt || ItemStack.func_77970_a((ItemStack)first, (ItemStack)second);
        if (metaFine && nbtFine) {
            if (oredict == 0) {
                return true;
            }
            int[] firstIds = OreDictionary.getOreIDs((ItemStack)first);
            int[] secondIds = OreDictionary.getOreIDs((ItemStack)second);
            boolean firstEmpty = ArrayUtils.isEmpty((int[])firstIds);
            boolean secondEmpty = ArrayUtils.isEmpty((int[])secondIds);
            if (firstEmpty && secondEmpty) {
                return true;
            }
            if (firstEmpty || secondEmpty) {
                return false;
            }
            for (int id : firstIds) {
                if (ArrayUtils.contains((int[])secondIds, (int)id)) {
                    if (oredict != 1) continue;
                    return true;
                }
                if (oredict != 2) continue;
                return false;
            }
            return oredict == 2;
        }
        return false;
    }
}

