/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.proxy;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.booklet.BookletPage;
import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.api.booklet.IBookletEntry;
import de.ellpeck.actuallyadditions.mod.blocks.render.RenderCompost;
import de.ellpeck.actuallyadditions.mod.blocks.render.RenderDisplayStand;
import de.ellpeck.actuallyadditions.mod.blocks.render.RenderEmpowerer;
import de.ellpeck.actuallyadditions.mod.blocks.render.RenderReconstructorLens;
import de.ellpeck.actuallyadditions.mod.blocks.render.RenderSmileyCloud;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.entity.InitEntities;
import de.ellpeck.actuallyadditions.mod.event.ClientEvents;
import de.ellpeck.actuallyadditions.mod.fluids.InitFluids;
import de.ellpeck.actuallyadditions.mod.misc.special.SpecialRenderInit;
import de.ellpeck.actuallyadditions.mod.proxy.IProxy;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityAtomicReconstructor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCompost;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityDisplayStand;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityEmpowerer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntitySmileyCloud;
import de.ellpeck.actuallyadditions.mod.util.FluidStateMapper;
import de.ellpeck.actuallyadditions.mod.util.IColorProvidingItem;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClientProxy
implements IProxy {
    private static final List<Item> COLOR_PRODIVIDING_ITEMS_FOR_REGISTERING = new ArrayList<Item>();
    private static final Map<ItemStack, ModelResourceLocation> MODEL_LOCATIONS_FOR_REGISTERING = new HashMap<ItemStack, ModelResourceLocation>();
    public static int bookletWordCount;
    public static int bookletCharCount;

    private static void countBookletWords() {
        bookletWordCount = 0;
        bookletCharCount = 0;
        String bookletText = "";
        for (IBookletEntry entry : ActuallyAdditionsAPI.BOOKLET_ENTRIES) {
            if (entry == ActuallyAdditionsAPI.allAndSearch) continue;
            bookletWordCount += entry.getLocalizedName().split(" ").length;
            bookletCharCount += entry.getLocalizedName().length();
            bookletText = bookletText + entry.getLocalizedName() + "\n\n";
            for (IBookletChapter chapter : entry.getChapters()) {
                bookletWordCount += chapter.getLocalizedName().split(" ").length;
                bookletCharCount += chapter.getLocalizedName().length();
                bookletText = bookletText + chapter.getLocalizedName() + "\n";
                for (BookletPage page : chapter.getPages()) {
                    if (page.getText() == null) continue;
                    bookletWordCount += page.getText().split(" ").length;
                    bookletCharCount += page.getText().length();
                    bookletText = bookletText + page.getText() + "\n";
                }
                bookletText = bookletText + "\n";
            }
            bookletText = bookletText + "\n";
        }
        if (ConfigBoolValues.BOOKLET_TEXT_TO_FILE.isEnabled()) {
            File file = new File(Minecraft.func_71410_x().field_71412_D, "actuallyadditionsbooklettext.txt");
            try {
                file.createNewFile();
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                writer.write(TextFormatting.func_110646_a((String)bookletText));
                writer.close();
                ModUtil.LOGGER.info("Wrote booklet text to file!");
            }
            catch (Exception e) {
                ModUtil.LOGGER.error("Couldn't write booklet text to file!", (Throwable)e);
            }
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        ModUtil.LOGGER.info("PreInitializing ClientProxy...");
        for (Map.Entry<ItemStack, ModelResourceLocation> entry : MODEL_LOCATIONS_FOR_REGISTERING.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)entry.getKey().func_77973_b(), (int)entry.getKey().func_77952_i(), (ModelResourceLocation)entry.getValue());
        }
        this.registerCustomFluidBlockRenderer(InitFluids.fluidCanolaOil);
        this.registerCustomFluidBlockRenderer(InitFluids.fluidOil);
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        if (manager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)manager).func_110542_a(new IResourceManagerReloadListener(){

                public void func_110549_a(IResourceManager resourceManager) {
                    ClientProxy.countBookletWords();
                }
            });
        }
        InitEntities.initClient();
    }

    private void registerCustomFluidBlockRenderer(Fluid fluid) {
        Block block = fluid.getBlock();
        Item item = Item.func_150898_a((Block)block);
        FluidStateMapper mapper = new FluidStateMapper(fluid);
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        ModUtil.LOGGER.info("Initializing ClientProxy...");
        new ClientEvents();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCompost.class, (TileEntitySpecialRenderer)new RenderCompost());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAtomicReconstructor.class, (TileEntitySpecialRenderer)new RenderReconstructorLens());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySmileyCloud.class, (TileEntitySpecialRenderer)new RenderSmileyCloud());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDisplayStand.class, (TileEntitySpecialRenderer)new RenderDisplayStand());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEmpowerer.class, (TileEntitySpecialRenderer)new RenderEmpowerer());
        for (Item item : COLOR_PRODIVIDING_ITEMS_FOR_REGISTERING) {
            if (!(item instanceof IColorProvidingItem)) continue;
            Minecraft.func_71410_x().getItemColors().func_186730_a(((IColorProvidingItem)item).getColor(), new Item[]{item});
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        ModUtil.LOGGER.info("PostInitializing ClientProxy...");
        new SpecialRenderInit();
    }

    @Override
    public void addRenderRegister(ItemStack stack, ResourceLocation location, String variant) {
        MODEL_LOCATIONS_FOR_REGISTERING.put(stack, new ModelResourceLocation(location, variant));
    }

    @Override
    public void addColoredItem(Item item) {
        COLOR_PRODIVIDING_ITEMS_FOR_REGISTERING.add(item);
    }
}

