/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.network;

import de.ellpeck.actuallyadditions.mod.network.PacketClientToServer;
import de.ellpeck.actuallyadditions.mod.network.PacketHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketServerToClient;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class PacketHandlerHelper {
    public static void sendButtonPacket(TileEntity tile, int buttonId) {
        NBTTagCompound compound = new NBTTagCompound();
        BlockPos pos = tile.func_174877_v();
        compound.func_74768_a("X", pos.func_177958_n());
        compound.func_74768_a("Y", pos.func_177956_o());
        compound.func_74768_a("Z", pos.func_177952_p());
        compound.func_74768_a("WorldID", tile.func_145831_w().field_73011_w.getDimension());
        compound.func_74768_a("PlayerID", Minecraft.func_71410_x().field_71439_g.func_145782_y());
        compound.func_74768_a("ButtonID", buttonId);
        PacketHandler.theNetwork.sendToServer((IMessage)new PacketClientToServer(compound, PacketHandler.GUI_BUTTON_TO_TILE_HANDLER));
    }

    public static void sendChangePlayerDataPacket(NBTTagCompound data) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Data", (NBTBase)data);
        Minecraft mc = Minecraft.func_71410_x();
        compound.func_74768_a("WorldID", mc.field_71441_e.field_73011_w.getDimension());
        compound.func_74768_a("PlayerID", mc.field_71439_g.func_145782_y());
        PacketHandler.theNetwork.sendToServer((IMessage)new PacketClientToServer(compound, PacketHandler.CHANGE_PLAYER_DATA_HANDLER));
    }

    public static void sendPlayerDataToClientPacket(EntityPlayer player, NBTTagCompound data, boolean log) {
        if (player instanceof EntityPlayerMP) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_186854_a("UUID", player.func_110124_au());
            compound.func_74782_a("Data", (NBTBase)data);
            compound.func_74757_a("Log", log);
            PacketHandler.theNetwork.sendTo((IMessage)new PacketServerToClient(compound, PacketHandler.PLAYER_DATA_TO_CLIENT_HANDLER), (EntityPlayerMP)player);
        }
    }
}

