/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.network;

import de.ellpeck.actuallyadditions.mod.booklet.entry.EntrySet;
import de.ellpeck.actuallyadditions.mod.data.PlayerData;
import de.ellpeck.actuallyadditions.mod.network.IDataHandler;
import de.ellpeck.actuallyadditions.mod.network.PacketClientToServer;
import de.ellpeck.actuallyadditions.mod.network.PacketHandlerHelper;
import de.ellpeck.actuallyadditions.mod.network.PacketServerToClient;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.network.gui.INumberReactor;
import de.ellpeck.actuallyadditions.mod.network.gui.IStringReactor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBookletStand;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.ModUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class PacketHandler {
    public static SimpleNetworkWrapper theNetwork;
    public static final List<IDataHandler> DATA_HANDLERS;
    public static final IDataHandler PARTICLE_HANDLER;
    public static final IDataHandler TILE_ENTITY_HANDLER;
    public static final IDataHandler GUI_BUTTON_TO_TILE_HANDLER;
    public static final IDataHandler GUI_BUTTON_TO_CONTAINER_HANDLER;
    public static final IDataHandler GUI_NUMBER_TO_TILE_HANDLER;
    public static final IDataHandler GUI_STRING_TO_TILE_HANDLER;
    public static final IDataHandler PLAYER_DATA_TO_CLIENT_HANDLER;
    public static final IDataHandler BOOKLET_STAND_BUTTON_HANDLER;
    public static final IDataHandler CHANGE_PLAYER_DATA_HANDLER;

    public static void init() {
        theNetwork = NetworkRegistry.INSTANCE.newSimpleChannel("actuallyadditions");
        theNetwork.registerMessage(PacketServerToClient.Handler.class, PacketServerToClient.class, 0, Side.CLIENT);
        theNetwork.registerMessage(PacketClientToServer.Handler.class, PacketClientToServer.class, 1, Side.SERVER);
        DATA_HANDLERS.add(PARTICLE_HANDLER);
        DATA_HANDLERS.add(TILE_ENTITY_HANDLER);
        DATA_HANDLERS.add(BOOKLET_STAND_BUTTON_HANDLER);
        DATA_HANDLERS.add(GUI_BUTTON_TO_TILE_HANDLER);
        DATA_HANDLERS.add(GUI_STRING_TO_TILE_HANDLER);
        DATA_HANDLERS.add(GUI_NUMBER_TO_TILE_HANDLER);
        DATA_HANDLERS.add(CHANGE_PLAYER_DATA_HANDLER);
        DATA_HANDLERS.add(PLAYER_DATA_TO_CLIENT_HANDLER);
        DATA_HANDLERS.add(GUI_BUTTON_TO_CONTAINER_HANDLER);
    }

    static {
        DATA_HANDLERS = new ArrayList<IDataHandler>();
        PARTICLE_HANDLER = new IDataHandler(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void handleData(NBTTagCompound compound) {
                AssetUtil.renderParticlesFromAToB(compound.func_74769_h("StartX"), compound.func_74769_h("StartY"), compound.func_74769_h("StartZ"), compound.func_74769_h("EndX"), compound.func_74769_h("EndY"), compound.func_74769_h("EndZ"), compound.func_74762_e("ParticleAmount"), compound.func_74760_g("ParticleSize"), new float[]{compound.func_74760_g("Color1"), compound.func_74760_g("Color2"), compound.func_74760_g("Color3")}, compound.func_74760_g("AgeMultiplier"));
            }
        };
        TILE_ENTITY_HANDLER = new IDataHandler(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void handleData(NBTTagCompound compound) {
                TileEntity tile;
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                if (world != null && (tile = world.func_175625_s(new BlockPos(compound.func_74762_e("X"), compound.func_74762_e("Y"), compound.func_74762_e("Z")))) != null && tile instanceof TileEntityBase) {
                    ((TileEntityBase)tile).receiveSyncCompound(compound.func_74775_l("Data"));
                }
            }
        };
        GUI_BUTTON_TO_TILE_HANDLER = new IDataHandler(){

            @Override
            public void handleData(NBTTagCompound compound) {
                WorldServer world = DimensionManager.getWorld((int)compound.func_74762_e("WorldID"));
                TileEntity tile = world.func_175625_s(new BlockPos(compound.func_74762_e("X"), compound.func_74762_e("Y"), compound.func_74762_e("Z")));
                if (tile instanceof IButtonReactor) {
                    IButtonReactor reactor = (IButtonReactor)tile;
                    Entity entity = world.func_73045_a(compound.func_74762_e("PlayerID"));
                    if (entity != null && entity instanceof EntityPlayer) {
                        reactor.onButtonPressed(compound.func_74762_e("ButtonID"), (EntityPlayer)entity);
                    }
                }
            }
        };
        GUI_BUTTON_TO_CONTAINER_HANDLER = new IDataHandler(){

            @Override
            public void handleData(NBTTagCompound compound) {
                Container container;
                WorldServer world = DimensionManager.getWorld((int)compound.func_74762_e("WorldID"));
                Entity entity = world.func_73045_a(compound.func_74762_e("PlayerID"));
                if (entity != null && entity instanceof EntityPlayer && (container = ((EntityPlayer)entity).field_71070_bA) != null && container instanceof IButtonReactor) {
                    ((IButtonReactor)container).onButtonPressed(compound.func_74762_e("ButtonID"), (EntityPlayer)entity);
                }
            }
        };
        GUI_NUMBER_TO_TILE_HANDLER = new IDataHandler(){

            @Override
            public void handleData(NBTTagCompound compound) {
                WorldServer world = DimensionManager.getWorld((int)compound.func_74762_e("WorldID"));
                TileEntity tile = world.func_175625_s(new BlockPos(compound.func_74762_e("X"), compound.func_74762_e("Y"), compound.func_74762_e("Z")));
                if (tile instanceof INumberReactor) {
                    INumberReactor reactor = (INumberReactor)tile;
                    reactor.onNumberReceived(compound.func_74762_e("Number"), compound.func_74762_e("NumberID"), (EntityPlayer)world.func_73045_a(compound.func_74762_e("PlayerID")));
                }
            }
        };
        GUI_STRING_TO_TILE_HANDLER = new IDataHandler(){

            @Override
            public void handleData(NBTTagCompound compound) {
                WorldServer world = DimensionManager.getWorld((int)compound.func_74762_e("WorldID"));
                TileEntity tile = world.func_175625_s(new BlockPos(compound.func_74762_e("X"), compound.func_74762_e("Y"), compound.func_74762_e("Z")));
                if (tile instanceof IStringReactor) {
                    IStringReactor reactor = (IStringReactor)tile;
                    reactor.onTextReceived(compound.func_74779_i("Text"), compound.func_74762_e("TextID"), (EntityPlayer)world.func_73045_a(compound.func_74762_e("PlayerID")));
                }
            }
        };
        PLAYER_DATA_TO_CLIENT_HANDLER = new IDataHandler(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void handleData(NBTTagCompound compound) {
                NBTTagCompound data = compound.func_74775_l("Data");
                UUID id = compound.func_186857_a("UUID");
                PlayerData.getDataFromPlayer((UUID)id).theCompound = data;
                if (compound.func_74767_n("Log")) {
                    ModUtil.LOGGER.info("Receiving Player Data for current player with UUID " + id + " with info " + data + ".");
                }
            }
        };
        BOOKLET_STAND_BUTTON_HANDLER = new IDataHandler(){

            @Override
            public void handleData(NBTTagCompound compound) {
                WorldServer world = DimensionManager.getWorld((int)compound.func_74762_e("WorldID"));
                TileEntity tile = world.func_175625_s(new BlockPos(compound.func_74762_e("X"), compound.func_74762_e("Y"), compound.func_74762_e("Z")));
                EntityPlayer player = (EntityPlayer)world.func_73045_a(compound.func_74762_e("PlayerID"));
                if (player != null && tile instanceof TileEntityBookletStand) {
                    TileEntityBookletStand stand = (TileEntityBookletStand)tile;
                    if (player.func_70005_c_() != null && player.func_70005_c_().equalsIgnoreCase(stand.assignedPlayer)) {
                        stand.assignedEntry = EntrySet.readFromNBT(compound.func_74775_l("EntrySet"));
                        stand.func_70296_d();
                        stand.sendUpdate();
                    }
                }
            }
        };
        CHANGE_PLAYER_DATA_HANDLER = new IDataHandler(){

            @Override
            public void handleData(NBTTagCompound compound) {
                NBTTagCompound data = compound.func_74775_l("Data");
                WorldServer world = DimensionManager.getWorld((int)compound.func_74762_e("WorldID"));
                EntityPlayer player = (EntityPlayer)world.func_73045_a(compound.func_74762_e("PlayerID"));
                if (player != null) {
                    PlayerData.PlayerSave playerData = PlayerData.getDataFromPlayer(player);
                    playerData.theCompound.func_179237_a(data);
                    if (player instanceof EntityPlayerMP) {
                        PacketHandlerHelper.sendPlayerDataToClientPacket(player, playerData.theCompound, false);
                    }
                }
            }
        };
    }
}

