/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc;

import de.ellpeck.actuallyadditions.api.booklet.BookletPage;
import de.ellpeck.actuallyadditions.api.booklet.IBookletChapter;
import de.ellpeck.actuallyadditions.api.booklet.IBookletEntry;
import de.ellpeck.actuallyadditions.api.internal.IAtomicReconstructor;
import de.ellpeck.actuallyadditions.api.internal.IMethodHandler;
import de.ellpeck.actuallyadditions.api.recipe.CoffeeIngredient;
import de.ellpeck.actuallyadditions.api.recipe.LensConversionRecipe;
import de.ellpeck.actuallyadditions.mod.booklet.chapter.BookletChapter;
import de.ellpeck.actuallyadditions.mod.booklet.page.PageCrafting;
import de.ellpeck.actuallyadditions.mod.booklet.page.PageFurnace;
import de.ellpeck.actuallyadditions.mod.booklet.page.PagePicture;
import de.ellpeck.actuallyadditions.mod.booklet.page.PageTextOnly;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigBoolValues;
import de.ellpeck.actuallyadditions.mod.items.lens.LensRecipeHandler;
import de.ellpeck.actuallyadditions.mod.util.RecipeUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class MethodHandler
implements IMethodHandler {
    @Override
    public boolean addEffectToStack(ItemStack stack, CoffeeIngredient ingredient) {
        PotionEffect[] effects;
        boolean worked = false;
        if (ingredient != null && (effects = ingredient.getEffects()) != null && effects.length > 0) {
            for (PotionEffect effect : effects) {
                PotionEffect effectHas = this.getSameEffectFromStack(stack, effect);
                if (effectHas != null) {
                    if (effectHas.func_76458_c() >= ingredient.maxAmplifier - 1) continue;
                    this.addEffectProperties(stack, effect, false, true);
                    worked = true;
                    continue;
                }
                this.addEffectToStack(stack, effect);
                worked = true;
            }
        }
        return worked;
    }

    @Override
    public PotionEffect getSameEffectFromStack(ItemStack stack, PotionEffect effect) {
        PotionEffect[] effectsStack = this.getEffectsFromStack(stack);
        if (effectsStack != null && effectsStack.length > 0) {
            for (PotionEffect effectStack : effectsStack) {
                if (effect.func_188419_a() != effectStack.func_188419_a()) continue;
                return effectStack;
            }
        }
        return null;
    }

    @Override
    public void addEffectProperties(ItemStack stack, PotionEffect effect, boolean addDur, boolean addAmp) {
        PotionEffect[] effects = this.getEffectsFromStack(stack);
        stack.func_77982_d(new NBTTagCompound());
        for (int i = 0; i < effects.length; ++i) {
            if (effects[i].func_188419_a() == effect.func_188419_a()) {
                effects[i] = new PotionEffect(effects[i].func_188419_a(), effects[i].func_76459_b() + (addDur ? effect.func_76459_b() : 0), effects[i].func_76458_c() + (addAmp ? (effect.func_76458_c() > 0 ? effect.func_76458_c() : 1) : 0));
            }
            this.addEffectToStack(stack, effects[i]);
        }
    }

    @Override
    public void addEffectToStack(ItemStack stack, PotionEffect effect) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        int prevCounter = tag.func_74762_e("Counter");
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("ID", Potion.func_188409_a((Potion)effect.func_188419_a()));
        compound.func_74768_a("Duration", effect.func_76459_b());
        compound.func_74768_a("Amplifier", effect.func_76458_c());
        int counter = prevCounter + 1;
        tag.func_74782_a(counter + "", (NBTBase)compound);
        tag.func_74768_a("Counter", counter);
        stack.func_77982_d(tag);
    }

    @Override
    public PotionEffect[] getEffectsFromStack(ItemStack stack) {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            for (int counter = tag.func_74762_e("Counter"); counter > 0; --counter) {
                NBTTagCompound compound = (NBTTagCompound)tag.func_74781_a(counter + "");
                PotionEffect effect = new PotionEffect(Potion.func_188412_a((int)compound.func_74762_e("ID")), compound.func_74762_e("Duration"), (int)compound.func_74771_c("Amplifier"));
                effects.add(effect);
            }
        }
        return effects.size() > 0 ? effects.toArray(new PotionEffect[effects.size()]) : null;
    }

    @Override
    public boolean invokeConversionLens(IBlockState hitState, BlockPos hitBlock, IAtomicReconstructor tile) {
        if (hitBlock != null && !hitState.func_177230_c().isAir(hitState, (IBlockAccess)tile.getWorldObject(), hitBlock)) {
            int range = 2;
            for (int reachX = -range; reachX < range + 1; ++reachX) {
                for (int reachZ = -range; reachZ < range + 1; ++reachZ) {
                    block2: for (int reachY = -range; reachY < range + 1; ++reachY) {
                        BlockPos pos = new BlockPos(hitBlock.func_177958_n() + reachX, hitBlock.func_177956_o() + reachY, hitBlock.func_177952_p() + reachZ);
                        IBlockState state = tile.getWorldObject().func_180495_p(pos);
                        ArrayList<LensConversionRecipe> recipes = LensRecipeHandler.getRecipesFor(new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)));
                        for (LensConversionRecipe recipe : recipes) {
                            List<ItemStack> outputs;
                            if (recipe == null || recipe.type != tile.getLens() || tile.getEnergy() < recipe.energyUse || (outputs = RecipeUtil.getConversionLensOutputs(recipe)) == null || outputs.isEmpty()) continue;
                            ItemStack output = outputs.get(0);
                            if (output.func_77973_b() instanceof ItemBlock) {
                                if (!ConfigBoolValues.LESS_BLOCK_BREAKING_EFFECTS.isEnabled()) {
                                    tile.getWorldObject().func_175718_b(2001, pos, Block.func_176210_f((IBlockState)tile.getWorldObject().func_180495_p(pos)));
                                }
                                tile.getWorldObject().func_180501_a(pos, Block.func_149634_a((Item)output.func_77973_b()).func_176203_a(output.func_77952_i()), 2);
                            } else {
                                EntityItem item = new EntityItem(tile.getWorldObject(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, output.func_77946_l());
                                tile.getWorldObject().func_72838_d((Entity)item);
                            }
                            tile.extractEnergy(recipe.energyUse);
                            continue block2;
                        }
                    }
                }
            }
            ArrayList items = (ArrayList)tile.getWorldObject().func_72872_a(EntityItem.class, new AxisAlignedBB((double)(hitBlock.func_177958_n() - range), (double)(hitBlock.func_177956_o() - range), (double)(hitBlock.func_177952_p() - range), (double)(hitBlock.func_177958_n() + range), (double)(hitBlock.func_177956_o() + range), (double)(hitBlock.func_177952_p() + range)));
            block4: for (EntityItem item : items) {
                ItemStack stack = item.func_92059_d();
                if (item.field_70128_L || stack == null) continue;
                ArrayList<LensConversionRecipe> recipes = LensRecipeHandler.getRecipesFor(stack);
                for (LensConversionRecipe recipe : recipes) {
                    List<ItemStack> outputs;
                    if (recipe == null || recipe.type != tile.getLens() || tile.getEnergy() < recipe.energyUse * stack.field_77994_a || (outputs = RecipeUtil.getConversionLensOutputs(recipe)) == null || outputs.isEmpty()) continue;
                    ItemStack outputCopy = outputs.get(0).func_77946_l();
                    outputCopy.field_77994_a = stack.field_77994_a;
                    item.func_70106_y();
                    EntityItem newItem = new EntityItem(tile.getWorldObject(), item.field_70165_t, item.field_70163_u, item.field_70161_v, outputCopy);
                    tile.getWorldObject().func_72838_d((Entity)newItem);
                    tile.extractEnergy(recipe.energyUse * stack.field_77994_a);
                    continue block4;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public BookletPage generateTextPage(int id) {
        return new PageTextOnly(id);
    }

    @Override
    public BookletPage generatePicturePage(int id, ResourceLocation resLoc, int textStartY) {
        return new PagePicture(id, resLoc, textStartY);
    }

    @Override
    public BookletPage generateCraftingPage(int id, IRecipe ... recipes) {
        return new PageCrafting(id, recipes);
    }

    @Override
    public BookletPage generateFurnacePage(int id, ItemStack input, ItemStack result) {
        return new PageFurnace(id, input, result);
    }

    @Override
    public IBookletChapter generateBookletChapter(String identifier, IBookletEntry entry, ItemStack displayStack, BookletPage ... pages) {
        return new BookletChapter(identifier, entry, displayStack, pages);
    }
}

