/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc;

import de.ellpeck.actuallyadditions.api.laser.ConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.ILaserRelayConnectionHandler;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import io.netty.util.internal.ConcurrentSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class LaserRelayConnectionHandler
implements ILaserRelayConnectionHandler {
    public static NBTTagCompound writeNetworkToNBT(Network network) {
        NBTTagList list = new NBTTagList();
        for (ConnectionPair pair : network.connections) {
            list.func_74742_a((NBTBase)pair.writeToNBT());
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Network", (NBTBase)list);
        return compound;
    }

    public static Network readNetworkFromNBT(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("Network", 10);
        Network network = new Network();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            network.connections.add((Object)ConnectionPair.readFromNBT(list.func_150305_b(i)));
        }
        return network;
    }

    @Override
    public ConcurrentSet<ConnectionPair> getConnectionsFor(BlockPos relay, World world) {
        ConcurrentSet allPairs = new ConcurrentSet();
        for (Network aNetwork : WorldData.getDataForWorld((World)world).laserRelayNetworks) {
            for (ConnectionPair pair : aNetwork.connections) {
                if (!pair.contains(relay)) continue;
                allPairs.add((Object)pair);
            }
        }
        return allPairs;
    }

    @Override
    public void removeRelayFromNetwork(BlockPos relay, World world) {
        Network network = this.getNetworkFor(relay, world);
        if (network != null) {
            WorldData.getDataForWorld((World)world).laserRelayNetworks.remove((Object)network);
            for (ConnectionPair pair : network.connections) {
                if (pair.contains(relay)) continue;
                this.addConnection(pair.positions[0], pair.positions[1], world, pair.suppressConnectionRender);
            }
        }
    }

    @Override
    public Network getNetworkFor(BlockPos relay, World world) {
        for (Network aNetwork : WorldData.getDataForWorld((World)world).laserRelayNetworks) {
            for (ConnectionPair pair : aNetwork.connections) {
                if (!pair.contains(relay)) continue;
                return aNetwork;
            }
        }
        return null;
    }

    @Override
    public boolean addConnection(BlockPos firstRelay, BlockPos secondRelay, World world) {
        return this.addConnection(firstRelay, secondRelay, world, false);
    }

    @Override
    public boolean addConnection(BlockPos firstRelay, BlockPos secondRelay, World world, boolean suppressConnectionRender) {
        if (firstRelay == null || secondRelay == null || firstRelay == secondRelay || firstRelay.equals((Object)secondRelay)) {
            return false;
        }
        Network firstNetwork = this.getNetworkFor(firstRelay, world);
        Network secondNetwork = this.getNetworkFor(secondRelay, world);
        if (firstNetwork == null && secondNetwork == null) {
            firstNetwork = new Network();
            WorldData.getDataForWorld((World)world).laserRelayNetworks.add((Object)firstNetwork);
            firstNetwork.connections.add((Object)new ConnectionPair(firstRelay, secondRelay, suppressConnectionRender));
        } else {
            if (firstNetwork == secondNetwork) {
                return false;
            }
            if (firstNetwork != null && secondNetwork != null) {
                LaserRelayConnectionHandler.mergeNetworks(firstNetwork, secondNetwork, world);
                firstNetwork.connections.add((Object)new ConnectionPair(firstRelay, secondRelay, suppressConnectionRender));
            } else if (firstNetwork != null) {
                firstNetwork.connections.add((Object)new ConnectionPair(firstRelay, secondRelay, suppressConnectionRender));
            } else {
                secondNetwork.connections.add((Object)new ConnectionPair(firstRelay, secondRelay, suppressConnectionRender));
            }
        }
        return true;
    }

    private static void mergeNetworks(Network firstNetwork, Network secondNetwork, World world) {
        for (ConnectionPair secondPair : secondNetwork.connections) {
            firstNetwork.connections.add((Object)secondPair);
        }
        WorldData.getDataForWorld((World)world).laserRelayNetworks.remove((Object)secondNetwork);
    }
}

