/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.jei.reconstructor;

import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.jei.reconstructor.ReconstructorRecipeWrapper;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import de.ellpeck.actuallyadditions.mod.util.RecipeUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class ReconstructorRecipeCategory
implements IRecipeCategory {
    public static final String NAME = "actuallyadditions.reconstructor";
    private static final ItemStack RECONSTRUCTOR = new ItemStack(InitBlocks.blockAtomicReconstructor);
    private final IDrawable background;

    public ReconstructorRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(AssetUtil.getGuiLocation("guiNEIAtomicReconstructor"), 0, 0, 96, 60);
    }

    public String getUid() {
        return NAME;
    }

    public String getTitle() {
        return StringUtil.localize("container.nei.actuallyadditions.reconstructor.name");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        AssetUtil.renderStackToGui(RECONSTRUCTOR, 34, 19, 1.0f);
    }

    public void drawAnimations(Minecraft minecraft) {
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper) {
        if (recipeWrapper instanceof ReconstructorRecipeWrapper) {
            ReconstructorRecipeWrapper wrapper = (ReconstructorRecipeWrapper)recipeWrapper;
            recipeLayout.getItemStacks().init(0, true, 4, 18);
            recipeLayout.getItemStacks().set(0, RecipeUtil.getConversionLensInputs(wrapper.theRecipe));
            recipeLayout.getItemStacks().init(1, false, 66, 18);
            recipeLayout.getItemStacks().set(1, RecipeUtil.getConversionLensOutputs(wrapper.theRecipe));
        }
    }
}

